/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.NestedModel;
import com.vmware.vise.data.query.commands.Property;
import com.vmware.vise.data.query.commands.Relationship;
import com.vmware.vise.data.query.commands.impl.FieldMetadata;
import com.vmware.vise.data.query.type;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class DataModelMetadata<T extends DataModel> {
    private final Class<T> _classDefinition;
    private final List<FieldMetadata> _fieldMetadataList = new ArrayList<FieldMetadata>();
    private final String _targetType;

    public DataModelMetadata(Class<T> clazz) {
        Field[] fieldArray;
        if (clazz == null) {
            throw new IllegalArgumentException("The data model class can not be null.");
        }
        this._classDefinition = clazz;
        type type2 = clazz.getAnnotation(type.class);
        this._targetType = type2 != null ? type2.value() : null;
        for (Field field : fieldArray = clazz.getFields()) {
            if (!DataModelMetadata.shouldFieldBeParsed(field)) continue;
            FieldMetadata fieldMetadata = new FieldMetadata(field);
            this._fieldMetadataList.add(fieldMetadata);
        }
    }

    public Class<T> getDataModelClass() {
        return this._classDefinition;
    }

    public List<FieldMetadata> getFieldMatadata() {
        return this._fieldMetadataList;
    }

    public String getTargetType() {
        return this._targetType;
    }

    private static boolean shouldFieldBeParsed(Field field) {
        boolean bl = field.isAnnotationPresent(Property.class);
        boolean bl2 = field.isAnnotationPresent(NestedModel.class);
        boolean bl3 = field.isAnnotationPresent(Relationship.class);
        if (bl && bl2) {
            throw new IllegalArgumentException("The field can not have both @Property and @NestedModel.");
        }
        return bl || bl2 || bl3;
    }
}

