/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.commands.impl.BooleanTransformer;
import com.vmware.vise.data.query.commands.impl.DoubleTransformer;
import com.vmware.vise.data.query.commands.impl.FloatTransformer;
import com.vmware.vise.data.query.commands.impl.IntegerTransformer;
import com.vmware.vise.data.query.commands.impl.LongTransformer;
import com.vmware.vise.data.query.commands.impl.StringTransformer;
import com.vmware.vise.data.query.commands.impl.Transformer;
import java.util.HashMap;
import java.util.Map;

public class PropertyValueHelper {
    private static final Map<Class<?>, Transformer> _transformers = new HashMap();
    private final boolean _useDefaultWhenNull;
    private final boolean _useDefaultWhenTypeMismatch;

    public PropertyValueHelper(boolean bl, boolean bl2) {
        this._useDefaultWhenNull = bl;
        this._useDefaultWhenTypeMismatch = bl2;
    }

    public Object getPropertyValue(String string, Object object, Class<?> clazz) {
        if (clazz == null) {
            return object;
        }
        Transformer transformer = _transformers.get(clazz);
        if (transformer == null) {
            return object;
        }
        return transformer.value(string, object, this._useDefaultWhenNull, this._useDefaultWhenTypeMismatch);
    }

    static {
        _transformers.put(Integer.class, new IntegerTransformer());
        _transformers.put(Long.class, new LongTransformer());
        _transformers.put(Float.class, new FloatTransformer());
        _transformers.put(Double.class, new DoubleTransformer());
        _transformers.put(Boolean.class, new BooleanTransformer());
        _transformers.put(Integer.TYPE, _transformers.get(Integer.class));
        _transformers.put(Long.TYPE, _transformers.get(Long.class));
        _transformers.put(Float.TYPE, _transformers.get(Float.class));
        _transformers.put(Double.TYPE, _transformers.get(Double.class));
        _transformers.put(Boolean.TYPE, _transformers.get(Boolean.class));
        _transformers.put(String.class, new StringTransformer());
    }
}

