/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.commands.impl;

import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.impl.DataModelMetadata;
import com.vmware.vise.data.query.commands.impl.FieldMetadata;
import com.vmware.vise.data.query.commands.impl.PropertyValueHelper;
import com.vmware.vise.data.query.commands.impl.ReflectionUtil;
import com.vmware.vise.data.query.commands.impl.RelationshipMetadata;
import com.vmware.vise.data.query.commands.impl.RequestProcessor;
import com.vmware.vise.util.StringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseProcessor<T extends DataModel> {
    private static Log _logger = LogFactory.getLog(DataFetchCommandFactory.class);
    private static final PropertyValueHelper _valueHelper = new PropertyValueHelper(true, true);
    private final RequestProcessor<T> _requestProcessor;
    private final Response _response = new Response();

    public ResponseProcessor(RequestProcessor<T> requestProcessor, ResultSet[] resultSetArray) {
        this._requestProcessor = requestProcessor;
        this.processResultSets(resultSetArray);
    }

    public List<T> getDataModelInstances() {
        return this._response._dataModels;
    }

    public Exception getError() {
        return this._response._error;
    }

    public List<FacetInfo> getFacetInfo() {
        return this._response._facetInfo;
    }

    public int getTotalResultCount() {
        return this._response._totalResultCount;
    }

    protected static Exception extractFirstError(ResultSet[] resultSetArray) {
        for (ResultSet resultSet : resultSetArray) {
            if (resultSet.error == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error in result set for ");
            stringBuffer.append(resultSet.queryName);
            stringBuffer.append(" returned by DataService: ");
            stringBuffer.append(resultSet.error);
            _logger.warn((Object)stringBuffer.toString());
            return resultSet.error;
        }
        return null;
    }

    private static String getRefUid(Object object) {
        try {
            return QueryUtil.getReferenceUid(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private T createItem(DataModelMetadata<T> dataModelMetadata, Object object, ResultContainer resultContainer) {
        Class<T> clazz = dataModelMetadata.getDataModelClass();
        T t = ReflectionUtil.instantiateDataObject(clazz);
        ((DataModel)t).provider = object;
        for (FieldMetadata fieldMetadata : dataModelMetadata.getFieldMatadata()) {
            String string;
            Object object2;
            if (fieldMetadata.getRelationships() == null) {
                object2 = this.getPropertyValue(object, fieldMetadata, resultContainer);
                ReflectionUtil.setField(t, fieldMetadata.getField(), object2);
                continue;
            }
            object2 = this.getRelatedObject(object, fieldMetadata, resultContainer);
            if (object2 == null) {
                string = fieldMetadata.getField().getName();
                _logger.warn((Object)("The related object of field: " + string + " is null."));
                continue;
            }
            string = ResponseProcessor.getRefUid(object2);
            if (string != null) {
                this.handleSingleCardinalityRelationship(t, fieldMetadata, resultContainer, object2);
                continue;
            }
            if (object2 == null || !object2.getClass().isArray()) continue;
            this.handleMultiCardinalityRelationship(t, fieldMetadata, resultContainer, object2);
        }
        return t;
    }

    private Object getPropertyValue(Object object, FieldMetadata fieldMetadata, ResultContainer resultContainer) {
        if (fieldMetadata.getNestedModel() != null) {
            return this.createItem(fieldMetadata.getNestedModel(), object, resultContainer);
        }
        String string = fieldMetadata.getPropertyName();
        if (StringUtil.isNullOrEmpty((String)string)) {
            return object;
        }
        Class<?> clazz = fieldMetadata.getField().getType();
        return resultContainer.getPropertyValue(object, string, clazz);
    }

    private Object getRelatedObject(Object object, FieldMetadata fieldMetadata, ResultContainer resultContainer) {
        Object object2 = object;
        for (RelationshipMetadata relationshipMetadata : fieldMetadata.getRelationships()) {
            Object object3 = object2;
            if (ResponseProcessor.getRefUid(object3) == null) {
                return null;
            }
            object2 = resultContainer.getPropertyValue(object3, relationshipMetadata.getRelation(), null);
        }
        return object2;
    }

    private ResultSet getResultSetByQueryIdx(ResultSet[] resultSetArray, int n) {
        List<QuerySpec> list = this._requestProcessor.getQuerySpecs();
        if (n >= list.size()) {
            return null;
        }
        String string = list.get((int)n).name;
        for (ResultSet resultSet : resultSetArray) {
            if (resultSet.queryName != string) continue;
            return resultSet;
        }
        return null;
    }

    private void handleMultiCardinalityRelationship(T t, FieldMetadata fieldMetadata, ResultContainer resultContainer, Object object) {
        Object[] objectArray = (Object[])object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : objectArray) {
            if (!resultContainer.containsObject(object2)) {
                _logger.debug((Object)("Related object not returned by DataService: " + object2));
                continue;
            }
            arrayList.add(this.getPropertyValue(object2, fieldMetadata, resultContainer));
        }
        this.setMultiCardinalityValues(t, fieldMetadata.getField(), arrayList);
    }

    private void handleSingleCardinalityRelationship(T t, FieldMetadata fieldMetadata, ResultContainer resultContainer, Object object) {
        if (resultContainer.containsObject(object)) {
            Object object2 = this.getPropertyValue(object, fieldMetadata, resultContainer);
            ReflectionUtil.setField(t, fieldMetadata.getField(), object2);
        } else {
            _logger.debug((Object)("Related object not returned by DataService: " + object));
        }
    }

    private void processResultSets(ResultSet[] resultSetArray) {
        ResultSet resultSet = this.getResultSetByQueryIdx(resultSetArray, 0);
        ResultSet resultSet2 = this.getResultSetByQueryIdx(resultSetArray, 1);
        this._response._error = ResponseProcessor.extractFirstError(resultSetArray);
        if (resultSet == null || resultSet.items == null) {
            if (resultSet == null) {
                _logger.debug((Object)"Null mainResultSet retrieved");
            } else {
                _logger.debug((Object)"Null mainResultSet.items retrieved");
            }
            return;
        }
        ResultContainer resultContainer = new ResultContainer();
        if (resultSet2 != null) {
            resultContainer.addResultSet(resultSet2);
        }
        for (ResultItem resultItem : resultSet.items) {
            resultContainer.addResultItem(resultItem);
            this._response._dataModels.add(this.createItem(this._requestProcessor.getDataModelMetadata(), resultItem.resourceObject, resultContainer));
            resultContainer.removeResultItem(resultItem);
        }
        this._response._facetInfo.addAll(Arrays.asList(resultSet.facets));
        this._response._totalResultCount = resultSet.totalMatchedObjectCount;
    }

    private void setMultiCardinalityValues(T t, Field field, List<Object> list) {
        Class<?> clazz = field.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
            Object object = Array.newInstance(clazz, list.size());
            int n = 0;
            for (Object object2 : list) {
                Array.set(object, n++, object2);
            }
            ReflectionUtil.setField(t, field, object);
        }
    }

    final class ResultContainer {
        private final Map<String, Map<String, Object>> _propertiesByObject = new HashMap<String, Map<String, Object>>();

        private ResultContainer() {
        }

        private void addResultItem(ResultItem resultItem) {
            String string = ResponseProcessor.getRefUid(resultItem.resourceObject);
            if (this._propertiesByObject.get(string) == null) {
                this._propertiesByObject.put(string, new HashMap());
            }
            Map<String, Object> map = this._propertiesByObject.get(string);
            for (PropertyValue propertyValue : resultItem.properties) {
                map.put(propertyValue.propertyName, propertyValue.value);
            }
        }

        private void addResultSet(ResultSet resultSet) {
            for (ResultItem resultItem : resultSet.items) {
                this.addResultItem(resultItem);
            }
        }

        private boolean containsObject(Object object) {
            String string = ResponseProcessor.getRefUid(object);
            return this._propertiesByObject.get(string) != null;
        }

        private Object getPropertyValue(Object object, String string, Class<?> clazz) {
            String string2 = ResponseProcessor.getRefUid(object);
            Map<String, Object> map = this._propertiesByObject.get(string2);
            if (map == null) {
                _logger.error((Object)("Server object properties not returned by Data Service for " + string2));
                return null;
            }
            Object object2 = map.get(string);
            return _valueHelper.getPropertyValue(string, object2, clazz);
        }

        private void removeResultItem(ResultItem resultItem) {
            String string = ResponseProcessor.getRefUid(resultItem.resourceObject);
            this._propertiesByObject.remove(string);
        }
    }

    final class Response {
        private final List<T> _dataModels = new ArrayList();
        private Exception _error = null;
        private final List<FacetInfo> _facetInfo = new ArrayList<FacetInfo>();
        private int _totalResultCount = 0;

        Response() {
        }
    }
}

