/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.collection.DepthFirstTreeIterator;
import com.vmware.vise.util.collection.Node;
import com.vmware.vise.util.collection.Tree;
import com.vmware.vise.util.collection.TreeIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ConstraintTree
implements Tree<Constraint>,
Cloneable {
    private Node<Constraint> _root;

    public ConstraintTree(Constraint constraint) {
        ConstraintNode constraintNode;
        this._root = constraintNode = new ConstraintNode(constraint);
    }

    private ConstraintTree(Node<Constraint> node) {
        this._root = node;
    }

    public Node<Constraint> getRoot() {
        return this._root;
    }

    public void setRoot(Node<Constraint> node) {
        this._root = node;
    }

    public TreeIterator<Constraint> iterator() {
        return new DepthFirstTreeIterator((Tree)this);
    }

    public ConstraintTree clone() {
        Node<Constraint> node = this.copy(this._root);
        return new ConstraintTree(node);
    }

    private Node<Constraint> copy(Node<Constraint> node) {
        List list = node.getChildren();
        ArrayList<Node<Constraint>> arrayList = new ArrayList<Node<Constraint>>(list.size());
        for (Node node2 : list) {
            Node<Constraint> node3 = this.copy((Node<Constraint>)node2);
            arrayList.add(node3);
        }
        Iterator iterator = this.newNode(node, arrayList);
        return iterator;
    }

    private Node<Constraint> newNode(Node<Constraint> node, Collection<Node<Constraint>> collection) {
        Constraint constraint = (Constraint)node.getData();
        Constraint constraint2 = (Constraint)ObjectUtil.shallowCopy((Object)constraint, constraint.getClass());
        ConstraintNode constraintNode = new ConstraintNode(constraint2);
        constraintNode.clearChildren();
        for (Node<Constraint> node2 : collection) {
            constraintNode.appendChild(node2);
        }
        return constraintNode;
    }

    public static class ConstraintNode
    implements Node<Constraint> {
        private final Constraint _constraint;
        private Node<Constraint> _parent;

        public ConstraintNode(Constraint constraint) {
            this._constraint = constraint;
        }

        public Constraint getData() {
            return this._constraint;
        }

        public Node<Constraint> getParent() {
            return this._parent;
        }

        public void setParent(Node<Constraint> node) {
            this._parent = node;
        }

        public void appendChild(Node<Constraint> node) {
            ConstraintNode.addChild(this.getData(), (Constraint)node.getData());
            node.setParent((Node)this);
        }

        public void removeChild(Node<Constraint> node) {
            ConstraintNode.removeChild(this.getData(), (Constraint)node.getData());
            node.setParent(null);
        }

        public void clearChildren() {
            List<Node<Constraint>> list = this.getChildren();
            ConstraintNode.clearChildren(this.getData());
            ConstraintNode.unregisterParent(list);
        }

        public Node<Constraint> getChild(int n) {
            List<Node<Constraint>> list = this.getChildren();
            return list.get(n);
        }

        public void setChild(int n, Node<Constraint> node) {
            ConstraintNode.setChild(this.getData(), n, (Constraint)node.getData());
            node.setParent((Node)this);
        }

        public List<Node<Constraint>> getChildren() {
            Constraint[] constraintArray = ConstraintNode.getChildren(this._constraint);
            List<Node<Constraint>> list = ConstraintNode.toConstraintNodes(constraintArray);
            ConstraintNode.registerParent(list, this);
            return Collections.unmodifiableList(list);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ConstraintNode)) {
                return false;
            }
            Constraint constraint = ((ConstraintNode)object).getData();
            return this._constraint.equals(constraint);
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this._constraint.hashCode();
            return n;
        }

        private static List<Node<Constraint>> toConstraintNodes(Constraint[] constraintArray) {
            ArrayList<Node<Constraint>> arrayList = new ArrayList<Node<Constraint>>(constraintArray.length);
            for (Constraint constraint : constraintArray) {
                arrayList.add(new ConstraintNode(constraint));
            }
            return arrayList;
        }

        private static void registerParent(Collection<Node<Constraint>> collection, Node<Constraint> node) {
            for (Node<Constraint> node2 : collection) {
                node2.setParent(node);
            }
        }

        private static void unregisterParent(Collection<Node<Constraint>> collection) {
            for (Node<Constraint> node : collection) {
                node.setParent(null);
            }
        }

        private static Constraint[] getChildren(Constraint constraint) {
            if (constraint instanceof CompositeConstraint) {
                CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
                return compositeConstraint.nestedConstraints;
            }
            if (constraint instanceof RelationalConstraint) {
                RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
                return new Constraint[]{relationalConstraint.constraintOnRelatedObject};
            }
            return new Constraint[0];
        }

        private static void addChild(Constraint constraint, Constraint constraint2) {
            if (constraint instanceof CompositeConstraint) {
                CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
                Constraint[] constraintArray = Arrays.copyOf(compositeConstraint.nestedConstraints, compositeConstraint.nestedConstraints.length + 1);
                constraintArray[constraintArray.length - 1] = constraint2;
                compositeConstraint.nestedConstraints = constraintArray;
            } else if (constraint instanceof RelationalConstraint) {
                RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
                relationalConstraint.constraintOnRelatedObject = constraint2;
            } else {
                throw new UnsupportedOperationException("Cannot perform this operation on leaf constraint.");
            }
        }

        private static void removeChild(Constraint constraint, Constraint constraint2) {
            if (constraint instanceof CompositeConstraint) {
                CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
                Constraint[] constraintArray = new Constraint[compositeConstraint.nestedConstraints.length - 1];
                int n = 0;
                for (Constraint constraint3 : compositeConstraint.nestedConstraints) {
                    if (constraint3.equals(constraint2)) continue;
                    constraintArray[n++] = constraint3;
                }
                compositeConstraint.nestedConstraints = constraintArray;
            } else if (constraint instanceof RelationalConstraint) {
                RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
                if (relationalConstraint.constraintOnRelatedObject.equals(constraint2)) {
                    relationalConstraint.constraintOnRelatedObject = null;
                }
            } else {
                throw new UnsupportedOperationException("Cannot perform this operation on leaf constraint.");
            }
        }

        private static void setChild(Constraint constraint, int n, Constraint constraint2) {
            if (constraint instanceof CompositeConstraint) {
                CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
                if (n < 0 || n >= compositeConstraint.nestedConstraints.length) {
                    throw new IllegalArgumentException("Invalid is out of range.");
                }
                compositeConstraint.nestedConstraints[n] = constraint2;
            } else if (constraint instanceof RelationalConstraint) {
                RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
                if (n != 0) {
                    throw new IllegalArgumentException("Invalid is out of range.");
                }
                relationalConstraint.constraintOnRelatedObject = constraint2;
            } else {
                throw new UnsupportedOperationException("Cannot perform this operation on leaf constraint.");
            }
        }

        private static void clearChildren(Constraint constraint) {
            if (constraint instanceof CompositeConstraint) {
                CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
                compositeConstraint.nestedConstraints = new Constraint[0];
            } else if (constraint instanceof RelationalConstraint) {
                RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
                relationalConstraint.constraintOnRelatedObject = null;
            }
        }
    }
}

