/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataServiceAdapterRegistrar {
    private static final Log _logger = LogFactory.getLog(DataServiceAdapterRegistrar.class);
    private boolean _initialized = false;
    private DataServiceExtensionRegistry _extensionRegistry;
    private final ServiceRegistry _serviceRegistry;

    public DataServiceAdapterRegistrar(DataServiceExtensionRegistry dataServiceExtensionRegistry, ServiceRegistry serviceRegistry) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataServiceExtensionRegistry, serviceRegistry});
        this._extensionRegistry = dataServiceExtensionRegistry;
        this._serviceRegistry = serviceRegistry;
        this.initialize();
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        ServiceListener serviceListener = new ServiceListener(){

            public void serviceAdded(Object object) {
                DataServiceAdapterRegistrar.this.registerService(object, true);
            }

            public void serviceRemoved(Object object) {
                DataServiceAdapterRegistrar.this.unregisterService(object, true);
            }
        };
        ServiceListener serviceListener2 = new ServiceListener(){

            public void serviceAdded(Object object) {
                DataServiceAdapterRegistrar.this.registerService(object, false);
            }

            public void serviceRemoved(Object object) {
                DataServiceAdapterRegistrar.this.unregisterService(object, false);
            }
        };
        this._serviceRegistry.registerServiceListener(PropertyProviderBean.class.getName(), serviceListener);
        this._serviceRegistry.registerServiceListener(DataProviderAdapter.class.getName(), serviceListener2);
        this._initialized = true;
    }

    private synchronized void unregisterService(Object object, boolean bl) {
        Object object2;
        if (object instanceof DataProviderAdapter) {
            object2 = (DataProviderAdapter)object;
            this._extensionRegistry.unregisterDataAdapter((DataProviderAdapter)object2);
        }
        if (object instanceof PropertyProviderAdapter) {
            object2 = (PropertyProviderAdapter)object;
            this._extensionRegistry.unregisterDataAdapter((PropertyProviderAdapter)object2);
        }
    }

    private synchronized void registerService(Object object, boolean bl) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Registering service " + object));
        }
        if (bl) {
            ServicePropertyProviderAdapter servicePropertyProviderAdapter = new ServicePropertyProviderAdapter((PropertyProviderBean)object);
            this._extensionRegistry.registerDataAdapter(servicePropertyProviderAdapter, servicePropertyProviderAdapter.getProvidedTypeInfos());
        } else {
            DataAdapterAnnotationProcessor dataAdapterAnnotationProcessor = new DataAdapterAnnotationProcessor((DataProviderAdapter)object);
            if (dataAdapterAnnotationProcessor.isTypeAnnotationPresent() || object instanceof DynamicProviderAdapter) {
                this._extensionRegistry.registerDataAdapter((DataProviderAdapter)object, dataAdapterAnnotationProcessor.getTypes());
            }
        }
    }

    private static class DataAdapterAnnotationProcessor {
        private final DataProviderAdapter _adapter;
        private String[] _annotatedTypes;

        public DataAdapterAnnotationProcessor(DataProviderAdapter dataProviderAdapter) {
            assert (dataProviderAdapter != null);
            this._adapter = dataProviderAdapter;
            this.init();
        }

        public boolean isTypeAnnotationPresent() {
            return this._annotatedTypes != null && this._annotatedTypes.length > 0;
        }

        public String[] getTypes() {
            return this._annotatedTypes;
        }

        private void init() {
            Annotation[] annotationArray;
            ModelMetadata modelMetadata = this._adapter.getClass().getAnnotation(ModelMetadata.class);
            this.processModelAnnotation(modelMetadata);
            for (Annotation annotation : annotationArray = this._adapter.getClass().getAnnotations()) {
                if (!type.class.isInstance(annotation)) continue;
                this.processTypeAnnotation((type)annotation);
            }
        }

        private void processTypeAnnotation(type type2) {
            assert (type2 != null);
            String string = type2.value();
            if (this._annotatedTypes != null && this._annotatedTypes.length > 0) {
                _logger.warn((Object)("Ignoring extra type annotation " + string + " for " + this._adapter));
                return;
            }
            if (string == null || string.length() == 0) {
                if (this._adapter instanceof DynamicProviderAdapter) {
                    this._annotatedTypes = new String[0];
                } else {
                    _logger.warn((Object)("No value defined in type annotation found on " + this._adapter));
                }
                return;
            }
            this._annotatedTypes = string.split(",");
            for (int i = 0; i < this._annotatedTypes.length; ++i) {
                this._annotatedTypes[i] = this._annotatedTypes[i].trim();
            }
        }

        private void processModelAnnotation(ModelMetadata modelMetadata) {
            if (modelMetadata == null) {
                return;
            }
            Object[] objectArray = modelMetadata.type();
            if (!ArrayUtil.isNullOrEmpty((Object[])this._annotatedTypes)) {
                _logger.warn((Object)("Ignoring extra ModelMetadata annotation " + objectArray + " for " + this._adapter));
                return;
            }
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                if (this._adapter instanceof DynamicProviderAdapter) {
                    this._annotatedTypes = new String[0];
                } else {
                    _logger.warn((Object)("No types defined in ModelMapping annotation found on " + this._adapter));
                }
                return;
            }
            this._annotatedTypes = objectArray;
        }
    }
}

