/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceException;
import com.vmware.vise.data.query.DerivedPropertyDataInternal;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.BatchedQueryReducer;
import com.vmware.vise.data.query.impl.DataAdaptersExecutionResult;
import com.vmware.vise.data.query.impl.DataManager;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.FormattingResultTransformer;
import com.vmware.vise.data.query.impl.PropertyProvidersExecutionResult;
import com.vmware.vise.data.query.impl.QueryBatchReducer;
import com.vmware.vise.data.query.impl.RequestSpecNormalizer;
import com.vmware.vise.data.query.impl.RequestSpecValidator;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.data.query.impl.ResultsManager;
import com.vmware.vise.data.query.impl.SubTypeResolver;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ProfilingUtil;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.metadata.ObjectModelProviderRegistryInternal;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.profiling.ExecutionProfilerImpl;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServiceImpl
implements DataService {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceImpl.class);
    private final DataManager _dataManager;
    private static final String DATA_SERVICE_PREFIX = "dataService.";
    private static final String DATA_SERVICE_TOTAL_TIME_LABEL = "dataService.totalTime";
    private static final String QUERY_BATCH_REDUCTION_TIME_LABEL = "dataService.queryBatchReduction";
    private static final String QUERY_ENRICHMENT_TIME_LABEL = "dataService.queryEnrichment";
    private static final String DATA_ADAPTER_TIME_LABEL = "dataService.dataAdapters";
    private static final String PROPERTY_PROVIDER_ADAPTER_TIME_LABEL = "dataService.propertyProviderAdapters";
    private static final String DERIVED_PROPERTY_PROVIDER_ADAPTER_TIME_LABEL = "dataService.derivedPropertyProviderAdapters";
    private static final String REMAP_ENRICHED_QUERY_TIME_LABEL = "dataService.remapEnrichedQuery";
    private static final String FORMATTING_TIME_LABEL = "dataService.formatting";
    private static final String RESULT_ORDERING_TIME_LABEL = "dataService.resultOrdering";
    private static final String DATA_SERVICE_CALL_COUNTER = "dataServiceCallCounter";
    private final MetadataServiceRegistryInternal _metadataRegistry;
    private final List<Class<? extends BatchedQueryReducer>> _reducerClasses;
    private final boolean _enableProfiling;
    private final Long _dataRetrievalTimeoutInMillis;

    public DataServiceImpl(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal, MetadataServiceRegistryInternal metadataServiceRegistryInternal, ObjectModelProviderRegistryInternal objectModelProviderRegistryInternal, ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, SubTypeResolver subTypeResolver, List<String> list, boolean bl, long l) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataServiceExtensionRegistryInternal, metadataServiceRegistryInternal});
        QueryUtil.setDataServiceExtensionRegistry(dataServiceExtensionRegistryInternal);
        this._metadataRegistry = metadataServiceRegistryInternal;
        this._dataRetrievalTimeoutInMillis = l;
        this._dataManager = new DataManager(dataServiceExtensionRegistryInternal, this._metadataRegistry, objectModelProviderRegistryInternal, objectReferenceService, querySpecBuilder, subTypeResolver, this._dataRetrievalTimeoutInMillis);
        this._reducerClasses = DataServiceImpl.getReducerClasses(list);
        this._enableProfiling = bl;
    }

    public DataServiceImpl(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal, MetadataServiceRegistryInternal metadataServiceRegistryInternal, ObjectModelProviderRegistryInternal objectModelProviderRegistryInternal, ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, SubTypeResolver subTypeResolver) {
        this(dataServiceExtensionRegistryInternal, metadataServiceRegistryInternal, objectModelProviderRegistryInternal, objectReferenceService, querySpecBuilder, subTypeResolver, DataServiceImpl.getDefaultReducerClassNames(), false, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getData(RequestSpec requestSpec) {
        RequestSpecValidator.validateRequest(requestSpec);
        Utils.generateNamesForNamelessQueries(requestSpec.querySpec);
        RequestSpecNormalizer.normalizeResultSpec(requestSpec);
        ViseDsLogConfigurator.ViseDsLogContext viseDsLogContext = ViseDsLogConfigurator.onBatchStart();
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Start execution of query batch.");
            }
            Response response = this.getResponse(requestSpec);
            return response;
        }
        finally {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Finish execution of query batch.");
            }
            viseDsLogContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getResponse(RequestSpec requestSpec) {
        Response response = new Response();
        if (requestSpec.enableProfiling != null && requestSpec.enableProfiling.booleanValue()) {
            SessionUtil.enableProfiling();
        }
        ExecutionProfiler executionProfiler = SessionUtil.getExecutionProfiler();
        boolean bl = SessionUtil.isProfilingEnabled();
        ExecutionProfiler executionProfiler2 = this.getExecutionProfiler(bl);
        SessionUtil.setExecutionProfiler((ExecutionProfiler)executionProfiler2);
        Object object = executionProfiler2.startTimer(DATA_SERVICE_TOTAL_TIME_LABEL);
        try {
            response.resultSet = this.getResults(requestSpec.querySpec, executionProfiler2);
        }
        finally {
            executionProfiler2.stopTimer(object);
            executionProfiler.mergeProfilingResults(executionProfiler2);
            if (executionProfiler2.isEnabled()) {
                _logger.info("{}", (Object)executionProfiler2);
            }
            SessionUtil.setExecutionProfiler((ExecutionProfiler)executionProfiler);
        }
        if (response.resultSet != null) {
            if (bl) {
                response.executionTimeByDescription = executionProfiler2.getExecutionTimes();
            }
            this.logQueryInCaseOfError(requestSpec.querySpec, response.resultSet);
            return response;
        }
        Response response2 = new Response();
        response2.resultSet = QueryUtil.EMPTYSET;
        if (bl) {
            response2.executionTimeByDescription = executionProfiler2.getExecutionTimes();
        }
        return response2;
    }

    private void logQueryInCaseOfError(QuerySpec[] querySpecArray, ResultSet[] resultSetArray) {
        assert (querySpecArray.length == resultSetArray.length);
        for (int i = 0; i < resultSetArray.length; ++i) {
            ResultSet resultSet = resultSetArray[i];
            if (resultSet.error == null) continue;
            String string = Utils.renderQuerySpec(querySpecArray[i]);
            String string2 = String.format("Error occurred while executing query: %1$s", string);
            Exception exception = resultSet.error;
            _logger.error(string2, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private ResultSet[] getResults(QuerySpec[] querySpecArray, ExecutionProfiler executionProfiler) {
        ResultSet[] resultSetArray;
        if (querySpecArray == null || querySpecArray.length == 0) {
            return QueryUtil.EMPTYSET;
        }
        ProfilingUtil.logQSpecsIfMaxResultCountIsWrong(querySpecArray);
        if (_logger.isTraceEnabled()) {
            _logger.trace("QuerySpecs to execute:\n" + Utils.renderQuerySpecs(querySpecArray));
        }
        Object object = null;
        try {
            Map<QuerySpec, Pair<QuerySpec, DerivedPropertyDataInternal>> map;
            Object object22;
            long l = System.currentTimeMillis();
            object = executionProfiler.startTimer(QUERY_BATCH_REDUCTION_TIME_LABEL);
            List<BatchedQueryReducer> list = this.getReducers();
            QuerySpec[] querySpecArray2 = querySpecArray;
            for (Object object22 : list) {
                querySpecArray2 = object22.reduceBatch(querySpecArray2);
            }
            if (_logger.isTraceEnabled()) {
                map = new StringBuilder();
                ((StringBuilder)((Object)map)).append("original specs: " + querySpecArray + "\n");
                ((StringBuilder)((Object)map)).append("reduced specs " + querySpecArray2 + "\n");
                _logger.trace(((StringBuilder)((Object)map)).toString());
            }
            executionProfiler.stopTimer(object);
            object = executionProfiler.startTimer(QUERY_ENRICHMENT_TIME_LABEL);
            map = this._dataManager.enrichQueriesForDerivedProperties(querySpecArray2);
            object22 = map.keySet();
            executionProfiler.stopTimer(object);
            object = executionProfiler.startTimer(DATA_ADAPTER_TIME_LABEL);
            DataAdaptersExecutionResult dataAdaptersExecutionResult = this._dataManager.getResultsFromDataAdapters(object22.toArray(new QuerySpec[object22.size()]), executionProfiler);
            Map<QuerySpec, ResultSetInfo> map2 = dataAdaptersExecutionResult.getResultsPerQuery();
            executionProfiler.stopTimer(object);
            object = executionProfiler.startTimer(PROPERTY_PROVIDER_ADAPTER_TIME_LABEL);
            List<PropertyProvidersExecutionResult> list2 = this._dataManager.getResultsFromPropertyProviders(dataAdaptersExecutionResult, executionProfiler);
            executionProfiler.stopTimer(object);
            object = executionProfiler.startTimer(REMAP_ENRICHED_QUERY_TIME_LABEL);
            dataAdaptersExecutionResult = this._dataManager.remapAndCollectResultsForEnrichedQueries(dataAdaptersExecutionResult, map);
            map2 = dataAdaptersExecutionResult.getResultsPerQuery();
            executionProfiler.stopTimer(object);
            object = executionProfiler.startTimer(DERIVED_PROPERTY_PROVIDER_ADAPTER_TIME_LABEL);
            List<PropertyProvidersExecutionResult> list3 = this._dataManager.getResultsFromDerivedPropertyProviders(dataAdaptersExecutionResult, executionProfiler, map);
            list2.addAll(list3);
            executionProfiler.stopTimer(object);
            object = executionProfiler.startTimer(FORMATTING_TIME_LABEL);
            FormattingResultTransformer formattingResultTransformer = new FormattingResultTransformer(this._metadataRegistry);
            formattingResultTransformer.transform(map2);
            executionProfiler.stopTimer(object);
            object = executionProfiler.startTimer(RESULT_ORDERING_TIME_LABEL);
            for (int i = list.size() - 1; i >= 0; --i) {
                BatchedQueryReducer batchedQueryReducer = list.get(i);
                map2 = batchedQueryReducer.getResultsByOriginalQuery(map2);
            }
            resultSetArray = ResultsManager.orderResultsPerQueryOrder(querySpecArray, map2);
            executionProfiler.stopTimer(object);
            object = null;
            long l2 = System.currentTimeMillis() - l;
            ProfilingUtil.logSlowExecutions(querySpecArray, l2, dataAdaptersExecutionResult, list2);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            String string = Utils.getLocalizedString("error.dataServiceInterrupted");
            resultSetArray = this.constructErrorResultFor(querySpecArray, new DataServiceException(string, interruptedException));
            executionProfiler.stopTimer(object);
        }
        catch (Exception exception) {
            _logger.error("The data service execution failed", (Throwable)exception);
            String string = Utils.getLocalizedString("error.dataServiceFailure");
            resultSetArray = this.constructErrorResultFor(querySpecArray, new DataServiceException(string, exception));
            {
                catch (Throwable throwable) {
                    executionProfiler.stopTimer(object);
                    throw throwable;
                }
            }
            executionProfiler.stopTimer(object);
        }
        executionProfiler.stopTimer(object);
        if (_logger.isTraceEnabled()) {
            _logger.trace("ResultSets returned:\n" + Utils.renderResultSets(resultSetArray));
        }
        return resultSetArray;
    }

    private static List<String> getDefaultReducerClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(QueryBatchReducer.class.getName());
        return arrayList;
    }

    private static List<Class<? extends BatchedQueryReducer>> getReducerClasses(List<String> list) {
        ArrayList<Class<? extends BatchedQueryReducer>> arrayList = new ArrayList<Class<? extends BatchedQueryReducer>>(list.size());
        for (String string : list) {
            try {
                Class<?> clazz = Class.forName(string);
                arrayList.add(clazz);
            }
            catch (Exception exception) {
                _logger.error("Error loading BatchedQueryReducer with class name: " + string);
            }
        }
        return arrayList;
    }

    private List<BatchedQueryReducer> getReducers() {
        ArrayList<BatchedQueryReducer> arrayList = new ArrayList<BatchedQueryReducer>(this._reducerClasses.size());
        for (Class<? extends BatchedQueryReducer> clazz : this._reducerClasses) {
            try {
                BatchedQueryReducer batchedQueryReducer = clazz.newInstance();
                arrayList.add(batchedQueryReducer);
            }
            catch (Exception exception) {
                _logger.error("Error loading QueryBatchReducer with class name: " + clazz.getName() + ". Class must exist and specify a " + "zero-argument public constructor.");
            }
        }
        return arrayList;
    }

    private ResultSet[] constructErrorResultFor(QuerySpec[] querySpecArray, Exception exception) {
        assert (exception != null) : "The exception should not be null";
        int n = querySpecArray.length;
        ResultSet[] resultSetArray = new ResultSet[n];
        for (int i = 0; i < n; ++i) {
            QuerySpec querySpec = querySpecArray[i];
            ResultSet resultSet = new ResultSet();
            resultSet.error = exception;
            resultSet.queryName = querySpec.name;
            resultSetArray[i] = resultSet;
        }
        return resultSetArray;
    }

    private ExecutionProfiler getExecutionProfiler(boolean bl) {
        if (this._enableProfiling || bl) {
            int n = DataServiceImpl.getDataServiceCallId();
            return new ExecutionProfilerImpl("dsCall" + n);
        }
        return ExecutionProfilerImpl.PASS_THROUGH_PROFILER;
    }

    void shutdown() {
        if (this._dataManager != null) {
            this._dataManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDataServiceCallId() {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        if (httpServletRequest == null) {
            return 0;
        }
        AtomicInteger atomicInteger = (AtomicInteger)httpServletRequest.getAttribute(DATA_SERVICE_CALL_COUNTER);
        if (atomicInteger != null) {
            int n = atomicInteger.incrementAndGet();
            return n;
        }
        atomicInteger = new AtomicInteger(0);
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        synchronized (httpServletRequest2) {
            AtomicInteger atomicInteger2 = (AtomicInteger)httpServletRequest.getAttribute(DATA_SERVICE_CALL_COUNTER);
            if (atomicInteger2 == null) {
                httpServletRequest.setAttribute(DATA_SERVICE_CALL_COUNTER, (Object)atomicInteger);
            } else {
                atomicInteger = atomicInteger2;
            }
        }
        int n = atomicInteger.incrementAndGet();
        return n;
    }
}

