/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.DataFormatUtil;
import com.vmware.vise.data.query.impl.ResultSetInfo;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.RelationshipDescriptor;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FormattingResultTransformer {
    private static final Log _logger = LogFactory.getLog(FormattingResultTransformer.class);
    private final MetadataServiceRegistryInternal _metadataRegistry;

    public FormattingResultTransformer(MetadataServiceRegistryInternal metadataServiceRegistryInternal) {
        assert (metadataServiceRegistryInternal != null);
        this._metadataRegistry = metadataServiceRegistryInternal;
    }

    public void transform(Map<QuerySpec, ResultSetInfo> map) {
        assert (map != null);
        for (QuerySpec querySpec : map.keySet()) {
            ResultSetInfo resultSetInfo = map.get(querySpec);
            ResultSet resultSet = resultSetInfo.getResultSet();
            this.transformResultItems(querySpec.resourceSpec.propertySpecs, resultSet.items);
            if (querySpec.resultSpec == null) continue;
            this.transformFacets(querySpec.resultSpec.facets, resultSet.facets);
        }
    }

    private void transformFacets(FacetSpec[] facetSpecArray, FacetInfo[] facetInfoArray) {
        if (facetInfoArray == null || facetInfoArray.length == 0 || facetSpecArray == null || facetSpecArray.length == 0) {
            return;
        }
        for (FacetSpec facetSpec : facetSpecArray) {
            assert (facetSpec.propSpec != null);
            assert (facetSpec.propSpec.propertyNames.length > 0);
            for (String string : facetSpec.propSpec.propertyNames) {
                if (!FormattingResultTransformer.needsFormattingTransform(string)) continue;
                string = string.substring(0, string.length() - ".@formatted".length());
                this.transformFacetInfo(facetInfoArray, facetSpec.propSpec, string);
            }
        }
    }

    private void transformFacetInfo(FacetInfo[] facetInfoArray, PropertySpec propertySpec, String string) {
        String string2 = propertySpec.type;
        String string3 = propertySpec.relation;
        if (string3 != null && !string3.isEmpty()) {
            for (FacetInfo facetInfo : facetInfoArray) {
                PropertySpec propertySpec2 = facetInfo.propSpec;
                if (!ObjectUtil.objectsEqual((Object)string2, (Object)propertySpec2.type) || !ObjectUtil.objectsEqual((Object)string, (Object)propertySpec2.propertyNames[0]) || !ObjectUtil.objectsEqual((Object)string3, (Object)propertySpec2.relation)) continue;
                this.transformFacetInfo(facetInfo);
                break;
            }
        } else {
            for (FacetInfo facetInfo : facetInfoArray) {
                PropertySpec propertySpec3 = facetInfo.propSpec;
                if (!ObjectUtil.objectsEqual((Object)string2, (Object)propertySpec3.type) || !ObjectUtil.objectsEqual((Object)string, (Object)propertySpec3.propertyNames[0]) || propertySpec3.relation != null && !propertySpec3.relation.isEmpty()) continue;
                this.transformFacetInfo(facetInfo);
                break;
            }
        }
    }

    private void transformFacetInfo(FacetInfo facetInfo) {
        FacetValue[] facetValueArray;
        PropertySpec propertySpec = facetInfo.propSpec;
        FacetValue[] facetValueArray2 = facetInfo.propSpec.propertyNames[0];
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertySpec, (String)facetValueArray2);
        if (propertyDescriptor == null) {
            facetValueArray = propertySpec.relation == null ? facetValueArray2 : propertySpec.relation + "." + (String)facetValueArray2;
            _logger.error((Object)("Formatting of FacetInfo for property: " + (String)facetValueArray + " failed because PropertyDescriptor was not found."));
        }
        facetInfo.propSpec.propertyNames[0] = this.addFormattingSuffix((String)facetValueArray2);
        for (FacetValue facetValue : facetValueArray = facetInfo.facetValues) {
            facetValue.value = this.transformValue(propertyDescriptor, facetValue.value);
        }
    }

    private void transformResultItems(PropertySpec[] propertySpecArray, ResultItem[] resultItemArray) {
        if (resultItemArray == null || resultItemArray.length == 0 || propertySpecArray == null || propertySpecArray.length == 0) {
            return;
        }
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String string : propertySpec.propertyNames) {
                if (!FormattingResultTransformer.needsFormattingTransform(string)) continue;
                this.transformResultItems(propertySpec, string.substring(0, string.length() - ".@formatted".length()), resultItemArray);
            }
        }
    }

    private void transformResultItems(PropertySpec propertySpec, String string, ResultItem[] resultItemArray) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertySpec, string);
        if (propertyDescriptor == null) {
            String string2 = propertySpec.relation == null ? string : propertySpec.relation + "." + string;
            _logger.error((Object)("Formatting of ResultItems for property: " + string2 + " failed because PropertyDescriptor was not found."));
            return;
        }
        for (ResultItem resultItem : resultItemArray) {
            PropertyValue[] propertyValueArray;
            for (PropertyValue propertyValue : propertyValueArray = resultItem.properties) {
                if (!propertyValue.propertyName.equals(string)) continue;
                propertyValue.value = this.transformValue(propertyDescriptor, propertyValue.value);
                propertyValue.propertyName = this.addFormattingSuffix(string);
            }
        }
    }

    private Object transformValue(PropertyDescriptor propertyDescriptor, Object object) {
        if (object == null) {
            return object;
        }
        Object object2 = object;
        if (propertyDescriptor.unit != null) {
            object2 = DataFormatUtil.formatValueWithUnit(object, propertyDescriptor.unit, propertyDescriptor.displayForm);
        } else if (propertyDescriptor.staticValueSpace != null) {
            object2 = DataFormatUtil.formatValueWithStaticValueSpace(object, propertyDescriptor.staticValueSpace);
        }
        return object2;
    }

    private PropertyDescriptor getPropertyDescriptor(PropertySpec propertySpec, String string) {
        PropertyDescriptor[] propertyDescriptorArray;
        assert (propertySpec != null);
        String string2 = propertySpec.type;
        if (!StringUtil.isNullOrEmpty((String)propertySpec.relation)) {
            string2 = this.getProviderTypeFromRelationHops(string2, propertySpec.relation);
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = this._metadataRegistry.lookUpPropertyDescriptors(string2)) {
            if (!propertyDescriptor.name.equals(string) && !ArrayUtil.contains((Object)string, (Object[])propertyDescriptor.aliases).booleanValue()) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private String getProviderTypeFromRelationHops(String string, String string2) {
        String[] stringArray;
        for (String string3 : stringArray = string2.split(";")) {
            string = this.getRelationTargetType(string, string3);
        }
        return string;
    }

    private String getRelationTargetType(String string, String string2) {
        RelationshipDescriptor[] relationshipDescriptorArray;
        for (RelationshipDescriptor relationshipDescriptor : relationshipDescriptorArray = this._metadataRegistry.lookUpRelationshipDescriptors(string, null)) {
            if (!relationshipDescriptor.name.equals(string2)) continue;
            return relationshipDescriptor.targetType;
        }
        return null;
    }

    private static boolean needsFormattingTransform(String string) {
        assert (string != null);
        return string.endsWith(".@formatted");
    }

    private String addFormattingSuffix(String string) {
        return string + ".@formatted";
    }
}

