/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.impl;

import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.impl.ServicePropertyProviderAdapter;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Utils {
    public static final QuerySpec[] EMPTY_QUERY_SPECS = new QuerySpec[0];
    public static final ResultItem[] EMPTY_RESULT_ITEMS = new ResultItem[0];
    public static final FacetInfo[] EMPTY_FACET_INFOS = new FacetInfo[0];
    public static final IdentifiableGenerationNumber[] EMPTY_IDENTIFIABLE_GENERATIONS = new IdentifiableGenerationNumber[0];
    public static final PropertyValue[] EMPTY_PROPERTY_VALUES = new PropertyValue[0];
    private static final Log _logger = LogFactory.getLog(Utils.class);
    public static final String DS_TIMEOUT_CONFIG_KEY = "dataservice.timeoutSeconds";
    public static final long DEFAULT_DS_TIMEOUT_SECONDS = 120L;
    public static final String DS_CONNECTION_TIMEOUT_CONFIG_KEY = "dataservice.connectiontimeoutSeconds";
    public static final long DEFAULT_DS_CONNECTION_TIMEOUT_SECONDS = 20L;
    public static final String RELATION_SEPARATOR = ";";
    public static final String AT_FORMATTED_SUFFIX = ".@formatted";
    private static final String RESOURCE_BUNDLE_NAME = "DataService";
    private static final String[] DEFAULT_SORT_PROPERTIES = new String[]{"id"};
    public static final OrderingCriteria DEFAULT_ORDERING_CRITERIA = Utils.getDefaultOrderingCriteria();
    private static final char INDENTATION_CHAR = ' ';
    private static final String NEW_LINE = "\n";
    private static final String GET_METHOD = "get";
    private static final String PROP_NAMESPACE_SEPARATOR = ":";
    private static final AtomicLong queryNameCounter = new AtomicLong(0L);

    public static String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)Utils.class.getClassLoader());
    }

    public static String createXmlFromObject(Object object, Class ... classArray) throws Exception {
        Class[] classArray2 = Arrays.copyOf(classArray, classArray.length + 1);
        classArray2[classArray2.length - 1] = object.getClass();
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classArray2);
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)new JAXBElement(new QName("", "object"), object.getClass(), object), (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public static String getLocalizedString(String string, String ... stringArray) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (String[])stringArray, (ClassLoader)Utils.class.getClassLoader());
    }

    public static Object[] getEnumeratedObjects(QuerySpec querySpec) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (querySpec.resourceSpec != null) {
            Utils.fillObjectsFromConstraints(querySpec.resourceSpec.constraint, arrayList, false);
        }
        return arrayList.toArray();
    }

    public static Object[] getEnumeratedObjects(RelationalConstraint relationalConstraint) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Utils.fillObjectsFromConstraints(relationalConstraint, arrayList, true);
        return arrayList.toArray();
    }

    public static PropertySpec newPropertySpec(String string, String[] stringArray, ParameterSpec[] parameterSpecArray) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = string;
        propertySpec.propertyNames = stringArray;
        propertySpec.parameters = parameterSpecArray;
        return propertySpec;
    }

    public static OrderingPropertySpec newOrderingPropertySpec(String string, String[] stringArray, ParameterSpec[] parameterSpecArray, SortType sortType) {
        OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
        orderingPropertySpec.type = string;
        orderingPropertySpec.propertyNames = stringArray;
        orderingPropertySpec.parameters = parameterSpecArray;
        orderingPropertySpec.orderingType = sortType;
        return orderingPropertySpec;
    }

    private static void fillObjectsFromConstraints(Constraint constraint, ArrayList<Object> arrayList, boolean bl) {
        if (constraint == null) {
            return;
        }
        if (ObjectIdentityConstraint.class.isInstance(constraint)) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            arrayList.add(objectIdentityConstraint.target);
        } else if (CompositeConstraint.class.isInstance(constraint)) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.conjoiner.equals((Object)Conjoiner.OR)) {
                for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                    Utils.fillObjectsFromConstraints(constraint2, arrayList, bl);
                }
            }
        } else if (RelationalConstraint.class.isInstance(constraint) && bl) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            Utils.fillObjectsFromConstraints(relationalConstraint.constraintOnRelatedObject, arrayList, bl);
        }
    }

    public static String renderPropertyProvider(PropertyProviderAdapter propertyProviderAdapter) {
        assert (propertyProviderAdapter != null);
        return Utils.renderPropertyProvider(propertyProviderAdapter, true);
    }

    public static String renderPropertyProvider(PropertyProviderAdapter propertyProviderAdapter, boolean bl) {
        assert (propertyProviderAdapter != null);
        if (propertyProviderAdapter instanceof ServicePropertyProviderAdapter) {
            ServicePropertyProviderAdapter servicePropertyProviderAdapter = (ServicePropertyProviderAdapter)propertyProviderAdapter;
            PropertyProviderBean propertyProviderBean = servicePropertyProviderAdapter.getPropertyProvider();
            return bl ? propertyProviderBean.getClass().getCanonicalName() : propertyProviderBean.getClass().getSimpleName();
        }
        return bl ? propertyProviderAdapter.getClass().getCanonicalName() : propertyProviderAdapter.getClass().getSimpleName();
    }

    /*
     * WARNING - void declaration
     */
    public static String renderQuerySpec(QuerySpec querySpec) {
        if (querySpec == null) {
            return "\nQuerySpec: null\n";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(NEW_LINE);
        Utils.writeLine(stringBuilder, "QuerySpec", 0);
        String string = StringUtil.isNullOrEmpty((String)querySpec.name) ? "null" : querySpec.name;
        Utils.writeLine(stringBuilder, "QueryName: " + string, 1);
        if (querySpec.resourceSpec != null) {
            Utils.writeLine(stringBuilder, "ResourceSpec", 1);
            Utils.renderConstraint(stringBuilder, querySpec.resourceSpec.constraint, 2);
            if (querySpec.resourceSpec.propertySpecs != null) {
                Utils.writeLine(stringBuilder, String.format("PropertySpec[%1$s]", querySpec.resourceSpec.propertySpecs.length), 2);
                for (PropertySpec cloneable : querySpec.resourceSpec.propertySpecs) {
                    Utils.renderPropertySpec(stringBuilder, cloneable, 3);
                }
            }
        } else {
            Utils.writeLine(stringBuilder, "ResourceSpec: null", 1);
        }
        if (querySpec.resultSpec != null) {
            Utils.writeLine(stringBuilder, "ResultSpec:", 1);
            Utils.writeLine(stringBuilder, "Offset: " + querySpec.resultSpec.offset, 2);
            Utils.writeLine(stringBuilder, "MaxResultCount: " + querySpec.resultSpec.maxResultCount, 2);
            if (querySpec.resultSpec.order != null) {
                Utils.writeLine(stringBuilder, "OrderingCriteria", 2);
                if (querySpec.resultSpec.order.orderingProperties != null) {
                    Utils.writeLine(stringBuilder, String.format("OrderPropertySpec[%1$s]", querySpec.resultSpec.order.orderingProperties.length), 3);
                    for (Cloneable cloneable : querySpec.resultSpec.order.orderingProperties) {
                        Utils.writeLine(stringBuilder, "ProviderType: " + ((OrderingPropertySpec)cloneable).type, 4);
                        Utils.writeLine(stringBuilder, "Relationship: " + ((OrderingPropertySpec)cloneable).relation, 4);
                        Utils.writeLine(stringBuilder, "SortType: " + (Object)((Object)((OrderingPropertySpec)cloneable).orderingType), 4);
                        Utils.writeLine(stringBuilder, String.format("OrderingProperties[%1$s]", ((OrderingPropertySpec)cloneable).propertyNames.length), 4);
                        for (String string2 : ((OrderingPropertySpec)cloneable).propertyNames) {
                            Utils.writeLine(stringBuilder, "PropertyName: " + string2, 5);
                        }
                    }
                }
            } else {
                Utils.writeLine(stringBuilder, "OrderingCriteria: null", 2);
            }
            if (querySpec.resultSpec.facets != null) {
                void var6_11;
                Cloneable[] cloneableArray = querySpec.resultSpec.facets;
                Utils.writeLine(stringBuilder, String.format("Facets[%d]", cloneableArray.length), 2);
                Cloneable[] cloneableArray2 = cloneableArray;
                int n = cloneableArray2.length;
                boolean bl = false;
                while (var6_11 < n) {
                    Cloneable cloneable = cloneableArray2[var6_11];
                    Utils.renderPropertySpec(stringBuilder, ((FacetSpec)cloneable).propSpec, 3);
                    ++var6_11;
                }
            } else {
                Utils.writeLine(stringBuilder, "Facets: null", 2);
            }
        } else {
            Utils.writeLine(stringBuilder, "ResultSpec: null", 1);
        }
        Utils.renderQueryOptions(stringBuilder, querySpec.options, 1);
        return stringBuilder.toString();
    }

    private static void renderPropertySpec(StringBuilder stringBuilder, PropertySpec propertySpec, int n) {
        Utils.writeLine(stringBuilder, "ProviderType: " + propertySpec.type, n);
        Utils.writeLine(stringBuilder, "Relationship: " + propertySpec.relation, n);
        Utils.writeLine(stringBuilder, String.format("Properties[%1$s]", propertySpec.propertyNames.length), n);
        for (String string : propertySpec.propertyNames) {
            Utils.writeLine(stringBuilder, "PropertyName: " + string, n + 1);
        }
    }

    private static void renderQueryOptions(StringBuilder stringBuilder, Map<String, Object> map, int n) {
        int n2 = n + 1;
        if (map != null) {
            Utils.writeLine(stringBuilder, "Options:", n);
            if (!map.isEmpty()) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String string = entry.toString();
                    Utils.writeLine(stringBuilder, string, n2);
                }
            } else {
                Utils.writeLine(stringBuilder, "Options: [empty]", n);
            }
        } else {
            Utils.writeLine(stringBuilder, "Options: null", n);
        }
    }

    private static void appendQuerySpec(StringBuilder stringBuilder, QuerySpec querySpec, int n) {
        if (n > 0) {
            stringBuilder.append(NEW_LINE);
        }
        stringBuilder.append("Query");
        if (n >= 0) {
            stringBuilder.append('[').append(n).append(']');
        }
        stringBuilder.append(":\n");
        String string = Utils.renderQuerySpec(querySpec);
        stringBuilder.append(string);
    }

    public static String renderQuerySpecs(QuerySpec[] querySpecArray) {
        if (querySpecArray == null) {
            return "<null>";
        }
        if (querySpecArray.length == 0) {
            return "<empty_array>";
        }
        StringBuilder stringBuilder = new StringBuilder(1000);
        int n = querySpecArray.length;
        for (int i = 0; i < n; ++i) {
            Utils.appendQuerySpec(stringBuilder, querySpecArray[i], i);
        }
        return stringBuilder.toString();
    }

    public static String renderQuerySpecs(Collection<QuerySpec> collection) {
        if (collection == null) {
            return "<null>";
        }
        if (collection.isEmpty()) {
            return "<empty_collection>";
        }
        StringBuilder stringBuilder = new StringBuilder(1000);
        int n = 0;
        for (QuerySpec querySpec : collection) {
            Utils.appendQuerySpec(stringBuilder, querySpec, n);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static void renderConstraint(StringBuilder stringBuilder, Constraint constraint, int n) {
        if (constraint == null) {
            return;
        }
        String string = constraint.getClass().getSimpleName();
        Utils.writeLine(stringBuilder, String.format("Constraint: %1$s", string), n);
        Utils.writeLine(stringBuilder, "TargetType: " + constraint.targetType, n + 1);
        if (constraint instanceof ObjectIdentityConstraint) {
            Utils.writeLine(stringBuilder, "Target: " + ((ObjectIdentityConstraint)constraint).target, n + 1);
        } else if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            Utils.writeLine(stringBuilder, "PropertyName: " + propertyConstraint.propertyName, n + 1);
            Utils.writeLine(stringBuilder, "Comparator: " + (Object)((Object)propertyConstraint.comparator), n + 1);
            Object object = propertyConstraint.comparableValue;
            Utils.writeLine(stringBuilder, "ComparableValue: " + (object != null ? "(" + object.getClass().getName() + ") " : "") + (object instanceof Object[] ? Arrays.toString((Object[])object) : object), n + 1);
        } else if (constraint instanceof RelationalConstraint) {
            Utils.writeLine(stringBuilder, "Relationship: " + ((RelationalConstraint)constraint).relation, n + 1);
            Utils.writeLine(stringBuilder, "IsSourceConstrained: " + ((RelationalConstraint)constraint).hasInverseRelation, n + 1);
            Utils.renderConstraint(stringBuilder, ((RelationalConstraint)constraint).constraintOnRelatedObject, n + 1);
        } else if (constraint instanceof CompositeConstraint) {
            Utils.writeLine(stringBuilder, "Conjoiner: " + (Object)((Object)((CompositeConstraint)constraint).conjoiner), n + 1);
            for (Constraint constraint2 : ((CompositeConstraint)constraint).nestedConstraints) {
                Utils.renderConstraint(stringBuilder, constraint2, n + 1);
            }
        }
    }

    private static void writeLine(StringBuilder stringBuilder, String string, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        stringBuilder.append(NEW_LINE);
    }

    private static OrderingCriteria getDefaultOrderingCriteria() {
        OrderingCriteria orderingCriteria = new OrderingCriteria();
        orderingCriteria.orderingProperties = new OrderingPropertySpec[1];
        orderingCriteria.orderingProperties[0] = new OrderingPropertySpec();
        orderingCriteria.orderingProperties[0].propertyNames = DEFAULT_SORT_PROPERTIES;
        orderingCriteria.orderingProperties[0].type = "Object";
        orderingCriteria.orderingProperties[0].orderingType = SortType.ASCENDING;
        return orderingCriteria;
    }

    public static String getPropertyName(Method method) {
        if (!Utils.isPropertyGetter(method)) {
            return null;
        }
        String string = method.getName();
        String string2 = string.substring(GET_METHOD.length());
        String string3 = string2.substring(0, 1);
        string2 = string2.replaceFirst(string3, string3.toLowerCase());
        return string2;
    }

    public static boolean isPropertyGetter(Method method) {
        if (method == null) {
            return false;
        }
        String string = method.getName();
        if (!string.startsWith(GET_METHOD)) {
            return false;
        }
        int n = method.getModifiers();
        if (Modifier.isStatic(n) || !Modifier.isPublic(n)) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        return classArray.length != 0;
    }

    public static void generateNamesForNamelessQueries(QuerySpec[] querySpecArray) {
        if (querySpecArray == null) {
            return;
        }
        for (QuerySpec querySpec : querySpecArray) {
            if (!StringUtil.isNullOrEmpty((String)querySpec.name)) continue;
            querySpec.name = "auto-name-" + queryNameCounter.incrementAndGet();
        }
    }

    public static List<String> getQueryNames(QuerySpec[] querySpecArray) {
        if (querySpecArray == null || querySpecArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(querySpecArray.length);
        for (QuerySpec querySpec : querySpecArray) {
            arrayList.add(querySpec.name);
        }
        return arrayList;
    }

    public static List<String> getQueryNames(Collection<QuerySpec> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (QuerySpec querySpec : collection) {
            arrayList.add(querySpec.name);
        }
        return arrayList;
    }

    public static String getNamespacedProperty(String string, String string2) {
        if (!StringUtil.isNullOrEmpty((String)string2)) {
            return string2 + PROP_NAMESPACE_SEPARATOR + string;
        }
        return string;
    }

    public static boolean contains(PropertySpec[] propertySpecArray, String string, String string2) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("The typeName shouldn't be null");
        }
        if (StringUtil.isNullOrEmpty((String)string2)) {
            throw new IllegalArgumentException("The propertyName shouldn't be null");
        }
        if (propertySpecArray == null) {
            return false;
        }
        for (PropertySpec propertySpec : propertySpecArray) {
            if (!string.equals(propertySpec.type) || propertySpec.propertyNames == null || !ArrayUtil.contains((Object)string2, (Object[])propertySpec.propertyNames).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static String getStringBeforeSubStr(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String stripIfEndsWith(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String[] getTypeNamesFromConstraint(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Utils.gatherTypesFromConstraint(constraint, hashSet, false);
        String[] stringArray = hashSet.toArray(new String[0]);
        return stringArray;
    }

    public static String[] getAllTypeNamesFromConstraint(Constraint constraint) {
        if (constraint == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Utils.gatherTypesFromConstraint(constraint, hashSet, true);
        String[] stringArray = hashSet.toArray(new String[0]);
        return stringArray;
    }

    private static void gatherTypesFromConstraint(Constraint constraint, Set<String> set, boolean bl) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            if (objectIdentityConstraint.target != null) {
                String string = QueryUtil.getReferenceType(objectIdentityConstraint.target);
                if (string == null) {
                    _logger.warn((Object)String.format("Type cannot be resolved for %1$s", objectIdentityConstraint.target.toString()));
                    return;
                }
                set.add(string);
            }
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                Utils.gatherTypesFromConstraint(constraint2, set, bl);
            }
        } else if (bl && constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            if (relationalConstraint.targetType != null) {
                set.add(relationalConstraint.targetType);
            }
            Utils.gatherTypesFromConstraint(relationalConstraint.constraintOnRelatedObject, set, bl);
        } else if (constraint.targetType != null) {
            set.add(constraint.targetType);
        }
    }

    public static boolean containsNonExplicitType(QuerySpec querySpec, MetadataServiceRegistryInternal metadataServiceRegistryInternal) {
        if (querySpec == null) {
            throw new IllegalArgumentException("The querySpec argument shouldn't be null");
        }
        if (metadataServiceRegistryInternal == null) {
            throw new IllegalArgumentException("The metadataRegistry argument shouldn't be null");
        }
        if (querySpec.resourceSpec == null) {
            throw new IllegalArgumentException("The query doesn't have a resourceSpec");
        }
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint == null) {
            throw new IllegalArgumentException("The query doesn't have a constraint");
        }
        String[] stringArray = Utils.getTypeNamesFromConstraint(constraint);
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        boolean bl = Utils.containsNonExplicitType(stringArray, metadataServiceRegistryInternal);
        return bl;
    }

    public static boolean containsNonExplicitType(String[] stringArray, MetadataServiceRegistryInternal metadataServiceRegistryInternal) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The typeNames argument shouldn't be null");
        }
        if (metadataServiceRegistryInternal == null) {
            throw new IllegalArgumentException("The metadataRegistry argument shouldn't be null");
        }
        if (stringArray.length == 0) {
            return true;
        }
        for (String string : stringArray) {
            if (string == null) {
                return true;
            }
            boolean bl = metadataServiceRegistryInternal.isTypeExplicit(string);
            if (bl) continue;
            return true;
        }
        return false;
    }

    public static boolean isObjectConstrained(Constraint constraint) {
        if (constraint instanceof ObjectIdentityConstraint) {
            return true;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.nestedConstraints == null) {
                return true;
            }
            if (compositeConstraint.conjoiner != null && !Conjoiner.OR.equals((Object)compositeConstraint.conjoiner) && compositeConstraint.nestedConstraints.length > 1) {
                return false;
            }
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                if (Utils.isObjectConstrained(constraint2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<String> getPropertyNames(PropertySpec[] propertySpecArray) {
        if (propertySpecArray == null || propertySpecArray.length == 0) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (PropertySpec propertySpec : propertySpecArray) {
            if (propertySpec == null) continue;
            for (String string : propertySpec.propertyNames) {
                linkedHashSet.add(string);
            }
        }
        return new ArrayList<String>(linkedHashSet);
    }

    public static Set<Object> getConstrainedObjects(Constraint constraint) {
        if (constraint == null) {
            return Collections.emptySet();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Utils.harvestConstrainedObjects(constraint, hashSet);
        return hashSet;
    }

    private static void harvestConstrainedObjects(Constraint constraint, Set<Object> set) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            set.add(objectIdentityConstraint.target);
            return;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.nestedConstraints == null) {
                return;
            }
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                Utils.harvestConstrainedObjects(constraint2, set);
            }
        }
    }

    public static Set<ObjectIdentityConstraint> getObjectConstraints(Constraint constraint) {
        if (constraint == null) {
            return Collections.emptySet();
        }
        HashSet<ObjectIdentityConstraint> hashSet = new HashSet<ObjectIdentityConstraint>();
        Utils.harvestConstrainedObjectConstraints(constraint, hashSet);
        return hashSet;
    }

    private static void harvestConstrainedObjectConstraints(Constraint constraint, Set<ObjectIdentityConstraint> set) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            set.add(objectIdentityConstraint);
            return;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.nestedConstraints == null) {
                return;
            }
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                Utils.harvestConstrainedObjectConstraints(constraint2, set);
            }
        }
    }

    public static Object getResourceObject(ResultItem resultItem, PropertyValue propertyValue) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{resultItem, propertyValue});
        Object object = propertyValue.resourceObject;
        if (object != null) {
            return object;
        }
        return resultItem.resourceObject;
    }

    public static Map<Object, Map<String, Object>> extractValuesByObject(ResultSet resultSet) {
        HashMap<Object, Map<String, Object>> hashMap = new HashMap<Object, Map<String, Object>>();
        if (resultSet == null || resultSet.items == null) {
            return Collections.emptyMap();
        }
        for (ResultItem resultItem : resultSet.items) {
            if (resultItem == null || resultItem.properties == null) continue;
            for (PropertyValue propertyValue : resultItem.properties) {
                Object object;
                Object object2;
                if (propertyValue == null || (object2 = Utils.getResourceObject(resultItem, propertyValue)) == null) continue;
                HashMap<String, Object> hashMap2 = (HashMap<String, Object>)hashMap.get(object2);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<String, Object>();
                    hashMap.put(object2, hashMap2);
                }
                if ((object = hashMap2.put(propertyValue.propertyName, propertyValue.value)) == null) continue;
                _logger.warn((Object)("duplicate values for " + object2 + "." + propertyValue.propertyName));
            }
        }
        return hashMap;
    }

    public static long getDataServiceTimeout(ConfigurationService configurationService) {
        long l = PropertyUtil.getLongProperty((ConfigurationService)configurationService, (String)DS_TIMEOUT_CONFIG_KEY, (long)120L);
        return l * 1000L;
    }

    public static String renderResultSets(ResultSet[] resultSetArray) {
        if (resultSetArray == null) {
            return "null";
        }
        if (resultSetArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ResultSet resultSet : resultSetArray) {
            Utils.appendResultSet(stringBuilder, resultSet);
            stringBuilder.append(NEW_LINE);
        }
        return stringBuilder.toString();
    }

    public static long getDataServiceConnectionTimeout(ConfigurationService configurationService) {
        long l = PropertyUtil.getLongProperty((ConfigurationService)configurationService, (String)DS_CONNECTION_TIMEOUT_CONFIG_KEY, (long)20L);
        return l * 1000L;
    }

    private static void appendResultSet(StringBuilder stringBuilder, ResultSet resultSet) {
        if (resultSet == null) {
            Utils.writeLine(stringBuilder, "ResultSet: null", 0);
            return;
        }
        Utils.writeLine(stringBuilder, "ResultSet", 0);
        if (!StringUtil.isNullOrEmpty((String)resultSet.queryName)) {
            Utils.writeLine(stringBuilder, "QueryName: " + resultSet.queryName, 1);
        }
        Utils.writeLine(stringBuilder, "TotalMatchedObjectCount: " + resultSet.totalMatchedObjectCount, 1);
        if (resultSet.error != null) {
            Utils.writeLine(stringBuilder, "Error: " + resultSet.error, 1);
        }
        if (resultSet.items != null) {
            Utils.writeLine(stringBuilder, "Items[" + resultSet.items.length + "]", 1);
            for (ResultItem object : resultSet.items) {
                Utils.appendResultItem(stringBuilder, object, 2);
            }
        } else {
            Utils.writeLine(stringBuilder, "Items: null", 1);
        }
        if (resultSet.facets != null) {
            Utils.writeLine(stringBuilder, "Facets[" + resultSet.facets.length + "]", 1);
            for (FacetInfo facetInfo : resultSet.facets) {
                Utils.appendFacetInfo(stringBuilder, facetInfo, 2);
            }
        }
    }

    private static void appendFacetInfo(StringBuilder stringBuilder, FacetInfo facetInfo, int n) {
        Utils.writeLine(stringBuilder, "FacetInfo", n);
        Utils.renderPropertySpec(stringBuilder, facetInfo.propSpec, n + 1);
        if (facetInfo.facetValues != null) {
            int n2 = 0;
            for (FacetValue facetValue : facetInfo.facetValues) {
                Utils.writeLine(stringBuilder, String.format("FacetValue[%d]", n2 + 1), n + 1);
                Utils.writeLine(stringBuilder, "value: " + facetValue.value, n + 2);
                Utils.renderConstraint(stringBuilder, facetValue.constraint, n + 2);
                ++n2;
            }
        } else {
            Utils.writeLine(stringBuilder, "facetValues[0]", n + 1);
        }
    }

    private static void appendResultItem(StringBuilder stringBuilder, ResultItem resultItem, int n) {
        Utils.writeLine(stringBuilder, "ResultItem", n);
        Utils.writeLine(stringBuilder, "ResourceObject: " + resultItem.resourceObject, n + 1);
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItem.properties)) {
            Utils.writeLine(stringBuilder, "Properties[" + resultItem.properties.length + "]", n + 1);
            for (PropertyValue propertyValue : resultItem.properties) {
                Utils.appendPropertyValue(stringBuilder, propertyValue, n + 2);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])resultItem.currentGenerations)) {
            Utils.writeLine(stringBuilder, "CurrentGenerations[" + resultItem.currentGenerations.length + "]", n + 1);
            for (PropertyValue propertyValue : resultItem.currentGenerations) {
                Utils.appendGenerationNumber(stringBuilder, (IdentifiableGenerationNumber)propertyValue, n + 2);
            }
        }
    }

    private static void appendPropertyValue(StringBuilder stringBuilder, PropertyValue propertyValue, int n) {
        if (propertyValue == null) {
            Utils.writeLine(stringBuilder, "null", n);
        } else {
            Utils.writeLine(stringBuilder, propertyValue.toString(), n);
        }
    }

    private static void appendGenerationNumber(StringBuilder stringBuilder, IdentifiableGenerationNumber identifiableGenerationNumber, int n) {
        if (identifiableGenerationNumber == null) {
            Utils.writeLine(stringBuilder, "null", n);
        } else {
            Utils.writeLine(stringBuilder, identifiableGenerationNumber.key + "=" + identifiableGenerationNumber.value, n);
        }
    }
}

