/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.internal.profiling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.Validate;
import org.slf4j.MDC;

public final class MdcAwareExecutorService
implements ExecutorService {
    private final ExecutorService _executor;

    public MdcAwareExecutorService(ExecutorService executorService) {
        Validate.notNull((Object)executorService);
        this._executor = executorService;
    }

    @Override
    public void execute(Runnable runnable) {
        Validate.notNull((Object)runnable);
        this._executor.execute(MdcAwareExecutorService.mdcAware(runnable));
    }

    @Override
    public void shutdown() {
        this._executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this._executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this._executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this._executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this._executor.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        Validate.notNull(callable);
        return this._executor.submit(MdcAwareExecutorService.mdcAware(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        Validate.notNull((Object)runnable);
        return this._executor.submit(MdcAwareExecutorService.mdcAware(runnable), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this._executor.submit(MdcAwareExecutorService.mdcAware(runnable));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        Validate.notNull(collection);
        return this._executor.invokeAll(MdcAwareExecutorService.mdcAware(collection));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        Validate.notNull(collection);
        return this._executor.invokeAll(MdcAwareExecutorService.mdcAware(collection), l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        Validate.notNull(collection);
        return this._executor.invokeAny(MdcAwareExecutorService.mdcAware(collection));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Validate.notNull(collection);
        return this._executor.invokeAny(MdcAwareExecutorService.mdcAware(collection), l, timeUnit);
    }

    private static <T> Collection<Callable<T>> mdcAware(Collection<? extends Callable<T>> collection) {
        ArrayList<Callable<T>> arrayList = new ArrayList<Callable<T>>();
        for (Callable<T> callable : collection) {
            arrayList.add(MdcAwareExecutorService.mdcAware(callable));
        }
        return arrayList;
    }

    private static <T> Callable<T> mdcAware(final Callable<T> callable) {
        assert (callable != null);
        final long l = Thread.currentThread().getId();
        final Map map = MDC.getCopyOfContextMap();
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                long l2 = Thread.currentThread().getId();
                if (l2 != l) {
                    MDC.setContextMap((Map)map);
                }
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    if (l2 != l) {
                        MDC.clear();
                    }
                }
            }
        };
    }

    private static Runnable mdcAware(final Runnable runnable) {
        assert (runnable != null);
        final long l = Thread.currentThread().getId();
        final Map map = MDC.getCopyOfContextMap();
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l2 = Thread.currentThread().getId();
                if (l2 != l) {
                    MDC.setContextMap((Map)map);
                }
                try {
                    runnable.run();
                }
                finally {
                    if (l2 != l) {
                        MDC.clear();
                    }
                }
            }
        };
    }
}

