/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.impl.ComponentPropertyRetriever;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class CustomPropertyConstraintTransformer
implements Transformer<Constraint, Constraint> {
    private final ComponentPropertyRetriever _componentPropertyRetriever;

    public CustomPropertyConstraintTransformer(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal) {
        this._componentPropertyRetriever = new ComponentPropertyRetriever(dataServiceExtensionRegistryInternal);
    }

    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof PropertyConstraint)) {
            return new Transformer.Result<Constraint>(constraint);
        }
        PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
        if (StringUtil.isNullOrEmpty((String)propertyConstraint.targetType) || StringUtil.isNullOrEmpty((String)propertyConstraint.propertyName)) {
            return new Transformer.Result<Constraint>(propertyConstraint);
        }
        Constraint constraint2 = this.getEquivalentConstraint(propertyConstraint);
        boolean bl = !constraint2.equals(constraint);
        return new Transformer.Result<Constraint>(constraint2, bl, null);
    }

    private Constraint getEquivalentConstraint(PropertyConstraint propertyConstraint) {
        if (propertyConstraint.comparator != Comparator.TEXTUALLY_MATCHES) {
            return propertyConstraint;
        }
        String string = propertyConstraint.targetType;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(propertyConstraint.propertyName);
        Set<String> set = this._componentPropertyRetriever.getComponentProperties(string, hashSet);
        if (hashSet.containsAll(set)) {
            return propertyConstraint;
        }
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>(set.size());
        for (String string2 : set) {
            PropertyConstraint propertyConstraint2 = CustomPropertyConstraintTransformer.newPropertyConstraint(propertyConstraint, string2);
            arrayList.add(propertyConstraint2);
        }
        if (arrayList.isEmpty()) {
            return propertyConstraint;
        }
        if (arrayList.size() == 1) {
            return (Constraint)arrayList.get(0);
        }
        Constraint constraint = CustomPropertyConstraintTransformer.combineIntoSingleOrConstraint(string, arrayList);
        return constraint;
    }

    private static PropertyConstraint newPropertyConstraint(PropertyConstraint propertyConstraint, String string) {
        PropertyConstraint propertyConstraint2 = (PropertyConstraint)ObjectUtil.shallowCopy((Object)propertyConstraint, PropertyConstraint.class);
        propertyConstraint2.propertyName = string;
        return propertyConstraint2;
    }

    private static Constraint combineIntoSingleOrConstraint(String string, Collection<Constraint> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = string;
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = collection.toArray(new Constraint[0]);
        return compositeConstraint;
    }
}

