/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.transform.DataTransformer;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.data.query.transform.impl.CustomPropertyConstraintTransformer;
import com.vmware.vise.data.query.transform.impl.CustomPropertyOrderTransformer;
import com.vmware.vise.data.query.transform.impl.EnumPropertyConstraintTransformer;
import com.vmware.vise.data.query.transform.impl.FormattingPropertyConstraintTransformer;
import com.vmware.vise.data.query.transform.impl.FormattingPropertySpecTransformer;
import com.vmware.vise.data.query.transform.impl.NormalizeConstraintTransformer;
import com.vmware.vise.data.query.transform.impl.QuerySpecTransformer;
import com.vmware.vise.metadata.ObjectModelProviderRegistryInternal;
import com.vmware.vise.metadata.impl.MetadataServiceRegistryInternal;
import com.vmware.vise.util.ArrayUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class DataTransformerImpl
implements DataTransformer {
    private final QuerySpecTransformer _querySpecTransformer;

    public DataTransformerImpl(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal, MetadataServiceRegistryInternal metadataServiceRegistryInternal, ObjectModelProviderRegistryInternal objectModelProviderRegistryInternal) {
        Validate.notNull((Object)objectModelProviderRegistryInternal);
        this._querySpecTransformer = DataTransformerImpl.buildQueryTransformer(dataServiceExtensionRegistryInternal, metadataServiceRegistryInternal, objectModelProviderRegistryInternal);
    }

    @Override
    public Transformer.Result<QuerySpec> transformQuery(QuerySpec querySpec) {
        Transformer.Result<QuerySpec> result = this._querySpecTransformer.transform(querySpec);
        return result;
    }

    @Override
    public Map<QuerySpec, Transformer.Result<QuerySpec>> transformQueries(List<QuerySpec> list) {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<QuerySpec, Transformer.Result<QuerySpec>> hashMap = new HashMap<QuerySpec, Transformer.Result<QuerySpec>>();
        for (QuerySpec querySpec : list) {
            Transformer.Result<QuerySpec> result = this.transformQuery(querySpec);
            if (result.isTransformed()) {
                hashMap.put(querySpec, result);
                continue;
            }
            hashMap.put(querySpec, new Transformer.Result<QuerySpec>(querySpec, false, null));
        }
        return hashMap;
    }

    private static QuerySpecTransformer buildQueryTransformer(DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal, MetadataServiceRegistryInternal metadataServiceRegistryInternal, ObjectModelProviderRegistryInternal objectModelProviderRegistryInternal) {
        assert (dataServiceExtensionRegistryInternal != null);
        assert (metadataServiceRegistryInternal != null);
        QuerySpecTransformer querySpecTransformer = new QuerySpecTransformer();
        querySpecTransformer.registerConstraintTransformer(new FormattingPropertyConstraintTransformer());
        querySpecTransformer.registerConstraintTransformer(new CustomPropertyConstraintTransformer(dataServiceExtensionRegistryInternal));
        querySpecTransformer.registerConstraintTransformer(new NormalizeConstraintTransformer());
        querySpecTransformer.registerConstraintTransformer(new EnumPropertyConstraintTransformer(metadataServiceRegistryInternal));
        querySpecTransformer.registerPropertySpecTransformer(new FormattingPropertySpecTransformer());
        querySpecTransformer.registerOrderingTransformer(new CustomPropertyOrderTransformer(dataServiceExtensionRegistryInternal));
        return querySpecTransformer;
    }
}

