/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.transform.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.transform.Transformer;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public final class PropertyValueSubstitutionTransformer
implements Transformer<Constraint, Constraint> {
    private static final String TYPE_VM = "VirtualMachine";
    private static final String PROP_TOOLS_STATUS = "guest.toolsVersionStatus2";
    private static final String PROP_TOOLS_STATUS_ALIAS = "toolsVersionStatus";
    private static final String VALUE_CURRENT = "guestToolsCurrent";
    private static final String VALUE_SUPPORTED_NEW = "guestToolsSupportedNew";
    private static final String VALUE_TOO_OLD = "guestToolsTooOld";
    private static final String VALUE_TOO_BLACK_LISTED = "guestToolsTooBlackListed";
    private static final String VALUE_NEED_UPGRADE = "guestToolsNeedUpgrade";
    private final Map<Pair<String, String>, Map<String, List<String>>> _substitutionRegistry;

    public PropertyValueSubstitutionTransformer() {
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)VALUE_CURRENT, (Object)ImmutableList.of((Object)VALUE_CURRENT, (Object)VALUE_SUPPORTED_NEW)).put((Object)VALUE_TOO_OLD, (Object)ImmutableList.of((Object)VALUE_TOO_OLD, (Object)VALUE_TOO_BLACK_LISTED, (Object)VALUE_NEED_UPGRADE)).build();
        this._substitutionRegistry = ImmutableMap.builder().put((Object)new Pair((Object)TYPE_VM, (Object)PROP_TOOLS_STATUS, true), (Object)immutableMap).put((Object)new Pair((Object)TYPE_VM, (Object)PROP_TOOLS_STATUS_ALIAS, true), (Object)immutableMap).build();
    }

    @Override
    public Transformer.Result<Constraint> transform(Constraint constraint) {
        TransformationContext transformationContext = new TransformationContext();
        Constraint constraint2 = this.transform(constraint, transformationContext);
        return new Transformer.Result<Constraint>(constraint2, transformationContext.isTransformed);
    }

    protected Constraint transform(Constraint constraint, TransformationContext transformationContext) {
        if (constraint == null) {
            return constraint;
        }
        if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            Constraint constraint2 = this.transform(propertyConstraint, transformationContext);
            return constraint2;
        }
        if (constraint instanceof RelationalConstraint) {
            Constraint constraint3;
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            relationalConstraint.constraintOnRelatedObject = constraint3 = this.transform(relationalConstraint.constraintOnRelatedObject, transformationContext);
            return relationalConstraint;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (ArrayUtils.isEmpty((Object[])compositeConstraint.nestedConstraints)) {
                return compositeConstraint;
            }
            for (int i = 0; i < compositeConstraint.nestedConstraints.length; ++i) {
                Constraint constraint4;
                compositeConstraint.nestedConstraints[i] = constraint4 = this.transform(compositeConstraint.nestedConstraints[i], transformationContext);
            }
            return compositeConstraint;
        }
        return constraint;
    }

    private Constraint transform(PropertyConstraint propertyConstraint, TransformationContext transformationContext) {
        if (!this.isSupportedComparator(propertyConstraint.comparator)) {
            return propertyConstraint;
        }
        Pair pair = new Pair((Object)propertyConstraint.targetType, (Object)propertyConstraint.propertyName, true);
        Map<String, List<String>> map = this._substitutionRegistry.get(pair);
        if (map == null) {
            return propertyConstraint;
        }
        String string = String.valueOf(propertyConstraint.comparableValue);
        List<String> list = map.get(string);
        if (CollectionUtil.isNullOrEmpty(list)) {
            return propertyConstraint;
        }
        Constraint constraint = this.getSubstitutionConstraint(propertyConstraint, list);
        transformationContext.isTransformed = true;
        return constraint;
    }

    private boolean isSupportedComparator(Comparator comparator) {
        switch (comparator) {
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER: 
            case GREATER_OR_EQUALS: 
            case SMALLER: 
            case SMALLER_OR_EQUALS: {
                return true;
            }
        }
        return false;
    }

    private Constraint getSubstitutionConstraint(PropertyConstraint propertyConstraint, List<String> list) {
        int n = list.size();
        if (n == 1) {
            PropertyConstraint propertyConstraint2 = this.copyPropertyConstraintWith(propertyConstraint, list.get(0));
            return propertyConstraint2;
        }
        Constraint[] constraintArray = new PropertyConstraint[n];
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            constraintArray[i] = this.copyPropertyConstraintWith(propertyConstraint, string);
        }
        return QueryUtil.combineIntoSingleConstraint(constraintArray, Conjoiner.OR);
    }

    private PropertyConstraint copyPropertyConstraintWith(PropertyConstraint propertyConstraint, String string) {
        PropertyConstraint propertyConstraint2 = new PropertyConstraint();
        propertyConstraint2.targetType = propertyConstraint.targetType;
        propertyConstraint2.propertyName = propertyConstraint.propertyName;
        propertyConstraint2.comparator = propertyConstraint.comparator;
        propertyConstraint2.comparableValue = string;
        return propertyConstraint2;
    }

    private static class TransformationContext {
        public boolean isTransformed = false;

        private TransformationContext() {
        }
    }
}

