/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import java.util.Comparator;

public final class ResultItemComparator
implements Comparator<ResultItem> {
    private final OrderingCriteria _orderingCriteria;

    public ResultItemComparator(OrderingCriteria orderingCriteria) {
        this._orderingCriteria = orderingCriteria;
    }

    @Override
    public int compare(ResultItem resultItem, ResultItem resultItem2) {
        if (this._orderingCriteria == null || ArrayUtil.isNullOrEmpty((Object[])this._orderingCriteria.orderingProperties)) {
            return 0;
        }
        for (OrderingPropertySpec orderingPropertySpec : this._orderingCriteria.orderingProperties) {
            boolean bl = this.isOrderingAscending(orderingPropertySpec);
            for (String string : orderingPropertySpec.propertyNames) {
                PropertyValue propertyValue;
                PropertyValue propertyValue2 = ResultUtil.getPropertyValue(resultItem, string);
                int n = this.compareTo(propertyValue2, propertyValue = ResultUtil.getPropertyValue(resultItem2, string), bl);
                if (n == 0) continue;
                return n;
            }
        }
        return 0;
    }

    private int compareTo(PropertyValue propertyValue, PropertyValue propertyValue2, boolean bl) {
        boolean bl2 = this.isValueNull(propertyValue);
        boolean bl3 = this.isValueNull(propertyValue2);
        int n = bl2 || bl3 ? (bl2 == bl3 ? 0 : (bl2 ? -1 : 1)) : this.compareTo(propertyValue.value, propertyValue2.value);
        return bl ? n : -n;
    }

    private int compareTo(Object object, Object object2) {
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        return object.toString().compareToIgnoreCase(object2.toString());
    }

    private boolean isValueNull(PropertyValue propertyValue) {
        return propertyValue == null || propertyValue.value == null;
    }

    private boolean isOrderingAscending(OrderingPropertySpec orderingPropertySpec) {
        return orderingPropertySpec.orderingType == null || orderingPropertySpec.orderingType == SortType.ASCENDING;
    }
}

