/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuerySpecBuilderImpl
implements QuerySpecBuilder {
    private static final Logger _logger = LoggerFactory.getLogger(QuerySpecBuilderImpl.class);
    public static final Constraint[] EMPTY_CONSTRAINTS = new Constraint[0];
    public static final ResultSet[] EMPTYSET = new ResultSet[0];
    private final ObjectReferenceService _objectReferenceService;

    public QuerySpecBuilderImpl(ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService});
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    public QuerySpec buildQuerySpec(Object object, String[] stringArray) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        String string = this._objectReferenceService.getResourceObjectType(object);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        QuerySpec querySpec = this.buildQuerySpec(objectIdentityConstraint, stringArray, hashSet);
        return querySpec;
    }

    @Override
    public QuerySpec buildQuerySpec(Object[] objectArray, String[] stringArray) {
        if (objectArray.length == 1) {
            return this.buildQuerySpec(objectArray[0], stringArray);
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        Constraint[] constraintArray = new Constraint[objectArray.length];
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = objectArray[i];
            constraintArray[i] = objectIdentityConstraint;
            string = this._objectReferenceService.getResourceObjectType(objectIdentityConstraint.target);
            hashSet.add(string);
        }
        compositeConstraint.nestedConstraints = constraintArray;
        QuerySpec querySpec = this.buildQuerySpec(compositeConstraint, stringArray, hashSet);
        return querySpec;
    }

    @Override
    public QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray) {
        Set<String> set = constraint.targetType == null ? null : Collections.singleton(constraint.targetType);
        QuerySpec querySpec = this.buildQuerySpec(constraint, stringArray, set);
        return querySpec;
    }

    @Override
    public QuerySpec buildQuerySpec(Constraint constraint, String[] stringArray, Set<String> set) {
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        if (set != null) {
            for (String string : set) {
                PropertySpec propertySpec = this.createPropertySpec(stringArray, string);
                arrayList.add(propertySpec);
            }
        } else {
            PropertySpec propertySpec = this.createPropertySpec(stringArray, null);
            arrayList.add(propertySpec);
        }
        resourceSpec.propertySpecs = arrayList.toArray(new PropertySpec[0]);
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    @Override
    public PropertySpec createPropertySpec(String[] stringArray, String string) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = string;
        propertySpec.propertyNames = stringArray;
        return propertySpec;
    }

    @Override
    public ResourceSpec createEmptyResourceSpec() {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[0];
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        return resourceSpec;
    }

    @Override
    public boolean areEquivalent(QuerySpec querySpec, QuerySpec querySpec2) {
        if (querySpec == querySpec2) {
            return true;
        }
        if (querySpec == null || querySpec2 == null) {
            return false;
        }
        return ObjectUtil.objectsEqual((Object)querySpec.resourceSpec, (Object)querySpec2.resourceSpec) && ObjectUtil.objectsEqual((Object)querySpec.resultSpec, (Object)querySpec2.resultSpec) && ObjectUtil.objectsEqual(querySpec.options, querySpec2.options);
    }

    @Override
    public Map<String, Set<String>> getQueryProperties(QuerySpec querySpec, boolean bl) {
        if (querySpec == null || querySpec.resourceSpec == null || ArrayUtil.isNullOrEmpty((Object[])querySpec.resourceSpec.propertySpecs)) {
            return new HashMap<String, Set<String>>();
        }
        Set<String> set = this.getConstraintTargetTypes(querySpec.resourceSpec.constraint, bl);
        PropertySpec[] propertySpecArray = querySpec.resourceSpec.propertySpecs;
        if (set.isEmpty()) {
            set.add("*");
        }
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (PropertySpec propertySpec : propertySpecArray) {
            if (!this.isValidNonRelational(propertySpec)) continue;
            if (StringUtil.isNullOrEmpty((String)propertySpec.type) || "*".equals(propertySpec.type)) {
                for (String string : set) {
                    this.addQueryProperties(hashMap, string, propertySpec.propertyNames);
                }
                continue;
            }
            this.addQueryProperties(hashMap, propertySpec.type, propertySpec.propertyNames);
        }
        return hashMap;
    }

    private void addQueryProperties(Map<String, Set<String>> map, String string, String[] stringArray) {
        Set<String> set = map.get(string);
        if (set == null) {
            set = new HashSet<String>();
            map.put(string, set);
        }
        for (String string2 : stringArray) {
            set.add(Utils.stripIfEndsWith(string2, ".@formatted"));
        }
    }

    private boolean isValidNonRelational(PropertySpec propertySpec) {
        return propertySpec != null && StringUtil.isNullOrEmpty((String)propertySpec.relation) && !ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames);
    }

    @Override
    public RelationalConstraint createRelationalConstraint(String string, Constraint constraint, Boolean bl, String string2) {
        RelationalConstraint relationalConstraint = new RelationalConstraint();
        relationalConstraint.relation = string;
        relationalConstraint.hasInverseRelation = bl;
        relationalConstraint.constraintOnRelatedObject = constraint;
        relationalConstraint.targetType = string2;
        return relationalConstraint;
    }

    @Override
    public Constraint createConstraintForRelationship(Object object, String string, String string2) {
        ObjectIdentityConstraint objectIdentityConstraint = this.createObjectIdentityConstraint(object);
        RelationalConstraint relationalConstraint = this.createRelationalConstraint(string, objectIdentityConstraint, true, string2);
        return relationalConstraint;
    }

    @Override
    public PropertyConstraint createPropertyConstraint(String string, String string2, Comparator comparator, Object object) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string;
        propertyConstraint.propertyName = string2;
        propertyConstraint.comparator = comparator;
        propertyConstraint.comparableValue = object;
        return propertyConstraint;
    }

    @Override
    public Constraint combineIntoSingleConstraint(Constraint[] constraintArray, Conjoiner conjoiner) {
        if (ArrayUtil.isNullOrEmpty((Object[])constraintArray)) {
            return null;
        }
        if (constraintArray.length == 1) {
            return constraintArray[0];
        }
        return this.createCompositeConstraint(constraintArray, conjoiner);
    }

    @Override
    public Constraint combineIntoSingleConstraint(Object[] objectArray, Conjoiner conjoiner) {
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        Constraint[] constraintArray = new Constraint[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = objectArray[i];
            objectIdentityConstraint.targetType = this._objectReferenceService.getResourceObjectType(objectArray[i]);
            constraintArray[i] = objectIdentityConstraint;
        }
        if (objectArray.length == 1) {
            return constraintArray[0];
        }
        return this.createCompositeConstraint(constraintArray, conjoiner);
    }

    @Override
    public CompositeConstraint createCompositeConstraint(Constraint[] constraintArray, Conjoiner conjoiner) {
        HashSet<String> hashSet = new HashSet<String>(constraintArray.length);
        for (Constraint constraint : constraintArray) {
            hashSet.add(constraint.targetType);
        }
        Constraint[] constraintArray2 = hashSet.size() == 1 ? (String)hashSet.iterator().next() : null;
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = constraintArray2;
        compositeConstraint.nestedConstraints = constraintArray;
        compositeConstraint.conjoiner = conjoiner;
        return compositeConstraint;
    }

    @Override
    public ObjectIdentityConstraint createObjectIdentityConstraint(Object object) {
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        objectIdentityConstraint.targetType = this._objectReferenceService.getResourceObjectType(object);
        return objectIdentityConstraint;
    }

    @Override
    public boolean validateQueryConstraint(Constraint constraint) {
        if (constraint == null) {
            _logger.warn("Invalid constraint: constraint is null");
            return false;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            boolean bl;
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            boolean bl2 = bl = objectIdentityConstraint.target != null;
            if (!bl) {
                _logger.warn("Invalid constraint: constraint target is null");
            }
            return bl;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            if (StringUtil.isNullOrEmpty((String)relationalConstraint.relation)) {
                _logger.warn("Invalid constraint: relational constraint's relation is null");
                return false;
            }
            return this.validateQueryConstraint(relationalConstraint.constraintOnRelatedObject);
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.nestedConstraints == null) {
                _logger.warn("Invalid composite constraint: nested constraints are null");
                return false;
            }
            if (compositeConstraint.nestedConstraints.length == 0) {
                _logger.warn("Invalid composite constraint: nested constraints are empty");
                return false;
            }
            if (compositeConstraint.conjoiner == null) {
                _logger.warn("Invalid composite constraint: conjoiner is null");
                return false;
            }
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                if (this.validateQueryConstraint(constraint2)) continue;
                return false;
            }
        } else if (constraint instanceof PropertyConstraint) {
            boolean bl;
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            boolean bl3 = bl = propertyConstraint.comparator != null;
            if (!bl) {
                _logger.warn("Invalid constraint: property constraint comparator is null");
            }
            return bl;
        }
        return true;
    }

    @Override
    public Set<String> getConstraintTargetTypes(Constraint constraint, boolean bl) {
        if (constraint == null || constraint instanceof RelationalConstraint && ((RelationalConstraint)constraint).hasInverseRelation) {
            return new HashSet<String>();
        }
        String string = constraint.targetType;
        if (constraint instanceof ObjectIdentityConstraint) {
            string = this._objectReferenceService.getResourceObjectType(((ObjectIdentityConstraint)constraint).target);
        } else if (constraint instanceof CompositeConstraint) {
            Constraint[] constraintArray = ((CompositeConstraint)constraint).nestedConstraints;
            constraintArray = constraintArray == null ? new Constraint[]{} : constraintArray;
            HashSet<String> hashSet = new HashSet<String>();
            for (Constraint constraint2 : constraintArray) {
                Set<String> set = this.getConstraintTargetTypes(constraint2, bl);
                if (set.isEmpty()) continue;
                hashSet.addAll(set);
            }
            if (!hashSet.isEmpty()) {
                if (bl) {
                    return hashSet;
                }
                if (hashSet.size() == 1) {
                    string = (String)hashSet.iterator().next();
                }
            }
        }
        return StringUtil.isNullOrEmpty((String)string) ? new HashSet<String>() : new HashSet<String>(Arrays.asList(string));
    }

    @Override
    public String getConstraintTargetType(Constraint constraint) {
        Set<String> set = this.getConstraintTargetTypes(constraint, false);
        if (set != null && set.size() == 1) {
            return set.iterator().next();
        }
        return null;
    }
}

