/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query.util.impl;

import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultAnalyzer;
import com.vmware.vise.util.ArrayUtil;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;

public final class ResultAnalyzerImpl
implements ResultAnalyzer {
    @Override
    public <T> T findPropertyValueIn(String string, List<ResultItem> list) {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return null;
        }
        for (ResultItem resultItem : list) {
            Object[] objectArray = resultItem.properties;
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!((PropertyValue)object).propertyName.equals(string)) continue;
                return (T)((PropertyValue)object).value;
            }
        }
        return null;
    }

    @Override
    public boolean checkProperties(PropertyValue[] propertyValueArray, String[] stringArray) {
        if (propertyValueArray == null || stringArray == null || propertyValueArray.length < stringArray.length) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertyValue object : propertyValueArray) {
            if (object == null || object.value == null) {
                return false;
            }
            hashSet.add(object.propertyName);
        }
        for (String string : stringArray) {
            if (string == null || hashSet.contains(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] findMoRefsIn(ResultSet resultSet) {
        ResultItem[] resultItemArray;
        Object[] objectArray = null;
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0) {
            objectArray = (Object[])Array.newInstance(resultItemArray[0].resourceObject.getClass(), resultItemArray.length);
            for (int i = 0; i < resultItemArray.length; ++i) {
                objectArray[i] = resultItemArray[i].resourceObject;
            }
        }
        return objectArray;
    }

    @Override
    public String getLocalizedString(String string) {
        return Utils.getLocalizedString(string);
    }
}

