/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.uri;

import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.uri.ResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class UriRefTypeAdapter
implements ResourceObjectReferenceAdapter,
ResourceTypeResolverRegistry {
    private final ConcurrentMap<String, ResourceTypeResolver> _resolverByPrefix = new ConcurrentHashMap<String, ResourceTypeResolver>();

    public static UriRefTypeAdapter getUriRefTypeAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        UriRefTypeAdapter uriRefTypeAdapter = new UriRefTypeAdapter();
        if (dataServiceExtensionRegistry != null) {
            dataServiceExtensionRegistry.registerObjectRefTypeAdapter(uriRefTypeAdapter, URI.class, "urn:vri");
            dataServiceExtensionRegistry.registerObjectRefTypeAdapter(uriRefTypeAdapter, URI.class, "urn");
        }
        return uriRefTypeAdapter;
    }

    @Override
    public void registerSchemeResolver(String string, ResourceTypeResolver resourceTypeResolver) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, resourceTypeResolver});
        ResourceTypeResolver resourceTypeResolver2 = this._resolverByPrefix.putIfAbsent(string, resourceTypeResolver);
        if (resourceTypeResolver2 != null) {
            throw new UnsupportedOperationException("Cannot register more than one ResourceTypeResolver per URI scheme.");
        }
    }

    @Override
    public void unregisterSchemeResolver(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        this._resolverByPrefix.remove(string);
    }

    @Override
    public Object getReference(String string) {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid URI provided.", uRISyntaxException);
        }
        return uRI;
    }

    @Override
    public String getServerGuid(Object object) {
        URI uRI = UriRefTypeAdapter.toURI(object);
        String string = this.findUidPrefix(uRI.toString());
        ResourceTypeResolver resourceTypeResolver = (ResourceTypeResolver)this._resolverByPrefix.get(string);
        if (resourceTypeResolver == null) {
            return null;
        }
        String string2 = resourceTypeResolver.getServerGuid(uRI);
        return string2;
    }

    @Override
    public String getResourceType(Object object) {
        URI uRI = UriRefTypeAdapter.toURI(object);
        String string = this.findUidPrefix(uRI.toString());
        ResourceTypeResolver resourceTypeResolver = (ResourceTypeResolver)this._resolverByPrefix.get(string);
        if (resourceTypeResolver == null) {
            return null;
        }
        String string2 = resourceTypeResolver.getResourceType(uRI);
        return string2;
    }

    @Override
    public String getUid(Object object) {
        URI uRI = UriRefTypeAdapter.toURI(object);
        String string = uRI.toString();
        return string;
    }

    private static URI toURI(Object object) {
        if (!(object instanceof URI)) {
            throw new IllegalArgumentException("Reference of invalid type provided. Expected " + URI.class.getName());
        }
        URI uRI = (URI)object;
        return uRI;
    }

    private String findUidPrefix(String string) {
        assert (string != null);
        String string2 = "";
        for (String string3 : this._resolverByPrefix.keySet()) {
            String string4 = string3 + ":";
            if (!string.startsWith(string4) || string3.length() <= string2.length()) continue;
            string2 = string3;
        }
        return string2;
    }
}

