/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.uri;

import com.vmware.vise.util.StringUtil;
import java.net.URI;

public final class VapiUriSchemeUtil {
    private static final String URI_PREFIX = "urn:vapi:";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char TYPE_SEPARATOR = ':';

    public static URI createUri(String string, String string2) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Resource type must not be null or empty");
        }
        if (string.indexOf(58) >= 0) {
            throw new IllegalArgumentException(String.format("Resource type must not contain colons: '%s'", string));
        }
        if (StringUtil.isNullOrEmpty((String)string2)) {
            throw new IllegalArgumentException("vAPI ID must not be null or empty");
        }
        if (string.indexOf(46) <= 0) {
            throw new IllegalArgumentException(String.format("Cannot create an URI resource reference for a VMODL1 resource type (i.e. resource type is not qualified with package name): '%s'", string));
        }
        return URI.create(URI_PREFIX + string + ':' + string2);
    }

    public static String getId(URI uRI) {
        VapiUriSchemeUtil.validateVapiUri(uRI);
        String string = uRI.toString();
        int n = VapiUriSchemeUtil.getTypeSeparatorIndex(string);
        return string.substring(n + 1);
    }

    public static String getType(URI uRI) {
        VapiUriSchemeUtil.validateVapiUri(uRI);
        String string = uRI.toString();
        int n = VapiUriSchemeUtil.getTypeSeparatorIndex(string);
        return string.substring(URI_PREFIX.length(), n);
    }

    public static boolean isVapiUri(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        return uRI.toString().startsWith(URI_PREFIX);
    }

    private static void validateVapiUri(URI uRI) {
        if (!VapiUriSchemeUtil.isVapiUri(uRI)) {
            throw new IllegalArgumentException("Not a vAPI URI: " + uRI.toString());
        }
    }

    private static int getTypeSeparatorIndex(String string) {
        int n = string.indexOf(58, URI_PREFIX.length());
        if (n < 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("Invalid vAPI URI: " + string);
        }
        return n;
    }
}

