/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.Units;
import com.vmware.vise.util.i18n.MessageLocalizer;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.text.ParseException;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@data
public class DataElementDescriptor
extends Descriptor {
    private static final Log _logger = LogFactory.getLog(DataElementDescriptor.class);
    @XmlAttribute(required=true)
    public String valueTypeName;
    public XSFacet[] staticValueSpace;
    public QuerySpec dynamicValueSpace;
    @XmlElement(required=true)
    public String providerName;
    public boolean isOptional;
    public Object defaultValue;
    public Units unit;
    public Units displayForm;

    public DataElementDescriptor() {
    }

    public DataElementDescriptor(DataElementDescriptor dataElementDescriptor) {
        dataElementDescriptor.copyFieldsTo(this, false);
    }

    @Override
    protected void copyFieldsTo(Descriptor descriptor, boolean bl) {
        super.copyFieldsTo(descriptor, bl);
        if (descriptor instanceof DataElementDescriptor) {
            DataElementDescriptor dataElementDescriptor = (DataElementDescriptor)descriptor;
            dataElementDescriptor.valueTypeName = this.valueTypeName;
            if (bl && this.staticValueSpace != null) {
                int n = this.staticValueSpace.length;
                dataElementDescriptor.staticValueSpace = new XSFacet[n];
                for (int i = 0; i < n; ++i) {
                    dataElementDescriptor.staticValueSpace[i] = this.cloneXSFacetForLocalization(this.staticValueSpace[i]);
                }
            } else {
                dataElementDescriptor.staticValueSpace = this.staticValueSpace;
            }
            dataElementDescriptor.dynamicValueSpace = this.dynamicValueSpace;
            dataElementDescriptor.providerName = this.providerName;
            dataElementDescriptor.isOptional = this.isOptional;
            dataElementDescriptor.defaultValue = this.defaultValue;
            dataElementDescriptor.unit = this.unit;
            dataElementDescriptor.displayForm = this.displayForm;
        }
    }

    private XSFacet cloneXSFacetForLocalization(XSFacet xSFacet) {
        if (xSFacet == null) {
            return null;
        }
        Object object = xSFacet.value;
        if (object instanceof NameValuePair) {
            XSFacet xSFacet2 = new XSFacet();
            xSFacet2.type = xSFacet.type;
            NameValuePair nameValuePair = (NameValuePair)object;
            NameValuePair nameValuePair2 = new NameValuePair(nameValuePair.name, nameValuePair.value);
            xSFacet2.value = nameValuePair2;
            return xSFacet2;
        }
        return xSFacet;
    }

    @Override
    protected void localize(MessageLocalizer messageLocalizer) {
        super.localize(messageLocalizer);
        if (messageLocalizer == null || this.staticValueSpace == null) {
            return;
        }
        XSFacet[] xSFacetArray = this.staticValueSpace;
        int n = xSFacetArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            XSFacet xSFacet = xSFacetArray[i];
            if (xSFacet == null || !((object = xSFacet.value) instanceof NameValuePair)) continue;
            NameValuePair nameValuePair = (NameValuePair)object;
            try {
                String string = ResourceUtil.localizeString((String)nameValuePair.name, (MessageLocalizer)messageLocalizer);
                if (string == null || string.equals(nameValuePair.name)) continue;
                nameValuePair.name = string;
                continue;
            }
            catch (ParseException parseException) {
                _logger.error((Object)("Failed to localize a staticValueSpace label at position " + i + " (0-based) for descriptor " + this.providerName + " / " + this.name + ". The key that could not be localized was: " + nameValuePair.name), (Throwable)parseException);
            }
        }
    }

    @Override
    protected void appendFieldValuesTo(StringBuilder stringBuilder) {
        super.appendFieldValuesTo(stringBuilder);
        stringBuilder.append(", valueTypeName=").append(this.valueTypeName).append(", providerName=").append(this.providerName).append(", isOptional=").append(this.isOptional).append(", defaultValue=").append(this.defaultValue).append(", unit=").append((Object)this.unit).append(", displayForm=").append((Object)this.displayForm).append(", staticValueSpace=").append(Arrays.toString(this.staticValueSpace)).append(", dynamicValueSpace=").append(this.dynamicValueSpace != null ? Utils.renderQuerySpec(this.dynamicValueSpace) : null);
    }
}

