/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata;

import com.vmware.vise.core.model.data;
import com.vmware.vise.metadata.impl.jaxb.JaxbTagsMapAdapter;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.MessageLocalizer;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@data
public class Descriptor
implements Cloneable {
    private static final Log _logger = LogFactory.getLog(Descriptor.class);
    @XmlAttribute(required=true)
    public String name;
    @XmlAttribute
    public String title;
    @XmlAttribute
    public String description;
    @XmlJavaTypeAdapter(value=JaxbTagsMapAdapter.class)
    public Map<String, String> tags;

    public Descriptor() {
    }

    public Descriptor(String string, String string2, String string3, Map<String, String> map) {
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("The name shouldn't be null or whitespace");
        }
        this.name = string;
        this.title = string2;
        this.description = string3;
        if (map != null) {
            this.tags = new HashMap<String, String>(map);
        }
    }

    public Descriptor(Descriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Cannot create a copy of a null " + this.getClass().getName());
        }
        descriptor.copyFieldsTo(this, false);
    }

    public Descriptor buildLocalizedCopy(MessageLocalizer messageLocalizer) {
        Descriptor descriptor = this.createInstanceForLocalization();
        this.copyFieldsTo(descriptor, true);
        descriptor.localize(messageLocalizer);
        return descriptor;
    }

    protected Descriptor createInstanceForLocalization() {
        try {
            return (Descriptor)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Failed to create a copy of a " + this.getClass().getName() + " for localization", exception);
        }
    }

    protected void copyFieldsTo(Descriptor descriptor, boolean bl) {
        if (descriptor == null) {
            throw new IllegalArgumentException("The 'target' Desscriptor should not be null");
        }
        descriptor.name = this.name;
        descriptor.title = this.title;
        descriptor.description = this.description;
        descriptor.tags = this.tags;
    }

    protected void localize(MessageLocalizer messageLocalizer) {
        if (messageLocalizer == null) {
            return;
        }
        try {
            this.title = ResourceUtil.localizeString((String)this.title, (MessageLocalizer)messageLocalizer);
        }
        catch (ParseException parseException) {
            _logger.error((Object)"Failed to localize a descriptor's title.", (Throwable)parseException);
        }
        try {
            this.description = ResourceUtil.localizeString((String)this.description, (MessageLocalizer)messageLocalizer);
        }
        catch (ParseException parseException) {
            _logger.error((Object)"Failed to localize a descriptor's description.", (Throwable)parseException);
        }
    }

    protected void appendFieldValuesTo(StringBuilder stringBuilder) {
        stringBuilder.append("name=").append(this.name).append(", title=").append(this.title).append(", description=").append(this.description).append(", tags=").append(this.tags);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append('[').append(this.getClass().getSimpleName()).append(": ");
        this.appendFieldValuesTo(stringBuilder);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

