/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.metadata.impl;

import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.metadata.impl.TypeOwnership;

public class TypeDescriptorEx {
    private final TypeDescriptor _typeDescriptor;
    private final TypeOwnership _ownership;

    public TypeDescriptorEx(TypeDescriptor typeDescriptor) {
        this(typeDescriptor, null);
    }

    public TypeDescriptorEx(TypeDescriptor typeDescriptor, TypeOwnership typeOwnership) {
        if (typeDescriptor == null) {
            throw new IllegalArgumentException("The typeDescriptor shouldn't be null");
        }
        this._typeDescriptor = typeDescriptor;
        this._ownership = typeOwnership != null ? typeOwnership : TypeOwnership.COMMON;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this._typeDescriptor;
    }

    public TypeOwnership getOwnership() {
        return this._ownership;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("typeDescriptor: [").append(this._typeDescriptor.toString()).append("], ownership: ").append((Object)this._ownership);
        return stringBuilder.toString();
    }

    public static TypeDescriptor[] toTypeDescriptors(TypeDescriptorEx[] typeDescriptorExArray) {
        if (typeDescriptorExArray == null) {
            return null;
        }
        int n = typeDescriptorExArray.length;
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[n];
        for (int i = 0; i < n; ++i) {
            TypeDescriptorEx typeDescriptorEx = typeDescriptorExArray[i];
            typeDescriptorArray[i] = typeDescriptorEx != null ? typeDescriptorEx.getTypeDescriptor() : null;
        }
        return typeDescriptorArray;
    }
}

