/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.adapter;

import com.vmware.license.client.cis.util.ExceptionUtil;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseDataProviderAdapterImpl
implements DataProviderAdapter {
    private final Log _logger = LogFactory.getLog(BaseDataProviderAdapterImpl.class);

    public final Response getData(RequestSpec requestSpec) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = this.processQuery(querySpecArray[i]);
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    protected abstract ResultSet getResultSet(QuerySpec var1);

    private ResultSet processQuery(QuerySpec querySpec) {
        ResultSet resultSet = null;
        try {
            resultSet = this.getResultSet(querySpec);
        }
        catch (Throwable throwable) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Unable to retrieve licensing data: ", throwable);
            }
            resultSet = ResultUtil.newEmptyResultSet();
            resultSet.error = ExceptionUtil.createLocalizedException(throwable);
        }
        resultSet.queryName = querySpec.name;
        return resultSet;
    }
}

