/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.impl;

import com.vmware.license.client.cis.LicensingGlobalDataEditor;
import com.vmware.license.client.cis.ds.LicensingGlobalData;
import com.vmware.license.client.cis.ls.AuthorizationException;
import com.vmware.license.client.cis.ls.AuthorizationManager;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.TopologyInfoProvider;
import com.vmware.license.client.cis.ls.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicensingGlobalDataEditorImpl
implements LicensingGlobalDataEditor {
    private final Log _logger = LogFactory.getLog(LicensingGlobalDataEditorImpl.class);
    private final TopologyInfoProvider _topologyInfoProvider;
    private final AuthorizationManager _authorizationManager;

    public LicensingGlobalDataEditorImpl(TopologyInfoProvider topologyInfoProvider, AuthorizationManager authorizationManager) {
        this._topologyInfoProvider = topologyInfoProvider;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public LicensingGlobalData getLicensingGlobalData(URI uRI) {
        if (!UriUtil.isUriOfType(uRI, "LicensingGlobalData")) {
            throw new IllegalArgumentException("Invalid URI: " + uRI);
        }
        int n = this.getLicenseServicesCount();
        boolean bl = n > 1;
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        boolean bl2 = this.isLicensingAdminPrivilegeGranted(licenseScope);
        return this.createLicensingGlobalData(uRI, bl, bl2);
    }

    private int getLicenseServicesCount() {
        try {
            return this._topologyInfoProvider.getLicenseServicesCount();
        }
        catch (TopologyInfoRetrievalException topologyInfoRetrievalException) {
            throw new ManagementException(topologyInfoRetrievalException);
        }
    }

    private boolean isLicensingAdminPrivilegeGranted(LicenseScope licenseScope) {
        try {
            return this._authorizationManager.isLicensingAdminPrivilegeGranted(licenseScope);
        }
        catch (AuthorizationException authorizationException) {
            this._logger.error((Object)"Error when retrieving licensing admin privileges.", (Throwable)authorizationException);
            throw new ManagementException(ManagementUtil.getLocalizedString("error.lsPrivilegeRetrieval"));
        }
    }

    private LicensingGlobalData createLicensingGlobalData(URI uRI, boolean bl, boolean bl2) {
        LicensingGlobalData licensingGlobalData = new LicensingGlobalData();
        licensingGlobalData.setUri(uRI);
        licensingGlobalData.setDataReplicationDelayed(bl);
        licensingGlobalData.setLicensingAdminPrivilegeGranted(bl2);
        return licensingGlobalData;
    }
}

