/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.cis.cm.client.CisServiceType;
import com.vmware.license.client.cis.ls.ComponentManagerClient;
import com.vmware.license.client.cis.ls.TopologyInfoProvider;
import com.vmware.license.client.cis.ls.TopologyInfoRetrievalException;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.site.FolderImpl;
import com.vmware.vise.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CmTopologyInfoProviderImpl
implements TopologyInfoProvider {
    private static final ServiceType LICENSE_SERVICE_TYPE = CisServiceType.LICENSE.getServiceType();
    private static final ServiceType VC_SERVICE_TYPE = new ServiceTypeImpl("com.vmware.cis", "vcenterserver");
    private final ComponentManagerClient _cmClient;

    private static Folder createLocalFolder() {
        FolderImpl folderImpl = new FolderImpl();
        folderImpl.setId("");
        folderImpl.setParentId("");
        return folderImpl;
    }

    public CmTopologyInfoProviderImpl(ComponentManagerClient componentManagerClient) {
        this._cmClient = componentManagerClient;
    }

    @Override
    public int getLicenseServicesCount() throws TopologyInfoRetrievalException {
        ServiceInfo[] serviceInfoArray = this.searchServiceInfos(LICENSE_SERVICE_TYPE);
        return serviceInfoArray == null ? 0 : serviceInfoArray.length;
    }

    @Override
    public String getLocalVcId() throws TopologyInfoRetrievalException {
        ServiceInfo serviceInfo = this.getLocalVcServiceInfo();
        return serviceInfo.getServiceId();
    }

    @Override
    public Map<String, String> getVcIdToNodeId(List<String> list) throws TopologyInfoRetrievalException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (list == null || list.isEmpty()) {
            return hashMap;
        }
        ServiceInfo[] serviceInfoArray = this.searchServiceInfos(VC_SERVICE_TYPE);
        HashSet<String> hashSet = new HashSet<String>(list);
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            String string = serviceInfo.getServiceId();
            if (!hashSet.contains(string)) continue;
            String string2 = this.getNodeId(serviceInfo);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    @Override
    public Map<String, String> getNodeIdToVcId(List<String> list) throws TopologyInfoRetrievalException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (list == null || list.isEmpty()) {
            return hashMap;
        }
        ServiceInfo[] serviceInfoArray = this.searchServiceInfos(VC_SERVICE_TYPE);
        HashSet<String> hashSet = new HashSet<String>(list);
        for (ServiceInfo serviceInfo : serviceInfoArray) {
            String string = this.getNodeId(serviceInfo);
            if (!hashSet.contains(string)) continue;
            String string2 = serviceInfo.getServiceId();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private ServiceInfo getLocalVcServiceInfo() throws TopologyInfoRetrievalException {
        Folder folder = CmTopologyInfoProviderImpl.createLocalFolder();
        Object[] objectArray = this.searchServiceInfos(VC_SERVICE_TYPE, folder);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            throw new TopologyInfoRetrievalException("No VC services found.");
        }
        return objectArray[0];
    }

    private ServiceInfo[] searchServiceInfos(ServiceType serviceType) throws TopologyInfoRetrievalException {
        return this.searchServiceInfos(serviceType, null);
    }

    private ServiceInfo[] searchServiceInfos(ServiceType serviceType, Folder folder) throws TopologyInfoRetrievalException {
        try {
            return this._cmClient.searchServiceInfos(serviceType, folder);
        }
        catch (ComponentManagerFault componentManagerFault) {
            throw new TopologyInfoRetrievalException(componentManagerFault);
        }
    }

    private String getNodeId(ServiceInfo serviceInfo) {
        return serviceInfo.getFolder().getId();
    }
}

