/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.license.client.cis.ls.ComponentManagerClient;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vise.util.debug.TimeMonitor;
import com.vmware.vise.vim.cm.ComponentManagerService;
import java.util.concurrent.TimeUnit;

public class ComponentManagerClientImpl
implements ComponentManagerClient {
    private static final long CM_CALL_LOG_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final ComponentManagerService _cmService;

    private static SearchCriteria createSearchCriteria(ServiceType serviceType, Folder folder) {
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setServiceType(serviceType);
        searchCriteriaImpl.setFolder(folder);
        return searchCriteriaImpl;
    }

    public ComponentManagerClientImpl(ComponentManagerService componentManagerService) {
        this._cmService = componentManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo[] searchServiceInfos(ServiceType serviceType, Folder folder) throws ComponentManagerFault {
        SearchCriteria searchCriteria = ComponentManagerClientImpl.createSearchCriteria(serviceType, folder);
        TimeMonitor timeMonitor = new TimeMonitor();
        try {
            timeMonitor.init();
            ServiceInfo[] serviceInfoArray = this._cmService.search(searchCriteria);
            return serviceInfoArray;
        }
        finally {
            timeMonitor.logTimeIfExceeding(CM_CALL_LOG_THRESHOLD_IN_NANOS, "NGC CM service search", ComponentManagerService.class, (Object)this._cmService);
        }
    }
}

