/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.TopologyInfoProvider;
import com.vmware.license.client.cis.ls.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.adapter.AssetPropertyProviderBean;
import com.vmware.license.client.cis.management.adapter.BaseManagementDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@type(value="Asset")
public class AssetDataProviderAdapterImpl
extends BaseManagementDataProviderAdapterImpl<Asset> {
    private static final String RELATION_ASSETS = "assets";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_VC_SERVICE_ID = "vcServiceId";
    private static final String PROPERTY_MAX_RESULT_OBJECTS = "maxResultObjects";
    private final VpxManagementEditor _vpxManagementEditor;
    private final TopologyInfoProvider _topologyInfoProvider;

    private static URI getSingleUri(Object[] objectArray) {
        return (URI)objectArray[0];
    }

    public AssetDataProviderAdapterImpl(VpxManagementEditor vpxManagementEditor, TopologyInfoProvider topologyInfoProvider) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._topologyInfoProvider = topologyInfoProvider;
    }

    @Override
    protected BasePropertyProviderBean<Asset> getPropertyProvider() {
        return new AssetPropertyProviderBean();
    }

    @Override
    protected String getProvidedType() {
        return "Asset";
    }

    @Override
    protected URI getUri(Asset asset) {
        return asset.getUri();
    }

    protected Asset[] getObjectsByScope(LicenseScope licenseScope) {
        return this._vpxManagementEditor.getAssets((URI[])null, licenseScope);
    }

    protected Asset[] getObjectsByUrisAndScope(URI[] uRIArray, LicenseScope licenseScope) {
        return this._vpxManagementEditor.getAssets(uRIArray, licenseScope);
    }

    protected Asset[] getRelatedObjects(Object[] objectArray, String string) {
        if (!RELATION_ASSETS.equals(string)) {
            return (Asset[])super.getRelatedObjects(objectArray, string);
        }
        ManagedObjectReference[] managedObjectReferenceArray = new ManagedObjectReference[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof ManagedObjectReference)) {
                return (Asset[])super.getRelatedObjects(objectArray, string);
            }
            managedObjectReferenceArray[i] = (ManagedObjectReference)objectArray[i];
        }
        return this.getAssetsByMoRefs(managedObjectReferenceArray);
    }

    protected Asset[] getObjectsByCompositeConstraint(CompositeConstraint compositeConstraint) {
        AssetConstraintProperties assetConstraintProperties = this.getAssetConstraintProperties(compositeConstraint);
        if (assetConstraintProperties == null) {
            return (Asset[])super.getObjectsByCompositeConstraint(compositeConstraint);
        }
        Asset[] assetArray = this.getAssetsByConstraintProperties(assetConstraintProperties);
        return assetArray;
    }

    protected Asset[] getAllObjects() {
        return null;
    }

    private Asset[] getAssetsByMoRefs(ManagedObjectReference[] managedObjectReferenceArray) {
        Map<LicenseScope, ArrayList<ManagedObjectReference>> map = this.getScopeToMoRefs(managedObjectReferenceArray);
        ArrayList<Asset> arrayList = new ArrayList<Asset>();
        for (Map.Entry<LicenseScope, ArrayList<ManagedObjectReference>> entry : map.entrySet()) {
            Asset[] assetArray = this._vpxManagementEditor.getAssetsByMoRefs(entry.getValue().toArray(new ManagedObjectReference[entry.getValue().size()]), entry.getKey());
            arrayList.addAll(Arrays.asList(assetArray));
        }
        return arrayList.toArray(new Asset[arrayList.size()]);
    }

    private Map<LicenseScope, ArrayList<ManagedObjectReference>> getScopeToMoRefs(ManagedObjectReference[] managedObjectReferenceArray) {
        HashMap<LicenseScope, ArrayList<ManagedObjectReference>> hashMap = new HashMap<LicenseScope, ArrayList<ManagedObjectReference>>();
        if (ArrayUtil.isNullOrEmpty((Object[])managedObjectReferenceArray)) {
            return hashMap;
        }
        for (ManagedObjectReference managedObjectReference : managedObjectReferenceArray) {
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByMoRef(managedObjectReference);
            ArrayList<Object> arrayList = hashMap.get(licenseScope);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(licenseScope, arrayList);
            }
            arrayList.add(managedObjectReference);
        }
        return hashMap;
    }

    private AssetConstraintProperties getAssetConstraintProperties(CompositeConstraint compositeConstraint) {
        if (compositeConstraint.nestedConstraints.length > 1 && !Conjoiner.AND.equals((Object)compositeConstraint.conjoiner)) {
            return null;
        }
        AssetConstraintProperties assetConstraintProperties = new AssetConstraintProperties();
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            PropertyConstraint propertyConstraint;
            if (constraint instanceof PropertyConstraint) {
                propertyConstraint = (PropertyConstraint)constraint;
                assetConstraintProperties = this.getAssetConstraintProperties(assetConstraintProperties, propertyConstraint);
                continue;
            }
            if (constraint instanceof RelationalConstraint) {
                propertyConstraint = (RelationalConstraint)constraint;
                assetConstraintProperties = this.getAssetConstraintProperties(assetConstraintProperties, (RelationalConstraint)propertyConstraint);
                continue;
            }
            assetConstraintProperties = null;
            break;
        }
        return assetConstraintProperties;
    }

    private AssetConstraintProperties getAssetConstraintProperties(AssetConstraintProperties assetConstraintProperties, PropertyConstraint propertyConstraint) {
        AssetConstraintProperties assetConstraintProperties2 = new AssetConstraintProperties(assetConstraintProperties);
        if ("scope".equals(propertyConstraint.propertyName)) {
            assetConstraintProperties2.licenseUiScope = (LicenseUiScope)((Object)propertyConstraint.comparableValue);
        } else if (PROPERTY_TYPE.equals(propertyConstraint.propertyName)) {
            assetConstraintProperties2.type = (AssetType)((Object)propertyConstraint.comparableValue);
        } else if (PROPERTY_VC_SERVICE_ID.equals(propertyConstraint.propertyName)) {
            assetConstraintProperties2.vcServiceId = (String)propertyConstraint.comparableValue;
        } else if (PROPERTY_MAX_RESULT_OBJECTS.equals(propertyConstraint.propertyName)) {
            assetConstraintProperties2.maxResultObjects = (Number)propertyConstraint.comparableValue;
        } else {
            assetConstraintProperties2 = null;
        }
        return assetConstraintProperties2;
    }

    private AssetConstraintProperties getAssetConstraintProperties(AssetConstraintProperties assetConstraintProperties, RelationalConstraint relationalConstraint) {
        if (!RELATION_ASSETS.equals(relationalConstraint.relation)) {
            return null;
        }
        AssetConstraintProperties assetConstraintProperties2 = new AssetConstraintProperties(assetConstraintProperties);
        Object[] objectArray = Utils.getEnumeratedObjects((RelationalConstraint)relationalConstraint);
        if (UriUtil.containsSingleUriWithType(objectArray, "Product")) {
            assetConstraintProperties2.productUri = AssetDataProviderAdapterImpl.getSingleUri(objectArray);
        } else if (UriUtil.containsSingleUriWithType(objectArray, "License")) {
            assetConstraintProperties2.licenseUri = AssetDataProviderAdapterImpl.getSingleUri(objectArray);
        } else {
            assetConstraintProperties2 = null;
        }
        return assetConstraintProperties2;
    }

    private Asset[] getAssetsByConstraintProperties(AssetConstraintProperties assetConstraintProperties) {
        AssetSearchProperties assetSearchProperties = this.getAssetSearchProperties(assetConstraintProperties);
        Asset[] assetArray = null;
        if (assetConstraintProperties.licenseUiScope != null) {
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(assetConstraintProperties.licenseUiScope);
            assetArray = this._vpxManagementEditor.getAssets(licenseScope, assetSearchProperties);
        } else if (assetConstraintProperties.productUri != null) {
            assetArray = this._vpxManagementEditor.getAssetsForProduct(assetConstraintProperties.productUri, assetSearchProperties);
        } else if (assetConstraintProperties.licenseUri != null) {
            assetArray = this._vpxManagementEditor.getAssetsForLicense(assetConstraintProperties.licenseUri, assetSearchProperties);
        }
        return assetArray;
    }

    private AssetSearchProperties getAssetSearchProperties(AssetConstraintProperties assetConstraintProperties) {
        String string = this.getAssetScopeId(assetConstraintProperties.vcServiceId);
        Integer n = assetConstraintProperties.maxResultObjects != null ? Integer.valueOf(assetConstraintProperties.maxResultObjects.intValue()) : null;
        AssetSearchProperties assetSearchProperties = AssetUtil.createAssetSearchProperties(assetConstraintProperties.type, string, n);
        return assetSearchProperties;
    }

    private String getAssetScopeId(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        try {
            Map<String, String> map = this._topologyInfoProvider.getVcIdToNodeId(arrayList);
            return map.get(string);
        }
        catch (TopologyInfoRetrievalException topologyInfoRetrievalException) {
            throw new RuntimeException(topologyInfoRetrievalException);
        }
    }

    private static class AssetConstraintProperties {
        public LicenseUiScope licenseUiScope;
        public URI productUri;
        public URI licenseUri;
        public AssetType type;
        public String vcServiceId;
        public Number maxResultObjects;

        public AssetConstraintProperties() {
        }

        public AssetConstraintProperties(AssetConstraintProperties assetConstraintProperties) {
            this.licenseUiScope = assetConstraintProperties.licenseUiScope;
            this.productUri = assetConstraintProperties.productUri;
            this.licenseUri = assetConstraintProperties.licenseUri;
            this.type = assetConstraintProperties.type;
            this.vcServiceId = assetConstraintProperties.vcServiceId;
            this.maxResultObjects = assetConstraintProperties.maxResultObjects;
        }
    }
}

