/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.adapter.BaseLicensingObjectsDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.adapter.AssetPropertyProviderBean;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;

@type(value="HostSystem,Folder,ClusterComputeResource,Asset")
public class ObjectNavigatorRelatedObjectsDataProviderAdapterImpl
extends BaseLicensingObjectsDataProviderAdapterImpl<Asset> {
    private static final String RELATION_VCS = "vcs";
    private static final String RELATION_HOSTS = "hosts";
    private static final String RELATION_CLUSTERS = "clusters";
    private static final String RELATION_SOLUTIONS = "solutions";
    private final ManagementEditor _managementEditor;

    private static URI getSingleTarget(Constraint constraint) {
        if (!(constraint instanceof ObjectIdentityConstraint)) {
            return null;
        }
        Object object = ((ObjectIdentityConstraint)constraint).target;
        return (URI)object;
    }

    private static AssetType getAssetType(String string) {
        AssetType assetType = null;
        assetType = RELATION_VCS.equals(string) ? AssetType.VC : (RELATION_HOSTS.equals(string) ? AssetType.HOST : (RELATION_CLUSTERS.equals(string) ? AssetType.CLUSTER : (RELATION_SOLUTIONS.equals(string) ? AssetType.SOLUTION : AssetType.UNKNOWN)));
        return assetType;
    }

    private static ResultItem[] getRelatedManagedObjectRefsResultItems(Asset[] assetArray) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (Asset asset : assetArray) {
            ManagedObjectReference managedObjectReference = asset.getRelatedManagedObjectRef();
            if (managedObjectReference == null) continue;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = managedObjectReference;
            arrayList.add(resultItem);
        }
        return arrayList.toArray(new ResultItem[arrayList.size()]);
    }

    public ObjectNavigatorRelatedObjectsDataProviderAdapterImpl(ManagementEditor managementEditor) {
        this._managementEditor = managementEditor;
    }

    @Override
    protected ResultSet getResultSet(QuerySpec querySpec) {
        AssetSearchProperties assetSearchProperties;
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (!(constraint instanceof RelationalConstraint)) {
            return ResultUtil.newEmptyResultSet();
        }
        String string = ((RelationalConstraint)constraint).relation;
        AssetType assetType = ObjectNavigatorRelatedObjectsDataProviderAdapterImpl.getAssetType(string);
        if (AssetType.UNKNOWN.equals((Object)assetType)) {
            return ResultUtil.newEmptyResultSet();
        }
        Constraint constraint2 = ((RelationalConstraint)constraint).constraintOnRelatedObject;
        URI uRI = ObjectNavigatorRelatedObjectsDataProviderAdapterImpl.getSingleTarget(constraint2);
        if (uRI == null) {
            return ResultUtil.newEmptyResultSet();
        }
        Asset[] assetArray = null;
        if (UriUtil.isProductUri(uRI)) {
            assetSearchProperties = AssetUtil.createAssetSearchProperties(assetType);
            assetArray = this._managementEditor.getAssetsForProduct(uRI, assetSearchProperties);
        } else if (UriUtil.isLicenseUri(uRI)) {
            assetSearchProperties = AssetUtil.createAssetSearchProperties(assetType);
            assetArray = this._managementEditor.getAssetsForLicense(uRI, assetSearchProperties);
        }
        if (ArrayUtil.isNullOrEmpty(assetArray)) {
            return ResultUtil.newEmptyResultSet();
        }
        assetSearchProperties = null;
        if (AssetType.SOLUTION.equals((Object)assetType)) {
            assetSearchProperties = this.getResultSet(querySpec, assetArray);
            ((ResultSet)assetSearchProperties).totalMatchedObjectCount = assetArray.length;
        } else {
            assetSearchProperties = new ResultSet();
            ((ResultSet)assetSearchProperties).items = ObjectNavigatorRelatedObjectsDataProviderAdapterImpl.getRelatedManagedObjectRefsResultItems(assetArray);
            ((ResultSet)assetSearchProperties).totalMatchedObjectCount = ((ResultSet)assetSearchProperties).items.length;
        }
        return assetSearchProperties;
    }

    @Override
    protected BasePropertyProviderBean<Asset> getPropertyProvider() {
        return new AssetPropertyProviderBean();
    }

    @Override
    protected URI getUri(Asset asset) {
        return asset.getUri();
    }

    @Override
    protected String getProvidedType() {
        return "Asset";
    }
}

