/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.cis.license.client.MyVMwareUtil;
import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.MyVMwareFormattedContractDetails;
import com.vmware.license.client.cis.management.ds.MyVMwareFormattedCustomLabel;
import com.vmware.license.client.cis.management.ds.MyVMwareFormattedOrderDetails;
import com.vmware.license.client.cis.management.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.management.ds.MyVMwareSerialKeyInfo;
import com.vmware.license.client.cis.management.ds.PayGoEntitlementAccount;
import com.vmware.license.client.cis.management.ds.PayGoLicenseInfo;
import com.vmware.license.client.cis.management.ds.PayGoService;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.FeatureUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.PayGoLicensingUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.util.DateUtil;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagementObjectsFormatterImpl
implements ManagementObjectsFormatter {
    private static final int FAILED_NUMBER_PARSE_ERROR_CODE = -1;
    private final Log _logger = LogFactory.getLog(ManagementObjectsFormatterImpl.class);

    @Override
    public void formatLicenses(License[] licenseArray) {
        this.formatLicenses(licenseArray, true);
    }

    @Override
    public void formatLicenses(License[] licenseArray, boolean bl) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return;
        }
        for (License license : licenseArray) {
            this.formatLicense(license, bl);
        }
    }

    @Override
    public void formatProductAggregations(ProductAggregation[] productAggregationArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])productAggregationArray)) {
            return;
        }
        for (ProductAggregation productAggregation : productAggregationArray) {
            License[] licenseArray = productAggregation.getLicenses();
            boolean bl = ArrayUtil.isNullOrEmpty((Object[])licenseArray) ? false : PayGoLicensingUtil.isPayGoLicense(licenseArray[0]);
            this.formatProduct(productAggregation.getProduct(), bl);
            this.formatLicenses(licenseArray);
        }
    }

    @Override
    public void formatAssets(Asset[] assetArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray)) {
            return;
        }
        for (Asset asset : assetArray) {
            this.formatFeatures(asset.getFeaturesInUse());
            this.formatLicense(asset.getEvaluationLicense());
            this.formatAssetLicense(asset);
            this.formatAssetProductName(asset);
            this.formatAssetCostUnits(asset);
        }
    }

    @Override
    public void formatPayGoEntitlementAccounts(PayGoEntitlementAccount[] payGoEntitlementAccountArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])payGoEntitlementAccountArray)) {
            return;
        }
        for (PayGoEntitlementAccount payGoEntitlementAccount : payGoEntitlementAccountArray) {
            this.formatPayGoEntitlementAccount(payGoEntitlementAccount);
        }
    }

    @Override
    public void formatPayGoServices(PayGoService[] payGoServiceArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])payGoServiceArray)) {
            return;
        }
        for (PayGoService payGoService : payGoServiceArray) {
            this.formatPayGoService(payGoService);
        }
    }

    private void formatLicense(License license) {
        this.formatLicense(license, true);
    }

    private void formatLicense(License license, boolean bl) {
        if (license == null) {
            return;
        }
        if (license.getIsEvaluation()) {
            license.setName(ManagementObjectsFormatterImpl.getEvaluationLicenseName());
        }
        String string = LicenseUtil.getLicenseFormattedExpirationDate(license.getExpirationDate(), license.getExpirationTime());
        license.setFormattedExpirationDate(string);
        this.formatLicenseProductRestrictions(license);
        this.formatPayGoLicenseInfo(license.getPayGoInfo());
        this.formatMyVMwareLicenseInfo(license.getMyVMwareInfo(), bl);
    }

    private void formatLicenseProductRestrictions(License license) {
        ProductRestriction[] productRestrictionArray = license.getProductRestrictions();
        if (ArrayUtil.isNullOrEmpty((Object[])productRestrictionArray)) {
            return;
        }
        boolean bl = PayGoLicensingUtil.isPayGoLicense(license);
        for (ProductRestriction productRestriction : productRestrictionArray) {
            this.formatProduct(productRestriction.getProduct(), bl);
            Collection<ProductCapability> collection = productRestriction.getVersionToProductCapability().values();
            for (ProductCapability productCapability : collection) {
                productCapability.setProperties(null);
                this.formatFeatures(productCapability.getFeatures());
            }
        }
    }

    private void formatProduct(Product product, boolean bl) {
        String string = product.getName();
        CostUnit[] costUnitArray = product.getCostUnits();
        String string2 = null;
        CostUnit[] costUnitArray2 = null;
        if (bl) {
            string2 = string;
            costUnitArray2 = this.filterPayGoCostUnits(costUnitArray);
        } else {
            costUnitArray2 = costUnitArray;
            string2 = ProductUtil.getFormattedName(string, costUnitArray2);
        }
        CostUnitUtil.formatCostUnits(costUnitArray2);
        product.setFormattedName(string2);
        product.setCostUnits(costUnitArray2);
    }

    private void formatFeatures(Feature[] featureArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])featureArray)) {
            return;
        }
        for (Feature feature : featureArray) {
            if (feature == null || feature.getId() == null) continue;
            String string = FeatureUtil.getFeatureFormattedId(feature.getId());
            feature.setFormattedId(string);
        }
    }

    private void formatPayGoLicenseInfo(PayGoLicenseInfo payGoLicenseInfo) {
        if (payGoLicenseInfo == null) {
            return;
        }
        this.formatPayGoEntitlementAccount(payGoLicenseInfo.getEntitlementAccount());
        this.formatPayGoService(payGoLicenseInfo.getService());
        payGoLicenseInfo.setFormattedUserName(payGoLicenseInfo.getUserName());
    }

    private void formatPayGoEntitlementAccount(PayGoEntitlementAccount payGoEntitlementAccount) {
        if (payGoEntitlementAccount == null) {
            return;
        }
        payGoEntitlementAccount.setFormattedAccount(payGoEntitlementAccount.getAccount());
        payGoEntitlementAccount.setFormattedAccount("VMware, Inc. (" + payGoEntitlementAccount.getAccount() + ")");
    }

    private void formatPayGoService(PayGoService payGoService) {
        if (payGoService == null) {
            return;
        }
        payGoService.setFormattedServiceId(payGoService.getServiceId());
        payGoService.setFormattedServiceId("Subscription Service On Demand (" + payGoService.getServiceId() + ")");
    }

    private void formatMyVMwareLicenseInfo(MyVMwareLicenseInfo myVMwareLicenseInfo, boolean bl) {
        if (myVMwareLicenseInfo == null) {
            return;
        }
        MyVMwareSerialKeyInfo[] myVMwareSerialKeyInfoArray = myVMwareLicenseInfo.getSerialKeysInfo();
        if (myVMwareSerialKeyInfoArray == null) {
            return;
        }
        for (MyVMwareSerialKeyInfo myVMwareSerialKeyInfo : myVMwareSerialKeyInfoArray) {
            this.formatMyVMwareSerialKeyInfo(myVMwareSerialKeyInfo, bl);
        }
    }

    private void formatMyVMwareSerialKeyInfo(MyVMwareSerialKeyInfo myVMwareSerialKeyInfo, boolean bl) {
        if (myVMwareSerialKeyInfo == null) {
            return;
        }
        if (myVMwareSerialKeyInfo.getData() == null || myVMwareSerialKeyInfo.getVersion() == null) {
            return;
        }
        LicenseKeyDetails licenseKeyDetails = LicenseKeyDetailsDecoder.decodeLicenseKeyDetails(myVMwareSerialKeyInfo.getData(), myVMwareSerialKeyInfo.getVersion());
        if (licenseKeyDetails == null) {
            this._logger.warn((Object)"Unable to decode license metadata.");
            return;
        }
        myVMwareSerialKeyInfo.setFormattedAccountName(this.getFormattedAccountName(licenseKeyDetails.accountName, licenseKeyDetails.accountNumber));
        myVMwareSerialKeyInfo.setFormattedNotes(licenseKeyDetails.licenseKeyNotes);
        myVMwareSerialKeyInfo.setFormattedCustomLabels(this.getFormattedCustomLabels(licenseKeyDetails.customLabels));
        myVMwareSerialKeyInfo.setFormattedFolderLocation(licenseKeyDetails.folderLocation);
        myVMwareSerialKeyInfo.setFormattedOrdersDetails(this.getFormattedOrdersDetails(licenseKeyDetails.ordersDetails));
        myVMwareSerialKeyInfo.setFormattedContractsDetails(this.getMyVMwareFormattedContractsDetails(licenseKeyDetails.contractsDetails));
        if (bl) {
            myVMwareSerialKeyInfo.setVersion(null);
            myVMwareSerialKeyInfo.setData(null);
        }
    }

    private String getFormattedAccountName(String string, String string2) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string2;
        }
        if (StringUtil.isNullOrEmpty((String)string2)) {
            return string;
        }
        return string2 + " - " + string;
    }

    private MyVMwareFormattedCustomLabel[] getFormattedCustomLabels(KeyAnyValue[] keyAnyValueArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])keyAnyValueArray)) {
            return new MyVMwareFormattedCustomLabel[0];
        }
        MyVMwareFormattedCustomLabel[] myVMwareFormattedCustomLabelArray = new MyVMwareFormattedCustomLabel[keyAnyValueArray.length];
        for (int i = 0; i < myVMwareFormattedCustomLabelArray.length; ++i) {
            myVMwareFormattedCustomLabelArray[i] = this.buildMyVMwareFormattedCustomLabel(keyAnyValueArray[i]);
        }
        return myVMwareFormattedCustomLabelArray;
    }

    private MyVMwareFormattedOrderDetails[] getFormattedOrdersDetails(OrderDetails[] orderDetailsArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])orderDetailsArray)) {
            return new MyVMwareFormattedOrderDetails[0];
        }
        MyVMwareFormattedOrderDetails[] myVMwareFormattedOrderDetailsArray = new MyVMwareFormattedOrderDetails[orderDetailsArray.length];
        for (int i = 0; i < myVMwareFormattedOrderDetailsArray.length; ++i) {
            myVMwareFormattedOrderDetailsArray[i] = this.buildMyVMwareFormattedOrderDetails(orderDetailsArray[i]);
        }
        return myVMwareFormattedOrderDetailsArray;
    }

    private MyVMwareFormattedContractDetails[] getMyVMwareFormattedContractsDetails(ContractDetails[] contractDetailsArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])contractDetailsArray)) {
            return new MyVMwareFormattedContractDetails[0];
        }
        MyVMwareFormattedContractDetails[] myVMwareFormattedContractDetailsArray = new MyVMwareFormattedContractDetails[contractDetailsArray.length];
        for (int i = 0; i < myVMwareFormattedContractDetailsArray.length; ++i) {
            myVMwareFormattedContractDetailsArray[i] = this.buildMyVMwareFormattedContractDetails(contractDetailsArray[i]);
        }
        return myVMwareFormattedContractDetailsArray;
    }

    private MyVMwareFormattedCustomLabel buildMyVMwareFormattedCustomLabel(KeyAnyValue keyAnyValue) {
        MyVMwareFormattedCustomLabel myVMwareFormattedCustomLabel = new MyVMwareFormattedCustomLabel();
        String string = keyAnyValue.getKey();
        Object object = keyAnyValue.getValue();
        String string2 = string;
        String string3 = null;
        String string4 = string;
        if (object != null) {
            string3 = object.toString();
            string4 = string4 + ": " + object;
        }
        myVMwareFormattedCustomLabel.setKey(string2);
        myVMwareFormattedCustomLabel.setValue(string3);
        myVMwareFormattedCustomLabel.setKeyValue(string4);
        return myVMwareFormattedCustomLabel;
    }

    private MyVMwareFormattedOrderDetails buildMyVMwareFormattedOrderDetails(OrderDetails orderDetails) {
        MyVMwareFormattedOrderDetails myVMwareFormattedOrderDetails = new MyVMwareFormattedOrderDetails();
        Date date = DateUtil.getDate(orderDetails.date);
        String string = this.getFormattedLongValue(orderDetails.quantity);
        myVMwareFormattedOrderDetails.setNumber(orderDetails.number);
        myVMwareFormattedOrderDetails.setDate(date);
        myVMwareFormattedOrderDetails.setQuantity(string);
        myVMwareFormattedOrderDetails.setPoNumber(orderDetails.poNumber);
        return myVMwareFormattedOrderDetails;
    }

    private MyVMwareFormattedContractDetails buildMyVMwareFormattedContractDetails(ContractDetails contractDetails) {
        MyVMwareFormattedContractDetails myVMwareFormattedContractDetails = new MyVMwareFormattedContractDetails();
        Date date = DateUtil.getDate(contractDetails.startDate);
        Date date2 = DateUtil.getDate(contractDetails.endDate);
        myVMwareFormattedContractDetails.setSupportLevel(contractDetails.supportLevel);
        myVMwareFormattedContractDetails.setStartDate(date);
        myVMwareFormattedContractDetails.setEndDate(date2);
        myVMwareFormattedContractDetails.setNumber(contractDetails.number);
        myVMwareFormattedContractDetails.setElaFlag(contractDetails.elaFlag);
        return myVMwareFormattedContractDetails;
    }

    private String getFormattedLongValue(long l) {
        if (l == -1L) {
            return null;
        }
        return Long.toString(l);
    }

    private void formatAssetLicense(Asset asset) {
        License license = asset.getLicense();
        this.formatLicense(license);
        AssetLicenseState assetLicenseState = asset.getLicenseState();
        if (AssetLicenseState.EVALUATION.equals((Object)assetLicenseState)) {
            license.setName(ManagementObjectsFormatterImpl.getEvaluationLicenseName());
        } else if (AssetLicenseState.UNLICENSED.equals((Object)assetLicenseState)) {
            License license2 = new License();
            license2.setName(ManagementUtil.getLocalizedString("asset.unlicensed.license.name"));
            asset.setLicense(license2);
        }
    }

    private void formatAssetProductName(Asset asset) {
        AssetLicenseState assetLicenseState = asset.getLicenseState();
        String string = null;
        if (AssetLicenseState.LICENSED.equals((Object)assetLicenseState)) {
            ProductRestriction productRestriction = AssetUtil.getAssetProductRestriction(asset);
            string = productRestriction.getProduct().getFormattedName();
        } else {
            string = AssetLicenseState.EVALUATION.equals((Object)assetLicenseState) ? ManagementUtil.getLocalizedString("product.evaluation.name") : ManagementUtil.getLocalizedString("asset.unlicensed.product.name");
        }
        asset.setFormattedProductName(string);
    }

    private void formatAssetCostUnits(Asset asset) {
        CostUnit[] costUnitArray = null;
        costUnitArray = AssetLicenseState.UNLICENSED.equals((Object)asset.getLicenseState()) ? new CostUnit[]{} : (PayGoLicensingUtil.isPayGoLicense(asset.getLicense()) ? this.filterPayGoCostUnits(asset.getCostUnitUsage()) : this.getAssetLicenseCostUnitsUsage(asset));
        CostUnitUtil.formatCostUnits(costUnitArray);
        asset.setCostUnitUsage(costUnitArray);
    }

    private static String getEvaluationLicenseName() {
        return ManagementUtil.getLocalizedString("license.evaluation.name");
    }

    private CostUnit[] filterPayGoCostUnits(CostUnit[] costUnitArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitArray)) {
            return costUnitArray;
        }
        ArrayList<CostUnit> arrayList = new ArrayList<CostUnit>();
        for (CostUnit costUnit : costUnitArray) {
            String string = costUnit.getId();
            if (!string.contains("vm.") && !string.contains("address.")) continue;
            arrayList.add(costUnit);
        }
        return arrayList.toArray(new CostUnit[arrayList.size()]);
    }

    private CostUnit[] getAssetLicenseCostUnitsUsage(Asset asset) {
        ArrayList<CostUnit> arrayList = new ArrayList<CostUnit>();
        ProductRestriction productRestriction = AssetUtil.getAssetProductRestriction(asset);
        Set<String> set = CostUnitUtil.getCostUnitIds(productRestriction.getProduct().getCostUnits());
        for (CostUnit costUnit : asset.getCostUnitUsage()) {
            if (!set.contains(costUnit.getId())) continue;
            arrayList.add(costUnit);
        }
        CostUnit[] costUnitArray = arrayList.toArray(new CostUnit[arrayList.size()]);
        return costUnitArray;
    }

    private static class ContractDetails {
        public String number;
        public Calendar startDate;
        public Calendar endDate;
        public String supportLevel;
        public String elaFlag;

        private ContractDetails() {
        }
    }

    private static class OrderDetails {
        public String number;
        public Calendar date;
        public long quantity;
        private String poNumber;

        private OrderDetails() {
        }
    }

    private static class LicenseKeyDetails {
        public String accountName;
        public String accountNumber;
        public String folderLocation;
        public String licenseKeyNotes;
        public KeyAnyValue[] customLabels;
        public OrderDetails[] ordersDetails;
        public ContractDetails[] contractsDetails;

        private LicenseKeyDetails() {
        }
    }

    private static class LicenseKeyDetailsDecoder {
        private static final String LICENSE_METADATA_PROP_NOTES = "licenseKeyNotes";
        private static final String LICENSE_METADATA_PROP_CUSTOM_LABELS = "customLabels";
        private static final String LICENSE_METADATA_PROP_ACCOUNT_NAME = "accountName";
        private static final String LICENSE_METADATA_PROP_ACCOUNT_NUMBER = "accountNumber";
        private static final String LICENSE_METADATA_RPOP_FOLDER_LOCATION = "folderLocation";
        private static final String LICENSE_METADATA_PROP_ORDER_DETAILS = "orderDetails";
        private static final String LICENSE_METADATA_PROP_ORDER_NUMBER = "number";
        private static final String LICENSE_METADATA_PROP_ORDER_QUANTITY = "orderQuantity";
        private static final String LICENSE_METADATA_PROP_ORDER_DATE = "orderDate";
        private static final String LICENSE_METADATA_PROP_ORDER_PO_NUMBER = "poNumber";
        private static final String LICENSE_METADATA_PROP_CONTRACT_DETAILS = "contractDetails";
        private static final String LICENSE_METADATA_PROP_CONTRACT_NUMBER = "number";
        private static final String LICENSE_METADATA_PROP_CONTRACT_COVARAGE_START_DATE = "licenseCoverageStartDate";
        private static final String LICENSE_METADATA_PROP_CONTRACT_COVARAGE_END_DATE = "licenseCoverageEndDate";
        private static final String LICENSE_METADATA_PROP_CONTRACT_SUPPORT_LEVEL = "supportLevel";
        private static final String LICENSE_METADATA_PROP_CONTRACT_ELA_FLAG = "ELAFlag";

        private LicenseKeyDetailsDecoder() {
        }

        private static LicenseKeyDetails decodeLicenseKeyDetails(byte[] byArray, String string) {
            Object[] objectArray = MyVMwareUtil.decodeLicenseMetadata((byte[])byArray, (String)string);
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                return null;
            }
            LicenseKeyDetails licenseKeyDetails = new LicenseKeyDetails();
            ArrayList<OrderDetails> arrayList = new ArrayList<OrderDetails>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (Object object : objectArray) {
                Object object2;
                KeyAnyValue[] keyAnyValueArray;
                String string2 = object.getKey();
                if (LICENSE_METADATA_PROP_ACCOUNT_NAME.equals(string2)) {
                    licenseKeyDetails.accountName = (String)object.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ACCOUNT_NUMBER.equals(string2)) {
                    licenseKeyDetails.accountNumber = (String)object.getValue();
                    continue;
                }
                if (LICENSE_METADATA_RPOP_FOLDER_LOCATION.equals(string2)) {
                    licenseKeyDetails.folderLocation = (String)object.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_NOTES.equals(string2)) {
                    licenseKeyDetails.licenseKeyNotes = (String)object.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CUSTOM_LABELS.equals(string2)) {
                    licenseKeyDetails.customLabels = (KeyAnyValue[])object.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_DETAILS.equals(string2)) {
                    keyAnyValueArray = (KeyAnyValue[])object.getValue();
                    object2 = LicenseKeyDetailsDecoder.buildUiOrderDetails(keyAnyValueArray);
                    arrayList.add((OrderDetails)object2);
                    continue;
                }
                if (!LICENSE_METADATA_PROP_CONTRACT_DETAILS.equals(string2)) continue;
                keyAnyValueArray = (KeyAnyValue[])object.getValue();
                object2 = LicenseKeyDetailsDecoder.buildUiContractDetails(keyAnyValueArray);
                arrayList2.add(object2);
            }
            licenseKeyDetails.ordersDetails = arrayList.toArray(new OrderDetails[arrayList.size()]);
            licenseKeyDetails.contractsDetails = arrayList2.toArray(new ContractDetails[arrayList2.size()]);
            return licenseKeyDetails;
        }

        private static OrderDetails buildUiOrderDetails(KeyAnyValue[] keyAnyValueArray) {
            OrderDetails orderDetails = new OrderDetails();
            for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
                String string = keyAnyValue.getKey();
                if ("number".equals(string)) {
                    orderDetails.number = (String)keyAnyValue.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_QUANTITY.equals(string)) {
                    orderDetails.quantity = (Long)keyAnyValue.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_ORDER_DATE.equals(string)) {
                    orderDetails.date = (Calendar)keyAnyValue.getValue();
                    continue;
                }
                if (!LICENSE_METADATA_PROP_ORDER_PO_NUMBER.equals(string)) continue;
                orderDetails.poNumber = (String)keyAnyValue.getValue();
            }
            return orderDetails;
        }

        private static ContractDetails buildUiContractDetails(KeyAnyValue[] keyAnyValueArray) {
            ContractDetails contractDetails = new ContractDetails();
            for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
                String string = keyAnyValue.getKey();
                if ("number".equals(string)) {
                    contractDetails.number = (String)keyAnyValue.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_COVARAGE_START_DATE.equals(string)) {
                    contractDetails.startDate = (Calendar)keyAnyValue.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_COVARAGE_END_DATE.equals(string)) {
                    contractDetails.endDate = (Calendar)keyAnyValue.getValue();
                    continue;
                }
                if (LICENSE_METADATA_PROP_CONTRACT_SUPPORT_LEVEL.equals(string)) {
                    contractDetails.supportLevel = (String)keyAnyValue.getValue();
                    continue;
                }
                if (!LICENSE_METADATA_PROP_CONTRACT_ELA_FLAG.equals(string)) continue;
                contractDetails.elaFlag = (String)keyAnyValue.getValue();
            }
            return contractDetails;
        }
    }
}

