/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssignLicenseUnsupportedFeatures;
import com.vmware.license.client.cis.management.ds.AssignLicenseUnsupportedLicenseFeatures;
import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AssignLicenseUnsupportedFeaturesUtil {
    private static final String FEATURE_ID_DELIM = ":";
    private static final String[] FEATURES_WITH_LIMIT_TOKENS = new String[]{"serialuri", "ft"};

    public static AssignLicenseUnsupportedFeatures createAssignLicenseUnsupportedFeatures(Asset[] assetArray, License[] licenseArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray) || ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return null;
        }
        HashMap<URI, AssignLicenseUnsupportedLicenseFeatures> hashMap = new HashMap<URI, AssignLicenseUnsupportedLicenseFeatures>();
        for (License license : licenseArray) {
            AssignLicenseUnsupportedLicenseFeatures assignLicenseUnsupportedLicenseFeatures = AssignLicenseUnsupportedFeaturesUtil.getUnsupportedLicenseFeatures(assetArray, license);
            hashMap.put(license.getUri(), assignLicenseUnsupportedLicenseFeatures);
        }
        AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures = new AssignLicenseUnsupportedFeatures();
        assignLicenseUnsupportedFeatures.setLicenseRefToUnsupportedFeatures(hashMap);
        return assignLicenseUnsupportedFeatures;
    }

    private static AssignLicenseUnsupportedLicenseFeatures getUnsupportedLicenseFeatures(Asset[] assetArray, License license) {
        HashMap<URI, Feature[]> hashMap = new HashMap<URI, Feature[]>();
        HashMap<URI, Feature[]> hashMap2 = new HashMap<URI, Feature[]>();
        for (Asset asset : assetArray) {
            Feature[] featureArray;
            Feature[] featureArray2;
            License license2 = license.getIsEvaluation() ? asset.getEvaluationLicense() : license;
            Feature[] featureArray3 = AssignLicenseUnsupportedFeaturesUtil.getAssetAvailableFeaturesFromLicense(asset, license2);
            Feature[] featureArray4 = AssignLicenseUnsupportedFeaturesUtil.getMissingSourceFeatures(asset.getFeaturesInUse(), featureArray3);
            if (!ArrayUtil.isNullOrEmpty((Object[])featureArray4)) {
                hashMap.put(asset.getUri(), featureArray4);
            }
            if (ArrayUtil.isNullOrEmpty((Object[])(featureArray2 = AssignLicenseUnsupportedFeaturesUtil.getMissingSourceFeatures(featureArray = AssignLicenseUnsupportedFeaturesUtil.getAssetAvailableFeatures(asset), featureArray3)))) continue;
            hashMap2.put(asset.getUri(), featureArray2);
        }
        return AssignLicenseUnsupportedFeaturesUtil.buildAssignLicenseUnsupportedLicenseFeatures(hashMap, hashMap2);
    }

    private static Feature[] getAssetAvailableFeatures(Asset asset) {
        return AssignLicenseUnsupportedFeaturesUtil.getAssetAvailableFeaturesFromLicense(asset, asset.getLicense());
    }

    private static Feature[] getAssetAvailableFeaturesFromLicense(Asset asset, License license) {
        ProductCapability productCapability = AssetUtil.getAssetProductCapabilityFromLicense(asset, license);
        if (productCapability == null) {
            return new Feature[0];
        }
        return productCapability.getFeatures();
    }

    private static Feature[] getMissingSourceFeatures(Feature[] featureArray, Feature[] featureArray2) {
        if (ArrayUtil.isNullOrEmpty((Object[])featureArray)) {
            return new Feature[0];
        }
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        Set<String> set = AssignLicenseUnsupportedFeaturesUtil.getFeatureTokens(featureArray2);
        for (Feature feature : featureArray) {
            if (!AssignLicenseUnsupportedFeaturesUtil.isFeatureMissing(set, feature.getId())) continue;
            arrayList.add(feature);
        }
        return arrayList.toArray(new Feature[arrayList.size()]);
    }

    private static Set<String> getFeatureTokens(Feature[] featureArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])featureArray)) {
            return hashSet;
        }
        for (Feature feature : featureArray) {
            String string = AssignLicenseUnsupportedFeaturesUtil.getFeatureToken(feature.getId());
            hashSet.add(string);
        }
        return hashSet;
    }

    private static String getFeatureToken(String string) {
        int n = string.indexOf(FEATURE_ID_DELIM);
        String string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    private static boolean isFeatureMissing(Set<String> set, String string) {
        if (AssignLicenseUnsupportedFeaturesUtil.isFeatureRestriction(string)) {
            return false;
        }
        String string2 = AssignLicenseUnsupportedFeaturesUtil.getFeatureToken(string);
        return !set.contains(string2);
    }

    private static boolean isFeatureRestriction(String string) {
        if (string.indexOf(FEATURE_ID_DELIM) == -1) {
            return false;
        }
        String string2 = AssignLicenseUnsupportedFeaturesUtil.getFeatureToken(string);
        return !AssignLicenseUnsupportedFeaturesUtil.isFeatureWithLimit(string2);
    }

    private static boolean isFeatureWithLimit(String string) {
        for (String string2 : FEATURES_WITH_LIMIT_TOKENS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static AssignLicenseUnsupportedLicenseFeatures buildAssignLicenseUnsupportedLicenseFeatures(Map<URI, Feature[]> map, Map<URI, Feature[]> map2) {
        AssignLicenseUnsupportedLicenseFeatures assignLicenseUnsupportedLicenseFeatures = new AssignLicenseUnsupportedLicenseFeatures();
        assignLicenseUnsupportedLicenseFeatures.setAssetRefToUnsupportedFeaturesInUse(map);
        assignLicenseUnsupportedLicenseFeatures.setAssetRefToUnsupportedAvailableFeatures(map2);
        return assignLicenseUnsupportedLicenseFeatures;
    }
}

