/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedCostUnitUsage;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedLicenseUsages;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedProductUsages;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedUsages;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductFamily;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssignLicenseUsageCalculationUtil {
    public static AssignLicenseAggregatedUsages createAssignLicenseAggregatedUsages(Asset[] assetArray, License[] licenseArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray) || ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return null;
        }
        HashMap<URI, AssignLicenseAggregatedLicenseUsages> hashMap = new HashMap<URI, AssignLicenseAggregatedLicenseUsages>();
        AssetsAggregation assetsAggregation = AssignLicenseUsageCalculationUtil.getAssetsAggregation(assetArray);
        Map<URI, Map<String, AggregatedUsage>> map = AssignLicenseUsageCalculationUtil.createLicenseRefToCostUnitKeyToAggregatedUsage(assetArray);
        Map<String, AggregatedUsage> map2 = AssignLicenseUsageCalculationUtil.createCostUnitKeyToAggregatedUsage(map);
        for (License license : licenseArray) {
            Map<String, AggregatedUsage> map3 = map.get(license.getUri());
            AssignLicenseAggregatedLicenseUsages assignLicenseAggregatedLicenseUsages = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedLicenseUsages(license, map3, map2, assetsAggregation);
            hashMap.put(license.getUri(), assignLicenseAggregatedLicenseUsages);
        }
        AssignLicenseAggregatedUsages assignLicenseAggregatedUsages = new AssignLicenseAggregatedUsages();
        assignLicenseAggregatedUsages.setLicenseRefToLicenseUsages(hashMap);
        return assignLicenseAggregatedUsages;
    }

    private static Map<URI, Map<String, AggregatedUsage>> createLicenseRefToCostUnitKeyToAggregatedUsage(Asset[] assetArray) {
        HashMap<URI, Map<String, AggregatedUsage>> hashMap = new HashMap<URI, Map<String, AggregatedUsage>>();
        for (Asset asset : assetArray) {
            if (AssetLicenseState.UNLICENSED.equals((Object)asset.getLicenseState())) continue;
            URI uRI = AssetLicenseState.EVALUATION.equals((Object)asset.getLicenseState()) ? LicenseUtil.EVALUATION_LICENSE_URI : asset.getLicense().getUri();
            HashMap hashMap2 = (HashMap)hashMap.get(uRI);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(uRI, hashMap2);
            }
            AggregatedUsageUtil.addAssetCostUnitUsages(asset, hashMap2);
        }
        return hashMap;
    }

    private static Map<String, AggregatedUsage> createCostUnitKeyToAggregatedUsage(Map<URI, Map<String, AggregatedUsage>> map) {
        HashMap<String, AggregatedUsage> hashMap = new HashMap<String, AggregatedUsage>();
        for (Map<String, AggregatedUsage> map2 : map.values()) {
            AggregatedUsageUtil.addAggregatedUsages(hashMap, map2);
        }
        return hashMap;
    }

    private static AssetsAggregation getAssetsAggregation(Asset[] assetArray) {
        HashMap<String, List<Asset>> hashMap = new HashMap<String, List<Asset>>();
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        for (Asset asset : assetArray) {
            String string = AssignLicenseUsageCalculationUtil.getProductFamilyKey(asset.getProductFamily());
            List<Asset> list = hashMap.get(string);
            if (list == null) {
                list = new ArrayList<Asset>();
                hashMap.put(string, list);
            }
            list.add(asset);
            for (CostUnit costUnit : asset.getCostUnitUsage()) {
                String string2 = AggregatedUsageUtil.getCostUnitKey(asset.getProductFamily(), costUnit);
                Double d = hashMap2.get(string2);
                if (d == null || d < costUnit.getUsage()) {
                    d = costUnit.getUsage();
                }
                hashMap2.put(string2, d);
            }
        }
        AssetsAggregation assetsAggregation = new AssetsAggregation(hashMap, hashMap2);
        return assetsAggregation;
    }

    private static String getProductFamilyKey(ProductFamily productFamily) {
        return productFamily.getName();
    }

    private static AssignLicenseAggregatedLicenseUsages createAssignLicenseAggregatedLicenseUsages(License license, Map<String, AggregatedUsage> map, Map<String, AggregatedUsage> map2, AssetsAggregation assetsAggregation) {
        AssignLicenseAggregatedLicenseUsages assignLicenseAggregatedLicenseUsages = new AssignLicenseAggregatedLicenseUsages();
        HashMap<URI, AssignLicenseAggregatedProductUsages> hashMap = new HashMap<URI, AssignLicenseAggregatedProductUsages>();
        ProductRestriction[] productRestrictionArray = license.getProductRestrictions();
        if (ArrayUtil.isNullOrEmpty((Object[])productRestrictionArray)) {
            return assignLicenseAggregatedLicenseUsages;
        }
        for (ProductRestriction productRestriction : productRestrictionArray) {
            Product product = productRestriction.getProduct();
            AssignLicenseAggregatedProductUsages assignLicenseAggregatedProductUsages = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedProductUsages(product, map, map2, assetsAggregation);
            hashMap.put(product.getUri(), assignLicenseAggregatedProductUsages);
        }
        assignLicenseAggregatedLicenseUsages.setProductRefToProductUsages(hashMap);
        return assignLicenseAggregatedLicenseUsages;
    }

    private static AssignLicenseAggregatedProductUsages createAssignLicenseAggregatedProductUsages(Product product, Map<String, AggregatedUsage> map, Map<String, AggregatedUsage> map2, AssetsAggregation assetsAggregation) {
        AssignLicenseAggregatedProductUsages assignLicenseAggregatedProductUsages = new AssignLicenseAggregatedProductUsages();
        HashMap<String, AssignLicenseAggregatedCostUnitUsage> hashMap = new HashMap<String, AssignLicenseAggregatedCostUnitUsage>();
        for (CostUnit costUnit : product.getCostUnits()) {
            String string;
            List<Asset> list;
            AggregatedUsage aggregatedUsage = AggregatedUsageUtil.getAggregatedUsage(map, product.getFamily(), costUnit);
            AggregatedUsage aggregatedUsage2 = AggregatedUsageUtil.getAggregatedUsage(map2, product.getFamily(), costUnit);
            ProductFamily productFamily = product.getFamily();
            String string2 = AggregatedUsageUtil.getCostUnitKey(productFamily, costUnit);
            Double d = assetsAggregation.costUnitKeyToMaxAssetUsage.get(string2);
            if (d == null) {
                d = 0.0;
            }
            int n = (list = assetsAggregation.productFamilyKeyToAssets.get(string = AssignLicenseUsageCalculationUtil.getProductFamilyKey(productFamily))) == null ? 0 : list.size();
            boolean bl = aggregatedUsage2.usagesCount == n;
            double d2 = Math.round(costUnit.getUsage() - aggregatedUsage.usage);
            double d3 = Math.round(d2 + aggregatedUsage2.usage);
            AssignLicenseAggregatedCostUnitUsage assignLicenseAggregatedCostUnitUsage = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedCostUnitUsage(costUnit, bl, d3, d2, d);
            hashMap.put(costUnit.getId(), assignLicenseAggregatedCostUnitUsage);
        }
        assignLicenseAggregatedProductUsages.setCostUnitIdToCostUnitUsage(hashMap);
        return assignLicenseAggregatedProductUsages;
    }

    private static AssignLicenseAggregatedCostUnitUsage createAssignLicenseAggregatedCostUnitUsage(CostUnit costUnit, boolean bl, Double d, Double d2, Double d3) {
        AssignLicenseAggregatedCostUnitUsage assignLicenseAggregatedCostUnitUsage = new AssignLicenseAggregatedCostUnitUsage();
        assignLicenseAggregatedCostUnitUsage.setCostUnit(costUnit);
        assignLicenseAggregatedCostUnitUsage.setAggregationComplete(bl);
        assignLicenseAggregatedCostUnitUsage.setUsageWithAggregatedAssetUsage(d);
        assignLicenseAggregatedCostUnitUsage.setUsageWithoutAggregatedAssetUsage(d2);
        assignLicenseAggregatedCostUnitUsage.setMaxAssetUsage(d3);
        return assignLicenseAggregatedCostUnitUsage;
    }

    private static class AssetsAggregation {
        Map<String, List<Asset>> productFamilyKeyToAssets;
        Map<String, Double> costUnitKeyToMaxAssetUsage;

        public AssetsAggregation(Map<String, List<Asset>> map, Map<String, Double> map2) {
            this.productFamilyKeyToAssets = map;
            this.costUnitKeyToMaxAssetUsage = map2;
        }
    }

    private static class AggregatedUsage {
        Double usage = 0.0;
        int usagesCount = 0;

        private AggregatedUsage() {
        }
    }

    private static class AggregatedUsageUtil {
        private static final String COST_UNIT_KEY_DELIM = "~";

        private AggregatedUsageUtil() {
        }

        private static void addAssetCostUnitUsages(Asset asset, Map<String, AggregatedUsage> map) {
            ProductFamily productFamily = asset.getProductFamily();
            for (CostUnit costUnit : asset.getCostUnitUsage()) {
                AggregatedUsage aggregatedUsage;
                if (costUnit.getUsage() == null) continue;
                String string = AggregatedUsageUtil.getCostUnitKey(productFamily, costUnit);
                AggregatedUsage aggregatedUsage2 = aggregatedUsage = AggregatedUsageUtil.getAndInitAggregatedUsage(map, string);
                Double.valueOf(aggregatedUsage2.usage + costUnit.getUsage());
                aggregatedUsage2.usage = aggregatedUsage2.usage;
                ++aggregatedUsage.usagesCount;
            }
        }

        private static String getCostUnitKey(ProductFamily productFamily, CostUnit costUnit) {
            String string = AssignLicenseUsageCalculationUtil.getProductFamilyKey(productFamily);
            return string + COST_UNIT_KEY_DELIM + costUnit.getId();
        }

        private static void addAggregatedUsages(Map<String, AggregatedUsage> map, Map<String, AggregatedUsage> map2) {
            for (Map.Entry<String, AggregatedUsage> entry : map2.entrySet()) {
                AggregatedUsage aggregatedUsage = AggregatedUsageUtil.getAndInitAggregatedUsage(map, entry.getKey());
                AggregatedUsage aggregatedUsage2 = entry.getValue();
                AggregatedUsage aggregatedUsage3 = aggregatedUsage;
                Double.valueOf(aggregatedUsage3.usage + aggregatedUsage2.usage);
                aggregatedUsage3.usage = aggregatedUsage3.usage;
                aggregatedUsage.usagesCount += aggregatedUsage2.usagesCount;
            }
        }

        private static AggregatedUsage getAndInitAggregatedUsage(Map<String, AggregatedUsage> map, String string) {
            AggregatedUsage aggregatedUsage = map.get(string);
            if (aggregatedUsage == null) {
                aggregatedUsage = new AggregatedUsage();
                map.put(string, aggregatedUsage);
            }
            return aggregatedUsage;
        }

        private static AggregatedUsage getAggregatedUsage(Map<String, AggregatedUsage> map, ProductFamily productFamily, CostUnit costUnit) {
            if (map == null) {
                return new AggregatedUsage();
            }
            String string = AggregatedUsageUtil.getCostUnitKey(productFamily, costUnit);
            AggregatedUsage aggregatedUsage = map.get(string);
            return aggregatedUsage == null ? new AggregatedUsage() : aggregatedUsage;
        }
    }
}

