/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CostUnitUtil {
    public static final Number NO_LIMIT_VALUE = 0;
    public static final String COST_UNIT_CPU_PACKAGE = "cpuPackage";
    private static final String COST_UNIT_LOOKUP_PREFIX = "costUnit.";
    private static final String CORE_LIMIT_DELIMITER = ":";
    private static final String CPU_PACKAGE_CORE_LIMIT_PREFIX = "cpuPackage:";
    private static final String CPU_PACKAGE_CORE_LIMIT_SUFFIX = "core";
    private static final String COST_UNIT_LOOKUP_LABEL_SUFFIX = ".valueLabel";
    private static final String COST_UNIT_LONG_LOOKUP_LABEL_SUFFIX = ".longValueLabel";

    public static void formatCostUnits(CostUnit[] costUnitArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitArray)) {
            return;
        }
        for (CostUnit costUnit : costUnitArray) {
            CostUnitUtil.formatCostUnit(costUnit);
        }
    }

    public static void formatCostUnit(CostUnit costUnit) {
        if (costUnit == null || costUnit.getId() == null) {
            return;
        }
        String string = CostUnitUtil.getShortFormattedCostUnitId(costUnit.getId());
        costUnit.setFormattedId(string);
        String string2 = "%s " + string;
        costUnit.setValueFormat(string2);
    }

    public static Set<String> getCostUnitIds(CostUnit[] costUnitArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitArray)) {
            return linkedHashSet;
        }
        for (CostUnit costUnit : costUnitArray) {
            linkedHashSet.add(costUnit.getId());
        }
        return linkedHashSet;
    }

    public static void addCostUnitUsages(CostUnit[] costUnitArray, CostUnit[] costUnitArray2) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitArray) || ArrayUtil.isNullOrEmpty((Object[])costUnitArray2)) {
            return;
        }
        for (CostUnit costUnit : costUnitArray) {
            if (costUnit.getUsage() == null) continue;
            for (CostUnit costUnit2 : costUnitArray2) {
                if (costUnit2.getUsage() == null || !costUnit2.getId().equals(costUnit.getId())) continue;
                Double d = costUnit2.getUsage() + costUnit.getUsage();
                costUnit2.setUsage(d);
            }
        }
    }

    public static String[] getShortFormattedCostUnitIds(CostUnit[] costUnitArray) {
        String[] stringArray = new String[costUnitArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = CostUnitUtil.getShortFormattedCostUnitId(costUnitArray[i].getId());
        }
        return stringArray;
    }

    public static String getShortFormattedCostUnitId(String string) {
        String string2 = CostUnitUtil.isCpuPackageCoreLimitCostUnit(string) != false ? COST_UNIT_CPU_PACKAGE : string;
        String string3 = ManagementUtil.getLocalizedString(COST_UNIT_LOOKUP_PREFIX + string2 + COST_UNIT_LOOKUP_LABEL_SUFFIX);
        return string3 == null ? string : string3;
    }

    public static String[] getLongFormattedCostUnitIds(CostUnit[] costUnitArray) {
        String[] stringArray = new String[costUnitArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = CostUnitUtil.getLongFormattedCostUnitId(costUnitArray[i].getId());
        }
        return stringArray;
    }

    public static String getLongFormattedCostUnitId(String string) {
        String string2;
        if (CostUnitUtil.isCpuPackageCoreLimitCostUnit(string).booleanValue()) {
            String string3 = CostUnitUtil.getCoreLimitValueFromCostUnitId(string);
            string2 = ManagementUtil.getLocalizedString("costUnit.cpuPackage.longValueLabel", string3);
        } else {
            string2 = ManagementUtil.getLocalizedString(COST_UNIT_LOOKUP_PREFIX + string + COST_UNIT_LOOKUP_LABEL_SUFFIX);
        }
        return string2 == null ? string : string2;
    }

    private static Boolean isCpuPackageCoreLimitCostUnit(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        return string.startsWith(CPU_PACKAGE_CORE_LIMIT_PREFIX) && string.endsWith(CPU_PACKAGE_CORE_LIMIT_SUFFIX);
    }

    private static String getCoreLimitValueFromCostUnitId(String string) {
        return StringUtils.substringBetween((String)string, (String)CORE_LIMIT_DELIMITER, (String)CPU_PACKAGE_CORE_LIMIT_SUFFIX);
    }
}

