/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.management.ds.PayGoLicenseInfo;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.ProductFamily;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.ds.SuiteLicenseType;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.FeatureUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.MyVMwareSyncUtil;
import com.vmware.license.client.cis.management.util.PayGoLicensingUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.DateUtil;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseProductCapability;
import com.vmware.vim.binding.cis.license.LicenseProductRestriction;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.ProductUsage;
import com.vmware.vim.binding.cis.license.SerialKeyLicenseInfo;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LicenseUtil {
    public static final URI EVALUATION_LICENSE_URI = DefaultUriSchemeUtil.createUri((String)"License", (String)"EVALUATION_LICENSE_ID");
    public static final String SUPPORTED_DLF_VERSION_KEY = "FileVersion";
    public static final String EVALUATION_SERIAL_KEY = "00000-00000-00000-00000-00000";
    private static final String EMBEDDED_OEM_KEY = "eoem";
    private static final String SUBSCRIPTION_KEY = "subscription";
    private static final String EXPIRATION_HOURS_KEY = "expirationHours";
    private static final String EXPIRATION_DATE_KEY = "expirationDate";
    private static final String SYSTEM_TIME_KEY = "system_time";
    private static final String EXPIRATION_MINUTES_KEY = "expirationMinutes";
    private static final String SUITE_LICENSE_KEY = "suiteLicense";
    private static final String SUITE_LICENSE_VALUE_PRIMARY_EXTENDED = "primaryExtended";
    private static final String SUITE_LICENSE_VALUE_PRIMARY = "primary";
    private static final String SUITE_LICENSE_VALUE_SECONDARY = "secondary";
    private static final Long ONE_MINUTE_IN_MS = 60000L;
    private static final String LICENSE_INFO_KEY = "LicenseInfo";
    private static final String PRODUCT_FAMILY_NAME_KEY = "ProductName";
    private static final String PRODUCT_FAMILY_VERSION_KEY = "ProductVersion";
    private static final String FEATURE_KEY = "feature";
    private static final String DEFAULT_FILE_VERSION = "1.0";

    public static com.vmware.license.client.cis.management.ds.License createLicense(LicenseUtilization licenseUtilization, LicenseScope licenseScope) {
        if (licenseUtilization == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.License license = LicenseUtil.createLicense(licenseUtilization.getLicense(), licenseUtilization.getUsage(), licenseUtilization.isIsLicenseAssigned(), false, licenseScope);
        return license;
    }

    public static com.vmware.license.client.cis.management.ds.License[] createLicenses(LicenseInfo[] licenseInfoArray, LicenseScope licenseScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseInfoArray) || licenseScope == null) {
            return new com.vmware.license.client.cis.management.ds.License[0];
        }
        com.vmware.license.client.cis.management.ds.License[] licenseArray = new com.vmware.license.client.cis.management.ds.License[licenseInfoArray.length];
        for (int i = 0; i < licenseInfoArray.length; ++i) {
            com.vmware.license.client.cis.management.ds.License license = new com.vmware.license.client.cis.management.ds.License();
            LicenseUtil.populateLicenseProperties(license, licenseInfoArray[i], null, licenseScope);
            licenseArray[i] = license;
        }
        return licenseArray;
    }

    public static com.vmware.license.client.cis.management.ds.License createLicense(LicenseManager.LicenseInfo licenseInfo) {
        if (licenseInfo == null || StringUtil.isNullOrEmpty((String)licenseInfo.licenseKey) || StringUtil.isNullOrEmpty((String)licenseInfo.name)) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.License license = new com.vmware.license.client.cis.management.ds.License();
        String string = licenseInfo.getName();
        ProductFamily productFamily = LicenseUtil.getProductFamily(licenseInfo);
        CostUnit[] costUnitArray = new CostUnit[]{CostUnitFactory.INSTANCE.createCostUnit(licenseInfo)};
        Product product = null;
        String string2 = licenseInfo.licenseKey;
        if (EVALUATION_SERIAL_KEY.equals(string2)) {
            license.setIsEvaluation(true);
            product = ProductUtil.createProduct(null, string, null, productFamily, costUnitArray);
        } else {
            license.setUri(UriUtil.buildExternalLicenseUri());
            license.setIsEvaluation(false);
            product = ProductUtil.createProduct(UriUtil.buildExternalProductUri(), string, null, productFamily, costUnitArray);
        }
        license.setSerialKeys(new String[]{string2});
        ProductRestriction productRestriction = LicenseUtil.createProductRestriction(licenseInfo, product);
        license.setProductRestrictions(new ProductRestriction[]{productRestriction});
        license.setAssigned(true);
        LicenseUtil.populateDerivedProperties(license);
        return license;
    }

    public static com.vmware.license.client.cis.management.ds.License[] createLicenses(License[] licenseArray, LicenseScope licenseScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return new com.vmware.license.client.cis.management.ds.License[0];
        }
        com.vmware.license.client.cis.management.ds.License[] licenseArray2 = new com.vmware.license.client.cis.management.ds.License[licenseArray.length];
        for (int i = 0; i < licenseArray.length; ++i) {
            licenseArray2[i] = LicenseUtil.createLicense(licenseArray[i], null, false, false, licenseScope);
        }
        return licenseArray2;
    }

    public static com.vmware.license.client.cis.management.ds.License createLicense(License license, boolean bl, LicenseScope licenseScope) {
        return LicenseUtil.createLicense(license, null, true, bl, licenseScope);
    }

    public static com.vmware.license.client.cis.management.ds.License createEvaluationInfo(License license, LicenseScope licenseScope) {
        return LicenseUtil.createLicense(license, null, true, true, licenseScope);
    }

    public static com.vmware.license.client.cis.management.ds.License createEvaluationInfo(LicenseManager.EvaluationInfo evaluationInfo) {
        if (evaluationInfo == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.License license = new com.vmware.license.client.cis.management.ds.License();
        license.setIsEvaluation(true);
        Long l = LicenseUtil.getLicenseExpirationTimeInMs(evaluationInfo.properties);
        LicenseUtil.populateLicenseExpirationTime(license, l);
        return license;
    }

    public static com.vmware.license.client.cis.management.ds.License createEvaluationLicense(Long l) {
        com.vmware.license.client.cis.management.ds.License license = new com.vmware.license.client.cis.management.ds.License();
        license.setUri(EVALUATION_LICENSE_URI);
        license.setIsEvaluation(true);
        license.setSerialKeys(new String[]{EVALUATION_SERIAL_KEY});
        LicenseUtil.populateLicenseExpirationTime(license, l);
        return license;
    }

    public static URI[] getLicenseUris(License[] licenseArray, LicenseScope licenseScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return new URI[0];
        }
        URI[] uRIArray = new URI[licenseArray.length];
        for (int i = 0; i < licenseArray.length; ++i) {
            uRIArray[i] = UriUtil.buildLicenseUri(licenseArray[i].getId(), licenseScope);
        }
        return uRIArray;
    }

    public static boolean isExpiredLicense(com.vmware.license.client.cis.management.ds.License license) {
        if (license == null) {
            return false;
        }
        Long l = license.getExpirationTime();
        if (l == null) {
            return false;
        }
        return l <= 0L;
    }

    public static boolean hasSerialKey(String string, com.vmware.license.client.cis.management.ds.License license) {
        Object[] objectArray = license.getSerialKeys();
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return false;
        }
        return ArrayUtil.contains((Object)string, (Object[])objectArray);
    }

    public static com.vmware.license.client.cis.management.ds.License[] getSerialKeyLicenses(com.vmware.license.client.cis.management.ds.License[] licenseArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return new com.vmware.license.client.cis.management.ds.License[0];
        }
        ArrayList<com.vmware.license.client.cis.management.ds.License> arrayList = new ArrayList<com.vmware.license.client.cis.management.ds.License>();
        for (com.vmware.license.client.cis.management.ds.License license : licenseArray) {
            if (ArrayUtil.isNullOrEmpty((Object[])license.getSerialKeys())) continue;
            arrayList.add(license);
        }
        return arrayList.toArray(new com.vmware.license.client.cis.management.ds.License[arrayList.size()]);
    }

    public static com.vmware.license.client.cis.management.ds.License getLicenseBySerialKey(String string, com.vmware.license.client.cis.management.ds.License[] licenseArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return null;
        }
        for (com.vmware.license.client.cis.management.ds.License license : licenseArray) {
            if (!LicenseUtil.hasSerialKey(string, license)) continue;
            return license;
        }
        return null;
    }

    public static String getLicenseFormattedExpirationDate(Date date, Long l) {
        if (l == null) {
            return ManagementUtil.getLocalizedString("license.permanent");
        }
        if (l <= 0L) {
            return ManagementUtil.getLocalizedString("license.expired");
        }
        return ManagementUtil.getFormattedDate(date);
    }

    public static boolean isEmbeddedOemLicense(com.vmware.license.client.cis.management.ds.License license) {
        if (license == null) {
            return false;
        }
        return !StringUtil.isNullOrEmpty((String)license.getEmbeddedOem());
    }

    public static boolean isAssignmentFromNonEoemAllowed(com.vmware.license.client.cis.management.ds.License license) {
        if (!LicenseUtil.isEmbeddedOemLicense(license)) {
            return true;
        }
        return license.getEmbeddedOem().endsWith(":3");
    }

    public static String[] getNewLicensesNames(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("The new licenses being created or the existing licenses in the inventory are less than 0. New licenses: " + n + ". Existing licenses: " + n2);
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = Long.toString(n2 + i + 1);
            stringArray[i] = ManagementUtil.getLocalizedString("previewLicense.licenseNameFormat", string);
        }
        return stringArray;
    }

    private static com.vmware.license.client.cis.management.ds.License createLicense(License license, ProductUsage[] productUsageArray, boolean bl, boolean bl2, LicenseScope licenseScope) {
        if (license == null || LicenseUtil.isLicenseCorrupted(license)) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.License license2 = new com.vmware.license.client.cis.management.ds.License();
        license2.setIsEvaluation(bl2);
        if (!bl2) {
            license2.setUri(UriUtil.buildLicenseUri(license.getId(), licenseScope));
        }
        license2.setAssigned(bl);
        LicenseUtil.populateLicenseProperties(license2, license.getInfo(), productUsageArray, licenseScope);
        return license2;
    }

    private static boolean isLicenseCorrupted(License license) {
        Object[] objectArray = license.getInfo().getRestrictions();
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return false;
        }
        for (Object object : objectArray) {
            if (!ProductUtil.isProductCorrupted(object.getProduct())) continue;
            return true;
        }
        return false;
    }

    private static void populateLicenseProperties(com.vmware.license.client.cis.management.ds.License license, LicenseInfo licenseInfo, ProductUsage[] productUsageArray, LicenseScope licenseScope) {
        license.setName(licenseInfo.getName());
        if (licenseInfo instanceof SerialKeyLicenseInfo) {
            license.setSerialKeys(((SerialKeyLicenseInfo)licenseInfo).getSerialKeys());
        }
        PayGoLicenseInfo payGoLicenseInfo = PayGoLicensingUtil.buildPayGoLicenseInfo(licenseInfo);
        license.setPayGoInfo(payGoLicenseInfo);
        MyVMwareLicenseInfo myVMwareLicenseInfo = MyVMwareSyncUtil.buildUiMyVMwareLicenseInfo(licenseInfo);
        license.setMyVMwareInfo(myVMwareLicenseInfo);
        LicenseUtil.populateLicenseProperties(license, licenseInfo.getRestrictions(), productUsageArray, licenseScope);
        LicenseUtil.populateDerivedProperties(license);
    }

    private static void populateLicenseProperties(com.vmware.license.client.cis.management.ds.License license, LicenseProductRestriction[] licenseProductRestrictionArray, ProductUsage[] productUsageArray, LicenseScope licenseScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseProductRestrictionArray)) {
            return;
        }
        ArrayList<ProductRestriction> arrayList = new ArrayList<ProductRestriction>();
        HashMap<String, CostUnitUsage[]> hashMap = LicenseUtil.createProductIdToCostUnitsUsageMap(productUsageArray);
        for (LicenseProductRestriction licenseProductRestriction : licenseProductRestrictionArray) {
            String string = licenseProductRestriction.getProduct().getId();
            Product product = LicenseUtil.createProduct((CostUnitUsage[])hashMap.get(string), licenseProductRestriction, license.getIsEvaluation() ? null : licenseScope);
            ProductRestriction productRestriction = LicenseUtil.createProductRestriction(licenseProductRestriction, product);
            arrayList.add(productRestriction);
        }
        license.setProductRestrictions(arrayList.toArray(new ProductRestriction[arrayList.size()]));
    }

    private static HashMap<String, CostUnitUsage[]> createProductIdToCostUnitsUsageMap(ProductUsage[] productUsageArray) {
        HashMap<String, CostUnitUsage[]> hashMap = new HashMap<String, CostUnitUsage[]>();
        if (productUsageArray != null) {
            for (ProductUsage productUsage : productUsageArray) {
                hashMap.put(productUsage.getProductId(), productUsage.getCostUnitsUsage());
            }
        }
        return hashMap;
    }

    private static Product createProduct(CostUnitUsage[] costUnitUsageArray, LicenseProductRestriction licenseProductRestriction, LicenseScope licenseScope) {
        com.vmware.vim.binding.cis.license.Product product = licenseProductRestriction.getProduct();
        CostUnitLimit[] costUnitLimitArray = licenseProductRestriction.getCostUnitsLimit();
        Product product2 = ProductUtil.createProduct(product, costUnitUsageArray, costUnitLimitArray, licenseScope);
        return product2;
    }

    private static ProductRestriction createProductRestriction(LicenseProductRestriction licenseProductRestriction, Product product) {
        ProductRestriction productRestriction = new ProductRestriction();
        productRestriction.setProduct(product);
        LicenseUtil.populateProductRestrictionProperties(productRestriction, licenseProductRestriction.getCapability());
        LicenseUtil.populateDerivedProperties(productRestriction);
        return productRestriction;
    }

    private static void populateProductRestrictionProperties(ProductRestriction productRestriction, LicenseProductCapability[] licenseProductCapabilityArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseProductCapabilityArray)) {
            return;
        }
        HashMap<String, ProductCapability> hashMap = new HashMap<String, ProductCapability>();
        for (LicenseProductCapability licenseProductCapability : licenseProductCapabilityArray) {
            ProductCapability productCapability = LicenseUtil.createProductCapability(licenseProductCapability);
            hashMap.put(productCapability.getVersion(), productCapability);
        }
        productRestriction.setVersionToProductCapability(hashMap);
    }

    private static ProductCapability createProductCapability(LicenseProductCapability licenseProductCapability) {
        Feature[] featureArray = FeatureUtil.createFeatures(licenseProductCapability.getFeatures());
        return LicenseUtil.createProductCapability(licenseProductCapability.getVersion(), featureArray, licenseProductCapability.getProperties());
    }

    private static ProductCapability createProductCapability(String string, Feature[] featureArray, KeyAnyValue[] keyAnyValueArray) {
        ProductCapability productCapability = new ProductCapability();
        productCapability.setVersion(string);
        productCapability.setFeatures(featureArray);
        productCapability.setProperties(keyAnyValueArray);
        return productCapability;
    }

    private static void populateDerivedProperties(ProductRestriction productRestriction) {
        ProductCapability productCapability = LicenseUtil.getLatestProductCapability(productRestriction);
        productRestriction.setLatestProductCapability(productCapability);
        KeyAnyValue[] keyAnyValueArray = productCapability.getProperties();
        String string = (String)ManagementUtil.getKeyAnyValuePropertyValue(SUITE_LICENSE_KEY, keyAnyValueArray);
        SuiteLicenseType suiteLicenseType = LicenseUtil.getSuiteLicenseType(string);
        productRestriction.setSuiteLicenseType(suiteLicenseType);
    }

    private static ProductCapability getLatestProductCapability(ProductRestriction productRestriction) {
        String string = "";
        ProductCapability productCapability = null;
        Map<String, ProductCapability> map = productRestriction.getVersionToProductCapability();
        for (Map.Entry<String, ProductCapability> entry : map.entrySet()) {
            if (entry.getKey().compareTo(string) <= 0) continue;
            string = entry.getKey();
            productCapability = entry.getValue();
        }
        return productCapability;
    }

    private static SuiteLicenseType getSuiteLicenseType(String string) {
        SuiteLicenseType suiteLicenseType = null;
        suiteLicenseType = SUITE_LICENSE_VALUE_PRIMARY_EXTENDED.equals(string) ? SuiteLicenseType.PRIMARY_EXENDED : (SUITE_LICENSE_VALUE_PRIMARY.equals(string) ? SuiteLicenseType.PRIMARY : (SUITE_LICENSE_VALUE_SECONDARY.equals(string) ? SuiteLicenseType.SECONDARY : SuiteLicenseType.NONE));
        return suiteLicenseType;
    }

    private static void populateDerivedProperties(com.vmware.license.client.cis.management.ds.License license) {
        if (license == null) {
            return;
        }
        String string = (String)LicenseUtil.getLicensePropertyValue(license, EMBEDDED_OEM_KEY);
        license.setEmbeddedOem(string);
        boolean bl = LicenseUtil.isSubscriptionLicense(license);
        license.setSubscription(bl);
        Long l = LicenseUtil.getLicenseExpirationTimeInMs(license);
        LicenseUtil.populateLicenseExpirationTime(license, l);
    }

    private static boolean isLicensePropertyPresent(com.vmware.license.client.cis.management.ds.License license, String string) {
        Object t = LicenseUtil.getLicensePropertyValue(license, string);
        return t != null;
    }

    private static <T> T getLicensePropertyValue(com.vmware.license.client.cis.management.ds.License license, String string) {
        ProductRestriction[] productRestrictionArray = license.getProductRestrictions();
        if (ArrayUtil.isNullOrEmpty((Object[])productRestrictionArray)) {
            return null;
        }
        T t = null;
        for (ProductRestriction productRestriction : productRestrictionArray) {
            KeyAnyValue[] keyAnyValueArray;
            Object t2;
            ProductCapability productCapability = productRestriction.getLatestProductCapability();
            if (productCapability == null || (t2 = ManagementUtil.getKeyAnyValuePropertyValue(string, keyAnyValueArray = productCapability.getProperties())) == null) continue;
            t = t2;
            break;
        }
        return t;
    }

    private static boolean isSubscriptionLicense(com.vmware.license.client.cis.management.ds.License license) {
        return LicenseUtil.isLicensePropertyPresent(license, SUBSCRIPTION_KEY);
    }

    private static Long getLicenseExpirationTimeInMs(com.vmware.license.client.cis.management.ds.License license) {
        ProductRestriction[] productRestrictionArray = license.getProductRestrictions();
        if (ArrayUtil.isNullOrEmpty((Object[])productRestrictionArray)) {
            return null;
        }
        ProductCapability productCapability = productRestrictionArray[0].getLatestProductCapability();
        if (productCapability == null) {
            return null;
        }
        return LicenseUtil.getLicenseExpirationTimeInMs(productCapability.getProperties());
    }

    private static Long getLicenseExpirationTimeInMs(KeyAnyValue[] keyAnyValueArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])keyAnyValueArray)) {
            return null;
        }
        Calendar calendar = null;
        Calendar calendar2 = null;
        Number number = null;
        Number number2 = null;
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            if (EXPIRATION_DATE_KEY.equals(keyAnyValue.getKey())) {
                calendar = DateUtil.getCalendar(keyAnyValue.getValue());
                continue;
            }
            if (SYSTEM_TIME_KEY.equals(keyAnyValue.getKey())) {
                calendar2 = DateUtil.getCalendar(keyAnyValue.getValue());
                continue;
            }
            if (EXPIRATION_HOURS_KEY.equals(keyAnyValue.getKey())) {
                number = (Number)keyAnyValue.getValue();
                continue;
            }
            if (!EXPIRATION_MINUTES_KEY.equals(keyAnyValue.getKey())) continue;
            number2 = (Number)keyAnyValue.getValue();
        }
        if (number == null && number2 == null) {
            return DateUtil.getRemainingTimeInMillis(calendar2, calendar);
        }
        Object object = DateUtil.getTimeInMillis(number, number2);
        if (object != null && (Long)object > 0L) {
            object = (Long)object + ONE_MINUTE_IN_MS;
        }
        return object;
    }

    private static void populateLicenseExpirationTime(com.vmware.license.client.cis.management.ds.License license, Long l) {
        license.setExpirationTime(l);
        Date date = LicenseUtil.getLicenseExpirationDate(l);
        license.setExpirationDate(date);
    }

    private static Date getLicenseExpirationDate(Long l) {
        if (l == null || l <= 0L) {
            return null;
        }
        Date date = new Date();
        Date date2 = new Date(date.getTime() + l);
        return date2;
    }

    private static ProductFamily getProductFamily(LicenseManager.LicenseInfo licenseInfo) {
        KeyAnyValue[] keyAnyValueArray;
        if (licenseInfo == null) {
            return null;
        }
        ProductFamily productFamily = new ProductFamily();
        for (KeyAnyValue keyAnyValue : keyAnyValueArray = licenseInfo.getProperties()) {
            String string;
            if (PRODUCT_FAMILY_NAME_KEY.equals(keyAnyValue.getKey())) {
                string = (String)keyAnyValue.getValue();
                productFamily.setName(string);
                continue;
            }
            if (!PRODUCT_FAMILY_VERSION_KEY.equals(keyAnyValue.getKey())) continue;
            string = (String)keyAnyValue.getValue();
            productFamily.setVersion(string);
        }
        return productFamily;
    }

    private static ProductRestriction createProductRestriction(LicenseManager.LicenseInfo licenseInfo, Product product) {
        if (licenseInfo == null) {
            return null;
        }
        ProductRestriction productRestriction = new ProductRestriction();
        productRestriction.setProduct(product);
        LicenseUtil.populateProductRestrictionProperties(productRestriction, licenseInfo);
        LicenseUtil.populateDerivedProperties(productRestriction);
        return productRestriction;
    }

    private static void populateProductRestrictionProperties(ProductRestriction productRestriction, LicenseManager.LicenseInfo licenseInfo) {
        HashMap<String, ProductCapability> hashMap = new HashMap<String, ProductCapability>();
        KeyAnyValue[] keyAnyValueArray = licenseInfo.getProperties();
        LicenseUtil.populateProductRestrictionVersionToProductCapability(hashMap, keyAnyValueArray);
        productRestriction.setVersionToProductCapability(hashMap);
    }

    private static void populateProductRestrictionVersionToProductCapability(Map<String, ProductCapability> map, KeyAnyValue[] keyAnyValueArray) {
        String string = DEFAULT_FILE_VERSION;
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        ArrayList<KeyAnyValue> arrayList2 = new ArrayList<KeyAnyValue>();
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            String string2;
            if (FEATURE_KEY.equals(keyAnyValue.getKey())) {
                string2 = ((KeyValue)keyAnyValue.getValue()).getKey();
                Feature feature = FeatureUtil.createFeature(string2);
                arrayList.add(feature);
                continue;
            }
            if (LICENSE_INFO_KEY.equals(keyAnyValue.getKey())) {
                string2 = (LicenseManager.LicenseInfo)keyAnyValue.getValue();
                LicenseUtil.populateProductRestrictionVersionToProductCapability(map, ((LicenseManager.LicenseInfo)string2).properties);
                continue;
            }
            arrayList2.add(keyAnyValue);
            if (!SUPPORTED_DLF_VERSION_KEY.equals(keyAnyValue.getKey())) continue;
            string = (String)keyAnyValue.getValue();
        }
        ProductCapability productCapability = LicenseUtil.createProductCapability(string, arrayList.toArray(new Feature[arrayList.size()]), arrayList2.toArray(new KeyAnyValue[arrayList2.size()]));
        map.put(string, productCapability);
    }
}

