/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.management.ds.MyVMwareSerialKeyInfo;
import com.vmware.license.client.cis.util.DateUtil;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.MyVMwareLicenseDetails;
import com.vmware.vim.binding.impl.cis.license.MyVMwareLicenseDetailsImpl;
import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;

public class MyVMwareSyncUtil {
    public static final String LICENSE_METADATA_KEY = "myVMwareLicenseDetails";

    public static MyVMwareLicenseInfo buildUiMyVMwareLicenseInfo(LicenseInfo licenseInfo) {
        if (licenseInfo == null) {
            return null;
        }
        Object[] objectArray = licenseInfo.getRestrictions();
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        Object[] objectArray2 = objectArray[0].getCapability();
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray2)) {
            return null;
        }
        KeyAnyValue[] keyAnyValueArray = objectArray2[0].getProperties();
        MyVMwareLicenseInfo myVMwareLicenseInfo = MyVMwareSyncUtil.buildUiMyVMwareLicenseInfo(keyAnyValueArray);
        return myVMwareLicenseInfo;
    }

    public static MyVMwareLicenseInfo buildUiMyVMwareLicenseInfo(KeyAnyValue[] keyAnyValueArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])keyAnyValueArray)) {
            return null;
        }
        ArrayList<MyVMwareSerialKeyInfo> arrayList = new ArrayList<MyVMwareSerialKeyInfo>();
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            if (!LICENSE_METADATA_KEY.equals(keyAnyValue.getKey())) continue;
            MyVMwareLicenseDetails myVMwareLicenseDetails = (MyVMwareLicenseDetails)keyAnyValue.getValue();
            MyVMwareSerialKeyInfo myVMwareSerialKeyInfo = MyVMwareSyncUtil.buildUiMyVMwareSerialKeyInfo(myVMwareLicenseDetails);
            arrayList.add(myVMwareSerialKeyInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        MyVMwareLicenseInfo myVMwareLicenseInfo = new MyVMwareLicenseInfo();
        myVMwareLicenseInfo.setSerialKeysInfo(arrayList.toArray(new MyVMwareSerialKeyInfo[arrayList.size()]));
        return myVMwareLicenseInfo;
    }

    public static MyVMwareSerialKeyInfo buildUiMyVMwareSerialKeyInfo(MyVMwareLicenseDetails myVMwareLicenseDetails) {
        if (myVMwareLicenseDetails == null) {
            throw new IllegalArgumentException("Unable to build UI My VMware metadata from LS My VMware metadata.");
        }
        MyVMwareSerialKeyInfo myVMwareSerialKeyInfo = new MyVMwareSerialKeyInfo();
        myVMwareSerialKeyInfo.setVersion(myVMwareLicenseDetails.getVersion());
        myVMwareSerialKeyInfo.setData(myVMwareLicenseDetails.getData().asArray());
        myVMwareSerialKeyInfo.setLastUpdateTimestamp(DateUtil.getDate(myVMwareLicenseDetails.getLastUpdateTimestamp()));
        return myVMwareSerialKeyInfo;
    }

    public static MyVMwareLicenseDetails buildServiceMyVMwareLicenseDetails(MyVMwareSerialKeyInfo myVMwareSerialKeyInfo) {
        if (myVMwareSerialKeyInfo == null || myVMwareSerialKeyInfo.getVersion() == null || myVMwareSerialKeyInfo.getData() == null) {
            throw new IllegalArgumentException("Unable to build LS My VMware metadata from UI My VMware metadata.");
        }
        MyVMwareLicenseDetailsImpl myVMwareLicenseDetailsImpl = new MyVMwareLicenseDetailsImpl();
        myVMwareLicenseDetailsImpl.setVersion(myVMwareSerialKeyInfo.getVersion());
        myVMwareLicenseDetailsImpl.setData((Binary)new BinaryImpl(myVMwareSerialKeyInfo.getData()));
        return myVMwareLicenseDetailsImpl;
    }
}

