/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.PayGoEntitlementAccount;
import com.vmware.license.client.cis.management.ds.PayGoService;
import com.vmware.license.client.cis.management.ds.results.AddPayGoLicensePreviewResult;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.PayGoLicenseInfo;
import com.vmware.vim.binding.cis.license.PayGoLicensePreviewInfo;

public class PayGoLicensingUtil {
    public static boolean isPayGoLicensingEnabled() {
        return false;
    }

    public static boolean isPayGoLicense(License license) {
        if (license == null || !PayGoLicensingUtil.isPayGoLicensingEnabled()) {
            return false;
        }
        return license.getPayGoInfo() != null;
    }

    public static AddPayGoLicensePreviewResult buildAddPayGoLicensePreviewResult(LicenseInfo licenseInfo) {
        if (!(licenseInfo instanceof PayGoLicensePreviewInfo)) {
            return null;
        }
        PayGoLicensePreviewInfo payGoLicensePreviewInfo = (PayGoLicensePreviewInfo)licenseInfo;
        PayGoEntitlementAccount payGoEntitlementAccount = new PayGoEntitlementAccount();
        payGoEntitlementAccount.setAccount(payGoLicensePreviewInfo.getEntitlementAccount());
        String[] stringArray = payGoLicensePreviewInfo.getServiceIds();
        PayGoService[] payGoServiceArray = new PayGoService[stringArray.length];
        for (int i = 0; i < payGoServiceArray.length; ++i) {
            PayGoService payGoService = new PayGoService();
            payGoService.setServiceId(stringArray[i]);
            payGoServiceArray[i] = payGoService;
        }
        AddPayGoLicensePreviewResult addPayGoLicensePreviewResult = new AddPayGoLicensePreviewResult();
        addPayGoLicensePreviewResult.entitlementAccount = payGoEntitlementAccount;
        addPayGoLicensePreviewResult.services = payGoServiceArray;
        return addPayGoLicensePreviewResult;
    }

    public static com.vmware.license.client.cis.management.ds.PayGoLicenseInfo buildPayGoLicenseInfo(LicenseInfo licenseInfo) {
        if (!PayGoLicensingUtil.isPayGoLicenseInfo(licenseInfo)) {
            return null;
        }
        PayGoLicenseInfo payGoLicenseInfo = (PayGoLicenseInfo)licenseInfo;
        PayGoEntitlementAccount payGoEntitlementAccount = new PayGoEntitlementAccount();
        payGoEntitlementAccount.setAccount(payGoLicenseInfo.getEntitlementAccount());
        PayGoService payGoService = new PayGoService();
        payGoService.setServiceId(payGoLicenseInfo.getServiceId());
        com.vmware.license.client.cis.management.ds.PayGoLicenseInfo payGoLicenseInfo2 = new com.vmware.license.client.cis.management.ds.PayGoLicenseInfo();
        payGoLicenseInfo2.setUserName(payGoLicenseInfo.getUsername());
        payGoLicenseInfo2.setEntitlementAccount(payGoEntitlementAccount);
        payGoLicenseInfo2.setService(payGoService);
        return payGoLicenseInfo2;
    }

    public static boolean isPayGoLicenseUtilization(LicenseUtilization licenseUtilization) {
        if (licenseUtilization == null) {
            return false;
        }
        return PayGoLicensingUtil.isPayGoLicenseInfo(licenseUtilization.getLicense().getInfo());
    }

    public static boolean isPayGoLicenseInfo(LicenseInfo licenseInfo) {
        return PayGoLicensingUtil.isPayGoLicensingEnabled() && licenseInfo instanceof PayGoLicenseInfo;
    }
}

