/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.adapter;

import com.vmware.license.client.cis.adapter.BaseLicensingObjectsDataProviderAdapterImpl;
import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class BaseReportDataProviderAdapterImpl<T>
extends BaseLicensingObjectsDataProviderAdapterImpl<T> {
    private static final String START_DATE_PROPERTY_NAME = "startDate";
    private static final String END_DATE_PROPERTY_NAME = "endDate";

    @Override
    protected T[] getObjectsByCompositeConstraint(CompositeConstraint compositeConstraint) {
        Constraint[] constraintArray;
        LicenseUiScope licenseUiScope = null;
        Date date = null;
        Date date2 = null;
        for (Constraint constraint : constraintArray = compositeConstraint.nestedConstraints) {
            if (!(constraint instanceof PropertyConstraint)) continue;
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            if ("scope".equals(propertyConstraint.propertyName)) {
                licenseUiScope = (LicenseUiScope)((Object)propertyConstraint.comparableValue);
                continue;
            }
            if (START_DATE_PROPERTY_NAME.equals(propertyConstraint.propertyName)) {
                date = (Date)propertyConstraint.comparableValue;
                continue;
            }
            if (!END_DATE_PROPERTY_NAME.equals(propertyConstraint.propertyName)) continue;
            date2 = (Date)propertyConstraint.comparableValue;
        }
        if (licenseUiScope == null || date == null || date2 == null) {
            return super.getObjectsByCompositeConstraint(compositeConstraint);
        }
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        LicenseReportScope licenseReportScope = new LicenseReportScope(licenseScope, date, date2);
        return this.getObjectsByReportScope(licenseReportScope);
    }

    @Override
    protected T[] getObjectsByUris(URI[] uRIArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            return super.getObjectsByUris(uRIArray);
        }
        Map<LicenseReportScope, List<URI>> map = LicenseScopeUtil.groupUiObjectsUrisByReportScope(uRIArray);
        if (map.size() == 1) {
            LicenseReportScope licenseReportScope = map.keySet().iterator().next();
            return this.getObjectsByUrisAndReportScope(uRIArray, licenseReportScope);
        }
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = null;
        for (Map.Entry<LicenseReportScope, List<URI>> entry : map.entrySet()) {
            URI[] uRIArray2 = entry.getValue().toArray(new URI[entry.getValue().size()]);
            LicenseReportScope licenseReportScope = entry.getKey();
            objectArray = this.getObjectsByUrisAndReportScope(uRIArray2, licenseReportScope);
            ArrayUtil.append(arrayList, (Object[])objectArray);
        }
        return arrayList.toArray(objectArray);
    }

    protected T[] getObjectsByReportScope(LicenseReportScope licenseReportScope) {
        return null;
    }

    protected T[] getObjectsByUrisAndReportScope(URI[] uRIArray, LicenseReportScope licenseReportScope) {
        return null;
    }
}

