/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    private static final long MS_IN_MINUTE = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final String UTC_TIME_ZONE_ID = "UTC";

    public static Calendar createUTCCalendar(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone(UTC_TIME_ZONE_ID), Locale.US);
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    public static Calendar getCalendar(Object object) {
        if (object == null) {
            return null;
        }
        if (Calendar.class.isInstance(object)) {
            return (Calendar)object;
        }
        if (Date.class.isInstance(object)) {
            return DateUtil.createUTCCalendar((Date)object);
        }
        throw new IllegalArgumentException("The object parameter is of type not supported by this method");
    }

    public static Date getDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.getTime();
    }

    public static Long getTimeInMillis(Number number, Number number2) {
        if (number == null && number2 == null) {
            return null;
        }
        long l = number != null ? number.longValue() : 0L;
        long l2 = number2 != null ? number2.longValue() : 0L;
        return l * 3600000L + l2 * 60000L;
    }

    public static Long getRemainingTimeInMillis(Calendar calendar, Calendar calendar2) {
        if (calendar2 == null) {
            return null;
        }
        return calendar == null ? calendar2.getTimeInMillis() - new Date().getTime() : calendar2.getTimeInMillis() - calendar.getTimeInMillis();
    }
}

