/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.management.ds.Assignment;
import com.vmware.license.client.management.editor.EntityType;
import com.vmware.license.client.management.editor.LicenseEditor;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class LicenseEntityDataProviderAdapter
implements DataProviderAdapter {
    private static final String LICENSE_ENTITY_PROPERTY = "licenseEntity";
    private static final int ALL_RESULTS = -1;
    private LicenseEditor _licenseEditor;
    private DataService _dataService;

    public LicenseEntityDataProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, DataService dataService, LicenseEditor licenseEditor) {
        this._dataService = dataService;
        this._licenseEditor = licenseEditor;
        dataServiceExtensionRegistry.registerDataAdapter((DataProviderAdapter)this, ManagementUtil.LICENSABLE_MANAGED_OBJECT_TYPES);
    }

    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        Response response = new Response();
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = this.processQuery(querySpecArray[i]);
        }
        response.resultSet = resultSetArray;
        return response;
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        if (querySpec.resourceSpec == null || !RelationalConstraint.class.isInstance(querySpec.resourceSpec.constraint)) {
            return null;
        }
        RelationalConstraint relationalConstraint = (RelationalConstraint)querySpec.resourceSpec.constraint;
        if (!ObjectIdentityConstraint.class.isInstance(relationalConstraint.constraintOnRelatedObject) || !LICENSE_ENTITY_PROPERTY.equals(relationalConstraint.relation)) {
            return null;
        }
        ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)relationalConstraint.constraintOnRelatedObject;
        URI uRI = (URI)objectIdentityConstraint.target;
        String string = DefaultUriSchemeUtil.getType((URI)uRI);
        if (!"LicenseKey".equals(string) && !"LicenseProduct".equals(string)) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        int n = 0;
        try {
            String string2 = ManagementUtil.getLicenseUriValue(uRI);
            String string3 = ManagementUtil.getLicenseUriScope(uRI);
            Boolean bl = ManagementUtil.isFreshDataRequested(querySpec.resourceSpec.propertySpecs);
            Assignment[] assignmentArray = this._licenseEditor.getLicenseAssignments(null, string3, bl);
            Assignment[] assignmentArray2 = "LicenseKey".equals(string) ? LicenseEntityDataProviderAdapter.filterAssignmentsByLicenseKey(assignmentArray, string2) : LicenseEntityDataProviderAdapter.filterAssignmentsByLicenseProductKey(assignmentArray, string2);
            Object[] objectArray = this.buildTargetMoRefs(assignmentArray2, relationalConstraint.targetType);
            if (objectArray.length == 0) {
                return null;
            }
            n = objectArray.length;
            objectArray = this.pageResults(querySpec, (ManagedObjectReference[])objectArray);
            PropertyValue[] propertyValueArray = new PropertyValue[]{};
            String[] stringArray = this.getProperties(querySpec.resourceSpec.propertySpecs);
            if (stringArray.length > 0) {
                propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object[])objectArray, (String[])stringArray);
            }
            resultSet.items = this.buildResultItems((ManagedObjectReference[])objectArray, propertyValueArray);
        }
        catch (Exception exception) {
            resultSet.error = ManagementUtil.buildLicenseMethodFault(exception);
        }
        resultSet.queryName = querySpec.name;
        resultSet.totalMatchedObjectCount = n;
        return resultSet;
    }

    private ManagedObjectReference[] buildTargetMoRefs(Assignment[] assignmentArray, String string) {
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        for (Assignment assignment : assignmentArray) {
            if ("HostSystem".equals(string) && EntityType.HOST.equals((Object)assignment.getEntityType())) {
                arrayList.add(ManagementUtil.buildMoRef("HostSystem", assignment.getEntityId(), assignment.getScope()));
                continue;
            }
            if ("Folder".equals(string) && EntityType.VIRTUAL_CENTER.equals((Object)assignment.getEntityType())) {
                arrayList.add(ManagementUtil.buildVcMoRef(assignment.getEntityId()));
                continue;
            }
            if (!"ClusterComputeResource".equals(string) || !EntityType.CLUSTER.equals((Object)assignment.getEntityType())) continue;
            arrayList.add(ManagementUtil.buildMoRef("ClusterComputeResource", assignment.getEntityId(), assignment.getScope()));
        }
        return arrayList.toArray(new ManagedObjectReference[arrayList.size()]);
    }

    private String[] getProperties(PropertySpec[] propertySpecArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String string : propertySpec.propertyNames) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private HashMap<ManagedObjectReference, ArrayList<PropertyValue>> buildMoRefPropertyValueMap(PropertyValue[] propertyValueArray) {
        HashMap<ManagedObjectReference, ArrayList<PropertyValue>> hashMap = new HashMap<ManagedObjectReference, ArrayList<PropertyValue>>();
        for (PropertyValue propertyValue : propertyValueArray) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyValue.resourceObject;
            if (!hashMap.containsKey(managedObjectReference)) {
                hashMap.put(managedObjectReference, new ArrayList());
            }
            hashMap.get(managedObjectReference).add(propertyValue);
        }
        return hashMap;
    }

    private ResultItem[] buildResultItems(ManagedObjectReference[] managedObjectReferenceArray, PropertyValue[] propertyValueArray) {
        HashMap<ManagedObjectReference, ArrayList<PropertyValue>> hashMap = this.buildMoRefPropertyValueMap(propertyValueArray);
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (ManagedObjectReference managedObjectReference : managedObjectReferenceArray) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = managedObjectReference;
            List list = hashMap.get(managedObjectReference);
            if (list != null) {
                resultItem.properties = list.toArray(new PropertyValue[list.size()]);
            }
            arrayList.add(resultItem);
        }
        return arrayList.toArray(new ResultItem[arrayList.size()]);
    }

    private static Assignment[] filterAssignmentsByLicenseProductKey(Assignment[] assignmentArray, String string) {
        if (assignmentArray == null) {
            return new Assignment[0];
        }
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        for (Assignment assignment : assignmentArray) {
            if (!assignment.getLicenseKey().getProductKey().equals(string)) continue;
            arrayList.add(assignment);
        }
        return arrayList.toArray(new Assignment[arrayList.size()]);
    }

    private static Assignment[] filterAssignmentsByLicenseKey(Assignment[] assignmentArray, String string) {
        if (assignmentArray == null) {
            return new Assignment[0];
        }
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        for (Assignment assignment : assignmentArray) {
            if (!assignment.getLicenseKey().getLicenseKey().equals(string)) continue;
            arrayList.add(assignment);
        }
        return arrayList.toArray(new Assignment[arrayList.size()]);
    }

    private ManagedObjectReference[] pageResults(QuerySpec querySpec, ManagedObjectReference[] managedObjectReferenceArray) {
        int n;
        if (querySpec.resultSpec == null) {
            return managedObjectReferenceArray;
        }
        ResultSpec resultSpec = querySpec.resultSpec;
        if (this.requiresAllResults(resultSpec.maxResultCount)) {
            return managedObjectReferenceArray;
        }
        if (resultSpec.order != null) {
            return managedObjectReferenceArray;
        }
        int n2 = n = resultSpec.offset != null ? resultSpec.offset : 0;
        if (n < 0 || n > managedObjectReferenceArray.length) {
            return managedObjectReferenceArray;
        }
        int n3 = n + resultSpec.maxResultCount;
        if (n3 < 0 || n3 > managedObjectReferenceArray.length || n3 < n) {
            n3 = managedObjectReferenceArray.length;
        }
        return Arrays.copyOfRange(managedObjectReferenceArray, n, n3);
    }

    private boolean requiresAllResults(Integer n) {
        return n == null || n == -1;
    }
}

