/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.management.ds.Assignment;
import com.vmware.license.client.management.ds.LicenseKey;
import com.vmware.license.client.management.editor.AssignmentRetrievalException;
import com.vmware.license.client.management.editor.LicenseEditor;
import com.vmware.license.client.management.editor.LicenseRetrievalException;
import com.vmware.license.client.util.ApplicationCache;
import com.vmware.license.client.util.LicensePropertyUtil;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenseEntityPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static String LICENSE_IS_REGISTERED_PROPERTY = "isRegisteredForLicensing";
    private static String LICENSE_KEY_PROPERTY = "licenseKeyString";
    private static String LICENSE_PRODUCT_KEY_PROPERTY = "licenseProductKeyString";
    private static String LICENSE_PRODUCT_NAME_PROPERTY = "licenseProductNameString";
    private static String LICENSE_COST_UNIT_PROPERTY = "licenseCostUnitString";
    private static String LICENSE_USAGE_PROPERTY = "licenseUsage";
    private static String LICENSE_PROPERTIES_PROPERTY = "licenseProperties";
    private static String LICENCE_EVALUATION_PROPERTY = "licenseIsInEvaluation";
    private static String LICENSE_EXPIRATION_PROPERTY = "licenseExpirationTime";
    private static String LICENSE_FORMATTED_LICENSE_KEY_PROPERTY = "licenseFormattedKeyString";
    private static String LICENSE_FORMATTED_PRODUCT_NAME_PROPERTY = "licenseFormattedProductNameString";
    private static String LICENSE_FORMATTED_USAGE_PROPERTY = "licenseFormattedUsage";
    private static String LICENSE_FORMATTED_EXPIRATION_PROPERTY = "licenseFormattedExpirationDate";
    private static String IS_ASSIGNMENTS_APPLICATION_CACHE_REQUEST = "isAssignmentsApplicationCacheRequest";
    private static String QUERY_SCOPE = "licenseScope";
    private static String[] PROPERTIES = new String[]{LICENSE_IS_REGISTERED_PROPERTY, LICENSE_KEY_PROPERTY, LICENSE_PRODUCT_NAME_PROPERTY, LICENSE_COST_UNIT_PROPERTY, LICENSE_PRODUCT_KEY_PROPERTY, LICENSE_PROPERTIES_PROPERTY, LICENSE_USAGE_PROPERTY, LICENCE_EVALUATION_PROPERTY, LICENSE_FORMATTED_LICENSE_KEY_PROPERTY, LICENSE_FORMATTED_PRODUCT_NAME_PROPERTY, LICENSE_EXPIRATION_PROPERTY, LICENSE_FORMATTED_EXPIRATION_PROPERTY, LICENSE_FORMATTED_USAGE_PROPERTY, IS_ASSIGNMENTS_APPLICATION_CACHE_REQUEST, QUERY_SCOPE, "forceRefresh"};
    private final LicenseEditor _licenseEditor;
    private final ApplicationCache<Map<String, Assignment[]>> _assignmentsCache;

    public LicenseEntityPropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, LicenseEditor licenseEditor, ApplicationCache<Map<String, Assignment[]>> applicationCache) {
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._licenseEditor = licenseEditor;
        this._assignmentsCache = applicationCache;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        Object[] objectArray = propertyRequestSpec.objects;
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        ManagedObjectReference[] managedObjectReferenceArray = LicenseEntityPropertyProviderAdapter.filterLicensableObjects(objectArray);
        if (managedObjectReferenceArray.length == 0) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        try {
            List<ResultItem> list = null;
            if (LicenseEntityPropertyProviderAdapter.isAssignmentsApplicationCacheRequested(propertySpecArray)) {
                Map<LinkedVcGroup, List<ManagedObjectReference>> map = LicenseEntityPropertyProviderAdapter.getMoRefsByVcGroup(managedObjectReferenceArray);
                Map<String, Assignment[]> map2 = this.getApplicationCacheAssignmentsByScope(map, propertySpecArray);
                list = this.getResultItems(map, map2, propertySpecArray);
            } else {
                Boolean bl = ManagementUtil.isFreshDataRequested(propertySpecArray);
                String string = LicenseEntityPropertyProviderAdapter.getQueryScope(propertySpecArray);
                if (string != null) {
                    Assignment[] assignmentArray = this._licenseEditor.getLicenseAssignments(null, string, bl);
                    Map<String, Assignment> map = LicensePropertyUtil.groupAssignmentsByEntityIdentifier(assignmentArray);
                    list = LicenseEntityPropertyProviderAdapter.getResultItems(managedObjectReferenceArray, map, propertySpecArray);
                } else {
                    Map<LinkedVcGroup, List<ManagedObjectReference>> map = LicenseEntityPropertyProviderAdapter.getMoRefsByVcGroup(managedObjectReferenceArray);
                    Map<String, Assignment[]> map3 = this.getCurrentAssignmentsByScope(map, propertySpecArray, bl);
                    list = this.getResultItems(map, map3, propertySpecArray);
                }
            }
            resultSet.items = list.toArray(new ResultItem[list.size()]);
        }
        catch (LicenseRetrievalException licenseRetrievalException) {
            resultSet.error = ManagementUtil.buildLicenseMethodFault(licenseRetrievalException);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Assignment[]> getApplicationCacheAssignmentsByScope(Map<LinkedVcGroup, List<ManagedObjectReference>> map, PropertySpec[] propertySpecArray) throws LicenseRetrievalException {
        Map<String, Assignment[]> map2 = null;
        ApplicationCache<Map<String, Assignment[]>> applicationCache = this._assignmentsCache;
        synchronized (applicationCache) {
            map2 = this._assignmentsCache.getCache();
            if (map2 == null) {
                map2 = this.getCurrentAssignmentsByScope(map, propertySpecArray, null);
                this._assignmentsCache.setCache(map2);
            }
        }
        return map2;
    }

    private Map<String, Assignment[]> getCurrentAssignmentsByScope(Map<LinkedVcGroup, List<ManagedObjectReference>> map, PropertySpec[] propertySpecArray, Boolean bl) throws LicenseRetrievalException {
        HashMap<String, Assignment[]> hashMap = new HashMap<String, Assignment[]>();
        for (List<ManagedObjectReference> list : map.values()) {
            String string = null;
            if (list.size() == 1) {
                string = ManagementUtil.getEntityId(list.get(0));
            }
            String string2 = ManagementUtil.getEntityScope(list.get(0));
            Assignment[] assignmentArray = this._licenseEditor.getLicenseAssignments(string, string2, bl);
            hashMap.put(string2, assignmentArray);
        }
        return hashMap;
    }

    private List<ResultItem> getResultItems(Map<LinkedVcGroup, List<ManagedObjectReference>> map, Map<String, Assignment[]> map2, PropertySpec[] propertySpecArray) throws LicenseRetrievalException {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (List<ManagedObjectReference> list : map.values()) {
            String string = ManagementUtil.getEntityScope(list.get(0));
            Assignment[] assignmentArray = map2.get(string);
            Map<String, Assignment> map3 = LicensePropertyUtil.groupAssignmentsByEntityIdentifier(assignmentArray);
            List<ResultItem> list2 = LicenseEntityPropertyProviderAdapter.getResultItems(list.toArray(new ManagedObjectReference[list.size()]), map3, propertySpecArray);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo[] typeInfoArray = new TypeInfo[ManagementUtil.LICENSABLE_MANAGED_OBJECT_TYPES.length];
        for (int i = 0; i < typeInfoArray.length; ++i) {
            typeInfoArray[i] = new TypeInfo();
            typeInfoArray[i].type = ManagementUtil.LICENSABLE_MANAGED_OBJECT_TYPES[i];
            typeInfoArray[i].properties = PROPERTIES;
        }
        return typeInfoArray;
    }

    private static ResultItem buildResultItem(Assignment assignment, ManagedObjectReference managedObjectReference, PropertySpec[] resultItem) {
        LicenseKey licenseKey = assignment.getLicenseKey();
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        for (PropertySpec propertySpec : resultItem) {
            for (String string : propertySpec.propertyNames) {
                Object object;
                if (LICENSE_IS_REGISTERED_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_IS_REGISTERED_PROPERTY, LicensePropertyUtil.isEntityRegisteredForLicensing(assignment), managedObjectReference));
                }
                if (LICENSE_PRODUCT_NAME_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_PRODUCT_NAME_PROPERTY, licenseKey.getName(), managedObjectReference));
                }
                if (LICENSE_KEY_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_KEY_PROPERTY, licenseKey.getLicenseKey(), managedObjectReference));
                }
                if (LICENSE_COST_UNIT_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_COST_UNIT_PROPERTY, licenseKey.getCostUnit(), managedObjectReference));
                }
                if (LICENSE_PRODUCT_KEY_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_PRODUCT_KEY_PROPERTY, licenseKey.getProductKey(), managedObjectReference));
                }
                if (LICENSE_PROPERTIES_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_PROPERTIES_PROPERTY, licenseKey.getProperties(), managedObjectReference));
                }
                if (LICENSE_USAGE_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_USAGE_PROPERTY, ManagementUtil.createNumberDataObject(assignment.getEntityUsage()), managedObjectReference));
                }
                if (LICENCE_EVALUATION_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENCE_EVALUATION_PROPERTY, licenseKey.isEvaluation(), managedObjectReference));
                }
                if (LICENSE_FORMATTED_LICENSE_KEY_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_FORMATTED_LICENSE_KEY_PROPERTY, licenseKey.getFormattedLicenseKey(), managedObjectReference));
                }
                if (LICENSE_FORMATTED_PRODUCT_NAME_PROPERTY.equals(string)) {
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_FORMATTED_PRODUCT_NAME_PROPERTY, licenseKey.getFormattedProductName(), managedObjectReference));
                }
                if (LICENSE_EXPIRATION_PROPERTY.equals(string)) {
                    object = ManagementUtil.createNumberDataObject(LicensePropertyUtil.getExpirationTime(assignment));
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_EXPIRATION_PROPERTY, object, managedObjectReference));
                }
                if (LICENSE_FORMATTED_EXPIRATION_PROPERTY.equals(string)) {
                    object = LicensePropertyUtil.getExpirationTime(assignment);
                    arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_FORMATTED_EXPIRATION_PROPERTY, LicensePropertyUtil.getFormattedExpirationDate((Long)object), managedObjectReference));
                }
                if (!LICENSE_FORMATTED_USAGE_PROPERTY.equals(string)) continue;
                arrayList.add(LicenseEntityPropertyProviderAdapter.buildPropertyValue(LICENSE_FORMATTED_USAGE_PROPERTY, assignment.getFormattedEntityUsage(), managedObjectReference));
            }
        }
        ResultItem resultItem2 = new ResultItem();
        resultItem2.resourceObject = managedObjectReference;
        resultItem2.properties = arrayList.toArray(new PropertyValue[arrayList.size()]);
        return resultItem2;
    }

    private static PropertyValue buildPropertyValue(String string, Object object, ManagedObjectReference managedObjectReference) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = managedObjectReference;
        propertyValue.propertyName = string;
        propertyValue.value = object;
        return propertyValue;
    }

    private static ManagedObjectReference[] filterLicensableObjects(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return new ManagedObjectReference[0];
        }
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        for (Object object : objectArray) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            if (!ManagementUtil.isLicensableAsset(managedObjectReference)) continue;
            arrayList.add(managedObjectReference);
        }
        return arrayList.toArray(new ManagedObjectReference[arrayList.size()]);
    }

    private static boolean isAssignmentsApplicationCacheRequested(PropertySpec[] propertySpecArray) {
        Object object = ManagementUtil.getPropertyParameterValue(IS_ASSIGNMENTS_APPLICATION_CACHE_REQUEST, propertySpecArray);
        return object instanceof Boolean ? (Boolean)object : false;
    }

    private static String getQueryScope(PropertySpec[] propertySpecArray) {
        Object object = ManagementUtil.getPropertyParameterValue(QUERY_SCOPE, propertySpecArray);
        return object == null ? null : object.toString();
    }

    private static List<ResultItem> getResultItems(ManagedObjectReference[] managedObjectReferenceArray, Map<String, Assignment> map, PropertySpec[] propertySpecArray) throws AssignmentRetrievalException {
        if (managedObjectReferenceArray == null || map == null || propertySpecArray == null) {
            return new ArrayList<ResultItem>();
        }
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (ManagedObjectReference managedObjectReference : managedObjectReferenceArray) {
            Assignment assignment = LicensePropertyUtil.getAssignmentForEntity(map, managedObjectReference);
            if (assignment == null) continue;
            arrayList.add(LicenseEntityPropertyProviderAdapter.buildResultItem(assignment, managedObjectReference, propertySpecArray));
        }
        return arrayList;
    }

    private static Map<LinkedVcGroup, List<ManagedObjectReference>> getMoRefsByVcGroup(ManagedObjectReference[] managedObjectReferenceArray) {
        if (managedObjectReferenceArray == null) {
            return new HashMap<LinkedVcGroup, List<ManagedObjectReference>>();
        }
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        HashMap<LinkedVcGroup, List<ManagedObjectReference>> hashMap = new HashMap<LinkedVcGroup, List<ManagedObjectReference>>();
        for (ManagedObjectReference managedObjectReference : managedObjectReferenceArray) {
            LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(managedObjectReference.getServerGuid());
            if (!hashMap.containsKey(linkedVcGroup)) {
                hashMap.put(linkedVcGroup, new ArrayList());
            }
            ((List)hashMap.get(linkedVcGroup)).add(managedObjectReference);
        }
        return hashMap;
    }
}

