/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.management.adapter.BaseLicensePropertyProvider;
import com.vmware.license.client.management.adapter.LicenseCollectUriException;
import com.vmware.license.client.management.adapter.LicenseProviderInitializationException;
import com.vmware.license.client.management.ds.Assignment;
import com.vmware.license.client.management.ds.LicenseKey;
import com.vmware.license.client.management.ds.LicenseProduct;
import com.vmware.license.client.management.editor.EntityType;
import com.vmware.license.client.management.editor.LicenseEditor;
import com.vmware.license.client.management.editor.LicenseRetrievalException;
import com.vmware.license.client.util.LicensePropertyUtil;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.NumberDataObject;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.StringUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseProductPropertyProvider
extends BaseLicensePropertyProvider {
    private static final String LICENCE_PRODUCT_PROPERTY = "licenseProduct";
    private HashMap<String, LicenseProduct> _productByUriType = null;
    private LicenseKey[] _licenseKeys = null;
    protected LicenseEditor _licenseEditor;
    private Log _logger = LogFactory.getLog(LicenseProductPropertyProvider.class);

    public LicenseProductPropertyProvider(LicenseEditor licenseEditor) {
        this._licenseEditor = licenseEditor;
    }

    @type(value="LicenseProduct")
    public String getProductKey(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getProductKey();
    }

    @type(value="LicenseProduct")
    public String getName(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getFormattedProductName();
    }

    @type(value="LicenseProduct")
    public String getProductName(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getProductName();
    }

    @type(value="LicenseProduct")
    public String getCostUnit(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getCostUnit();
    }

    @type(value="LicenseProduct")
    public int getTotal(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getTotal();
    }

    @type(value="LicenseProduct")
    public Integer getUsed(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getUsed();
    }

    @type(value="LicenseProduct")
    public int getLicenseKeysCount(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getLicenseKeysCount();
    }

    @type(value="LicenseProduct")
    public boolean getIsUnlimitedCapacity(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.isUnlimitedCapacity();
    }

    @type(value="LicenseProduct")
    public boolean getAllLicenseKeysAssigned(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getAllKeysAssigned();
    }

    @type(value="LicenseProduct")
    public NumberDataObject getVsanPerHostSsdEntitlementInGb(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return ManagementUtil.createNumberDataObject(licenseProduct.getVsanPerHostSsdEntitlementInGb());
    }

    @type(value="LicenseProduct")
    public boolean getIsForVirtualCenter(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return EntityType.VIRTUAL_CENTER.equals((Object)licenseProduct.getEntityType()) || licenseProduct.isEvaluation();
    }

    @type(value="LicenseProduct")
    public boolean getIsForHost(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return EntityType.HOST.equals((Object)licenseProduct.getEntityType()) || licenseProduct.isEvaluation() || licenseProduct.isSuiteProduct();
    }

    @type(value="LicenseProduct")
    public boolean getIsForCluster(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return EntityType.CLUSTER.equals((Object)licenseProduct.getEntityType()) || licenseProduct.isEvaluation();
    }

    @type(value="LicenseProduct")
    public boolean getIsForSolution(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return EntityType.SOLUTION.equals((Object)licenseProduct.getEntityType()) || licenseProduct.isEvaluation() || licenseProduct.isSuiteProduct();
    }

    @type(value="LicenseProduct")
    public boolean getIsEvaluation(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.isEvaluation();
    }

    @type(value="LicenseProduct")
    public String getFormattedTotal(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getFormattedTotal();
    }

    @type(value="LicenseProduct")
    public String getFormattedUsed(URI uRI) {
        LicenseProduct licenseProduct = this.retrieveLicenseProduct(uRI);
        return licenseProduct.getFormattedUsed();
    }

    @Override
    protected void refreshData() throws LicenseProviderInitializationException {
        if (this._productByUriType != null) {
            this._productByUriType.clear();
            this._productByUriType = null;
        }
        try {
            this._licenseKeys = this._licenseEditor.getLicenseKeys(this._scope, this._forceRefresh);
        }
        catch (LicenseRetrievalException licenseRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error initializing LicenseProductPropertyProvider", (Throwable)licenseRetrievalException);
            }
            throw new LicenseProviderInitializationException(licenseRetrievalException);
        }
        this._productByUriType = LicenseProductPropertyProvider.buildLicenseProducts(this._licenseKeys);
    }

    @Override
    protected URI[] getAllUriObjects() {
        if (this._productByUriType == null || this._productByUriType.isEmpty()) {
            return new URI[0];
        }
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (String string : this._productByUriType.keySet()) {
            arrayList.add(LicenseProductPropertyProvider.buildLicenseProductUri(string, this._scope));
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected URI[] getRelatedUriObjects(Object object, String string) throws LicenseCollectUriException {
        if (object == null || StringUtil.isNullOrEmpty((String)string) || this._productByUriType == null || this._productByUriType.isEmpty()) {
            return new URI[0];
        }
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (URI.class.isInstance(object)) {
            URI uRI = (URI)object;
            String string2 = DefaultUriSchemeUtil.getType((URI)uRI);
            String string3 = ManagementUtil.getLicenseUriValue(uRI);
            String string4 = ManagementUtil.getLicenseUriScope(uRI);
            if (!"LicenseKey".equals(string2) || !LICENCE_PRODUCT_PROPERTY.equals(string)) return arrayList.toArray(new URI[arrayList.size()]);
            for (LicenseKey licenseKey : this._licenseKeys) {
                if (!licenseKey.getLicenseKey().equals(string3)) continue;
                arrayList.add(LicenseProductPropertyProvider.buildLicenseProductUri(licenseKey.getProductKey(), string4));
            }
            return arrayList.toArray(new URI[arrayList.size()]);
        } else {
            ManagedObjectReference managedObjectReference;
            if (!ManagedObjectReference.class.isInstance(object) || !"HostSystem".equals((managedObjectReference = (ManagedObjectReference)object).getType()) && !"LicenseSolution".equals(managedObjectReference.getType()) && !"Folder".equals(managedObjectReference.getType()) || !LICENCE_PRODUCT_PROPERTY.equals(string)) return arrayList.toArray(new URI[arrayList.size()]);
            try {
                Assignment[] assignmentArray = this._licenseEditor.getLicenseAssignments(managedObjectReference.getValue(), managedObjectReference.getServerGuid(), false);
                if (assignmentArray == null || assignmentArray.length <= 0 || assignmentArray[0] == null) return arrayList.toArray(new URI[arrayList.size()]);
                arrayList.add(LicenseProductPropertyProvider.buildLicenseProductUri(assignmentArray[0].getLicenseKey().getProductKey(), managedObjectReference.getServerGuid()));
                return arrayList.toArray(new URI[arrayList.size()]);
            }
            catch (LicenseRetrievalException licenseRetrievalException) {
                if (!this._logger.isErrorEnabled()) throw new LicenseCollectUriException(licenseRetrievalException);
                this._logger.error((Object)"Error collecting URIs for LicenseProductPropertyProvider", (Throwable)licenseRetrievalException);
                throw new LicenseCollectUriException(licenseRetrievalException);
            }
        }
    }

    @Override
    protected String getProvidedType() {
        return "LicenseProduct";
    }

    @Override
    protected void validateObjectsExistence(URI[] uRIArray) {
        Set<String> set;
        Set<String> set2 = set = this._productByUriType == null ? null : this._productByUriType.keySet();
        if (!ManagementUtil.doesSetContainLicenseUriValuesForUris(set, uRIArray)) {
            ManagementUtil.reportNotExistingObject();
        }
    }

    private LicenseProduct retrieveLicenseProduct(URI uRI) {
        LicenseProduct licenseProduct = this._productByUriType.get(ManagementUtil.getLicenseUriValue(uRI));
        assert (licenseProduct != null) : "license product not found for uri: " + uRI;
        return licenseProduct;
    }

    private static URI buildLicenseProductUri(String string, String string2) {
        return ManagementUtil.buildLicenseUri("LicenseProduct", string, string2);
    }

    private static HashMap<String, LicenseProduct> buildLicenseProducts(LicenseKey[] licenseKeyArray) {
        if (licenseKeyArray == null) {
            return new HashMap<String, LicenseProduct>();
        }
        HashMap hashMap = new HashMap();
        String string = "";
        for (LicenseKey dataObjectImpl : licenseKeyArray) {
            string = dataObjectImpl.getProductKey();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            ((ArrayList)hashMap.get(string)).add(dataObjectImpl);
        }
        HashMap hashMap2 = new HashMap();
        for (ArrayList arrayList : hashMap.values()) {
            LicenseProduct licenseProduct = LicenseProductPropertyProvider.createLicenseProduct(arrayList);
            hashMap2.put(licenseProduct.getProductKey(), licenseProduct);
        }
        return hashMap2;
    }

    private static LicenseProduct createLicenseProduct(ArrayList<LicenseKey> arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return new LicenseProduct();
        }
        LicenseProduct licenseProduct = new LicenseProduct();
        licenseProduct.setProductKey(arrayList.get(0).getProductKey());
        licenseProduct.setProductName(arrayList.get(0).getName());
        licenseProduct.setFomattedProductName(arrayList.get(0).getFormattedProductName());
        licenseProduct.setCostUnit(arrayList.get(0).getCostUnit());
        licenseProduct.setLicenseKeysCount(arrayList.size());
        licenseProduct.setEntityType(arrayList.get(0).getEntityType());
        licenseProduct.setEvaluation(arrayList.get(0).isEvaluation());
        licenseProduct.setSuiteProduct(arrayList.get(0).isSuiteLicense());
        int n = 0;
        Integer n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        for (LicenseKey licenseKey : arrayList) {
            if (licenseKey.isUnlimitedCapacity()) {
                bl = true;
                n = 0;
            } else if (!bl) {
                n += licenseKey.getTotal();
            }
            if (licenseKey.getUsed() != null) {
                n2 = n2 + licenseKey.getUsed();
            }
            if (licenseKey.isAssigned()) continue;
            bl2 = false;
        }
        licenseProduct.setTotal(n);
        licenseProduct.setUsed(n2);
        licenseProduct.setUnlimitedCapacity(bl);
        licenseProduct.setAllKeysAssigned(bl2);
        licenseProduct.setVsanPerHostSsdEntitlementInGb(arrayList.get(0).getVsanPerHostSsdEntitlementInGb());
        LicenseProductPropertyProvider.populateFormattedProperties(licenseProduct);
        return licenseProduct;
    }

    private static void populateFormattedProperties(LicenseProduct licenseProduct) {
        if (licenseProduct == null) {
            return;
        }
        String string = licenseProduct.getCostUnit();
        licenseProduct.setFormattedTotal(LicensePropertyUtil.getFormattedNumberPresentation(licenseProduct.getTotal(), string, true));
        licenseProduct.setFormattedUsed(LicensePropertyUtil.getFormattedNumberPresentation(licenseProduct.getUsed(), string, false));
    }
}

