/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final long MS_IN_SECOND = 1000L;
    public static final long MS_IN_MINUTE = 60000L;
    public static final long MS_IN_HOUR = 3600000L;
    private static final SimpleDateFormat ISO_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final String UTC_TIME_ZONE_ID = "UTC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDayStart(Date date, Calendar calendar) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.set(11, calendar.getActualMinimum(11));
            calendar.set(12, calendar.getActualMinimum(12));
            calendar.set(13, calendar.getActualMinimum(13));
            calendar.set(14, calendar.getActualMinimum(14));
            return new Date(calendar.getTimeInMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatISODate(Date date) {
        SimpleDateFormat simpleDateFormat = ISO_UTC_FORMAT;
        synchronized (simpleDateFormat) {
            return ISO_UTC_FORMAT.format(date);
        }
    }

    public static Calendar createUTCCalendar() {
        return new GregorianCalendar(TimeZone.getTimeZone(UTC_TIME_ZONE_ID), Locale.US);
    }

    public static Calendar createUTCCalendar(Date date) {
        Calendar calendar = DateUtil.createUTCCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public static List<Period> chunkPeriod(Date date, Date date2, long l) {
        Period period;
        ArrayList<Period> arrayList = new ArrayList<Period>();
        Date date3 = date;
        Date date4 = new Date(date3.getTime() + l);
        while (date4.before(date2)) {
            period = new Period();
            period.start = date3;
            period.end = date4;
            arrayList.add(period);
            date3 = new Date(date4.getTime() + 1L);
            date4 = new Date(date3.getTime() + l);
        }
        if (date3.before(date2)) {
            date4 = date2;
            period = new Period();
            period.start = date3;
            period.end = date4;
            arrayList.add(period);
        }
        return arrayList;
    }

    public static Long getMillisecondsRemaining(Calendar calendar) {
        return calendar == null ? null : Long.valueOf(calendar.getTimeInMillis() - new Date().getTime());
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone(UTC_TIME_ZONE_ID);
        ISO_UTC_FORMAT.setTimeZone(timeZone);
    }

    public static class Period {
        public Date start;
        public Date end;

        public String toString() {
            return "Start: " + this.start.toString() + ", End: " + this.end.toString();
        }
    }
}

