/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.util;

import com.vmware.vise.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class LicenseUtil {
    public static final String COST_UNIT_VRAM = "vram";
    public static final String COST_UNIT_VM = "vm";
    public static final String COST_UNIT_CPU_PACKAGE = "cpuPackage";
    public static final String COST_UNIT_CPU_CORE = "cpuCore";
    public static final String COST_UNIT_CPU_LOGIC = "cpuLogic";
    public static final String COST_UNIT_SERVER = "server";
    public static final String COST_UNIT_HOST = "host";
    private static final String[] COST_UNITS_ARRAY = new String[]{"vram", "vm", "cpuPackage", "cpuCore", "cpuLogic", "server", "host"};
    public static final Set<String> COST_UNITS = new HashSet<String>(Arrays.asList(COST_UNITS_ARRAY));
    public static final String CPU_PACKAGE_CORE_LIMIT_PREFIX = "cpuPackage:";
    public static final String CPU_PACKAGE_CORE_LIMIT_SUFFIX = "core";

    public static Boolean isValidCostUnit(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        return COST_UNITS.contains(string) || LicenseUtil.isCpuPackageCoreLimitCostUnit(string) != false;
    }

    public static boolean isCpuCostUnit(String string) {
        return LicenseUtil.isCpuPackageCoreLimitCostUnit(string) != false || COST_UNIT_CPU_PACKAGE.equals(string) || COST_UNIT_CPU_CORE.equals(string) || COST_UNIT_CPU_LOGIC.equals(string);
    }

    public static Boolean isCpuPackageCoreLimitCostUnit(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        return string.startsWith(CPU_PACKAGE_CORE_LIMIT_PREFIX) && string.endsWith(CPU_PACKAGE_CORE_LIMIT_SUFFIX);
    }

    public static String getCpuPackageCoreLimit(String string) {
        if (!LicenseUtil.isCpuPackageCoreLimitCostUnit(string).booleanValue()) {
            return "";
        }
        String string2 = string.replace(CPU_PACKAGE_CORE_LIMIT_PREFIX, "");
        return string2.replace(CPU_PACKAGE_CORE_LIMIT_SUFFIX, "");
    }

    public static boolean isSoftEnforced(String string, String string2) {
        if (string2.equals(COST_UNIT_VRAM) || string2.equals(COST_UNIT_VM)) {
            return !string.toLowerCase().contains("vcenter server");
        }
        return LicenseUtil.isVsanEdition(string);
    }

    private static boolean isVsanEdition(String string) {
        return string != null && string.toLowerCase().contains("vsan");
    }
}

