/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.SingleLogoutService;
import com.vmware.identity.websso.client.SingleSignOnService;
import com.vmware.identity.websso.client.SiteAffinity;
import com.vmware.identity.websso.client.WebssoClientException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDPConfiguration {
    private String alias;
    private String entityID;
    private X509Certificate signingCertificate;
    private List<String> nameIDFormats;
    private List<SingleSignOnService> singleSignOnServices;
    private List<SingleLogoutService> singleLogoutServices;
    private static final Logger logger = LoggerFactory.getLogger(IDPConfiguration.class);
    private boolean useSiteAffinityIfAvailable = true;
    private int clockTolerance;

    public IDPConfiguration(String alias, String entityID, X509Certificate signingCertificate, List<String> nameIDFormats, List<SingleSignOnService> singleSignOnServices, List<SingleLogoutService> singleLogoutServices, int clockTolerance, boolean useSiteAffinityIfAvailable) {
        Validate.notEmpty((String)entityID, (String)"entityID");
        Validate.notEmpty((String)alias, (String)"alias");
        Validate.notNull(singleSignOnServices);
        this.entityID = entityID;
        this.alias = alias;
        this.nameIDFormats = nameIDFormats;
        this.signingCertificate = signingCertificate;
        this.singleSignOnServices = singleSignOnServices;
        this.singleLogoutServices = singleLogoutServices;
        this.clockTolerance = clockTolerance;
        this.useSiteAffinityIfAvailable = useSiteAffinityIfAvailable;
    }

    public IDPConfiguration(String alias, String entityID, X509Certificate signingCertificate, List<String> nameIDFormats, List<SingleSignOnService> singleSignOnServices, List<SingleLogoutService> singleLogoutServices) {
        this(alias, entityID, signingCertificate, nameIDFormats, singleSignOnServices, singleLogoutServices, 600, true);
    }

    public void setAlias(String alias) {
        Validate.notEmpty((String)alias, (String)"alias");
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setEntityID(String entityID) {
        Validate.notEmpty((String)entityID, (String)"entityID");
        this.entityID = entityID;
    }

    public String getEntityID() {
        return this.entityID;
    }

    public void setSigningCertificate(X509Certificate signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    public X509Certificate getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setNameIDFormats(List<String> nameIDFormats) {
        this.nameIDFormats = nameIDFormats;
    }

    public List<String> getNameIDFormats() {
        return this.nameIDFormats;
    }

    public void setSingleSignOnServices(List<SingleSignOnService> singleSignOnServices) {
        Validate.notNull(singleSignOnServices, (String)"SingleSignOnService can not be set to null");
        this.singleSignOnServices = singleSignOnServices;
    }

    public List<SingleSignOnService> getSingleSignOnServices() {
        if (this.isUseSiteAffinityIfAvailable()) {
            ArrayList<SingleSignOnService> updatedSsos = new ArrayList<SingleSignOnService>();
            String siteFQDN = null;
            try {
                siteFQDN = SiteAffinity.getAffinitiedDC();
            }
            catch (WebssoClientException e) {
                logger.error("AFD siteaffinity failed!");
            }
            if (siteFQDN == null) {
                return this.singleSignOnServices;
            }
            for (SingleSignOnService service : this.singleSignOnServices) {
                String updatedURL;
                try {
                    updatedURL = this.updateHostNameInURL(service.getLocation(), siteFQDN);
                }
                catch (MalformedURLException e) {
                    logger.warn("The given entity ID is not in URL form. Not able to update single sign-on service location.", (Throwable)e);
                    updatedSsos.add(service);
                    continue;
                }
                updatedSsos.add(new SingleSignOnService(updatedURL, service.getBinding()));
            }
            return updatedSsos;
        }
        return this.singleSignOnServices;
    }

    public void setSingleLogoutServices(List<SingleLogoutService> singleLogoutServices) {
        this.singleLogoutServices = singleLogoutServices;
    }

    public List<SingleLogoutService> getSingleLogoutServices() {
        if (this.isUseSiteAffinityIfAvailable()) {
            ArrayList<SingleLogoutService> updatedSlos = new ArrayList<SingleLogoutService>();
            String siteFQDN = null;
            try {
                siteFQDN = SiteAffinity.getAffinitiedDC();
            }
            catch (WebssoClientException e) {
                logger.error("AFD siteaffinity failed!");
            }
            if (siteFQDN == null) {
                return this.singleLogoutServices;
            }
            for (SingleLogoutService service : this.singleLogoutServices) {
                String updatedURL;
                try {
                    updatedURL = this.updateHostNameInURL(service.getLocation(), siteFQDN);
                }
                catch (MalformedURLException e) {
                    logger.warn("The given entity ID is not in URL form. Not able to update single logout service location.", (Throwable)e);
                    updatedSlos.add(service);
                    continue;
                }
                updatedSlos.add(new SingleLogoutService(updatedURL, service.getBinding()));
            }
            return updatedSlos;
        }
        return this.singleLogoutServices;
    }

    public int getClockTolerance() {
        return this.clockTolerance;
    }

    public void setClockTolerance(int clockTolerance) {
        Validate.isTrue((clockTolerance >= 0 ? 1 : 0) != 0, (String)"Negative clock tolerance is not allowed!");
        this.clockTolerance = clockTolerance;
    }

    public boolean isSameEntity(String failoverEntityID) {
        boolean result;
        block5: {
            Validate.notEmpty((String)failoverEntityID, (String)"Empty failover entityID");
            result = failoverEntityID.equals(this.getEntityID());
            try {
                if (result || !this.isUseSiteAffinityIfAvailable()) break block5;
                URL failover_URL = new URL(failoverEntityID);
                String hostNameCandidate = failover_URL.getHost();
                List<String> domainControllers = null;
                try {
                    domainControllers = SiteAffinity.enumDCEntries();
                }
                catch (WebssoClientException e) {
                    logger.error("AFD siteaffinity is failing! WebSSO is not using siteaffinity for this request.");
                }
                if (domainControllers != null && domainControllers.contains(hostNameCandidate)) {
                    result = failoverEntityID.equals(this.updateHostNameInURL(this.getEntityID(), hostNameCandidate));
                }
            }
            catch (MalformedURLException e) {
                logger.error("The given entity ID is not in URL form. Compared to registered IDP node only. Failover entityID is " + failoverEntityID);
            }
        }
        return result;
    }

    private String updateHostNameInURL(String url, String siteFQDN) throws MalformedURLException {
        Validate.notEmpty((String)url, (String)"Null URL string.");
        URL oldUrl = new URL(url);
        URL newUrl = new URL(oldUrl.getProtocol(), siteFQDN, oldUrl.getPort(), oldUrl.getFile());
        return newUrl.toExternalForm();
    }

    public boolean isUseSiteAffinityIfAvailable() {
        return this.useSiteAffinityIfAvailable;
    }
}

