/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.cdc.CdcDCEntry;
import com.vmware.identity.cdc.CdcFactory;
import com.vmware.identity.cdc.CdcSession;
import com.vmware.identity.websso.client.WebssoClientException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteAffinity {
    static final Logger logger = LoggerFactory.getLogger(SiteAffinity.class);

    public static String getAffinitiedDC() throws WebssoClientException {
        String affinitizedDC = null;
        try (CdcSession cdcSession = null;){
            cdcSession = CdcFactory.createCdcSessionViaIPC();
            if (cdcSession == null) {
                logger.error("Failed to create AFD CdcSession via IPC. ");
                throw new WebssoClientException("AFD cdcSession is created null.");
            }
            CdcDCEntry entry = cdcSession.getAffinitizedDC(null, 0);
            if (entry == null) {
                logger.error("AFD cdcSession getAffinitizedDC() returns null CdcDCEntry.");
                throw new WebssoClientException("AFD cdcSession getAffinitizedDC() returns null CdcDCEntry.");
            }
            if (entry.dcName == null) {
                logger.error("AFD CdcDCEntry has null dcName attribute.");
                throw new WebssoClientException("AFD cdcSession getAffinitizedDC() returns null CdcDCEntry:dcName.");
            }
            affinitizedDC = entry.dcName;
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("Failed to init CdcSession, likely due to missing libcdcjni.so. Message: {}", (Object)e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            logger.warn("Failed to init CdcSession. likely due to missing vmafd jar. Message: {}", (Object)e.getMessage());
        }
        return affinitizedDC;
    }

    public static List<String> enumDCEntries() throws WebssoClientException {
        List dcList = null;
        try (CdcSession cdcSession = null;){
            cdcSession = CdcFactory.createCdcSessionViaIPC();
            if (cdcSession == null) {
                logger.error("Failed to create AFD CdcSession via IPC. ");
                throw new WebssoClientException("AFD cdcSession is created null.");
            }
            dcList = cdcSession.enumDCEntries();
            if (dcList == null) {
                logger.error("AFD cdcSession returns null DC list.");
                throw new WebssoClientException("AFD cdcSession returns null DC list.");
            }
        }
        catch (UnsatisfiedLinkError e) {
            logger.info("Failed to init CdcSession, likly due to missing libcdcjni.so.", (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            logger.info("Failed to init CdcSession, likly due to missing vmafd jar.", (Throwable)e);
        }
        return dcList;
    }
}

