/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.SamlUtils;
import com.vmware.identity.websso.client.SharedUtils;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.ValidationState;
import com.vmware.identity.websso.client.endpoint.SloListener;
import java.io.ByteArrayOutputStream;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SloResponseValidationState
extends ValidationState {
    private static final Logger logger = LoggerFactory.getLogger(SloResponseValidationState.class);
    private final SloListener controller;
    private LogoutResponse opensamlResponse;

    public SloResponseValidationState(HttpServletRequest request, SloListener controller) {
        super(controller.getMetadataSettings());
        this.setRequest(request);
        this.controller = controller;
    }

    @Override
    public void validate() throws Exception {
        logger.info("Validating Logout Response..");
        Validate.notNull((Object)this.getRequest());
        this.DecodeResponse();
        this.opensamlResponse = (LogoutResponse)SamlUtils.unmarshallSAMLObj(this.getSamlDom());
        Validate.notNull((Object)this.opensamlResponse, (String)"LogoutResponse object");
        Status status = this.opensamlResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        this.setMessageID(this.opensamlResponse.getID());
        this.setStatus(statusCode.getValue());
        StatusCode substatus = statusCode.getStatusCode();
        if (null != substatus) {
            this.setSubStatus(substatus.getValue());
        }
        this.setIssuerVal(this.opensamlResponse.getIssuer().getValue());
        this.setIssueInstant(this.opensamlResponse.getIssueInstant());
        this.setDestination(this.opensamlResponse.getDestination());
        this.validateDestination();
        Message requestMessage = this.validateInResponseTo();
        this.setMessageData(requestMessage.getMessageData());
        this.setSessionIndex(requestMessage.getSessionIndex());
        this.validateSloIssuer(requestMessage, this.getIssuerVal());
        logger.info("Successfully validated issuer: ", (Object)this.getIssuerVal());
        String checkAlg = this.getRequest().getParameter("SigAlg");
        X509Certificate cert = SamlUtils.getIDPCertByIssuer(this.controller.getMetadataSettings(), this.getIssuerVal());
        SamlUtils samlUtils = new SamlUtils(cert, null, null, checkAlg, null);
        try {
            samlUtils.validateRequestSignature(this.getRequest(), false);
        }
        catch (Exception error) {
            logger.error("Signature validation for logout response failed!", (Throwable)error);
            if (this.getValidationResult().isValid()) {
                this.setValidationResult(new ValidationResult(400, "BadResponse", "Signature validation error."));
            }
            throw error;
        }
        logger.info("Successfully validated received Logout Response");
    }

    private Message validateInResponseTo() throws ValidationException {
        String responseTo = this.opensamlResponse.getInResponseTo();
        if (responseTo == null) {
            this.isIdpInitiated = true;
            return null;
        }
        Message message = this.controller.getMessageStore().get(responseTo);
        if (message == null) {
            this.setValidationResult(new ValidationResult(400, "BadResponse", "No authentication request found matching InResponseTo attribute of SAML Response from IDP."));
            logger.info("No matching logout request: InResponseTo: " + responseTo);
            throw new ValidationException("No authentication request found matching InResponseTo attribute of SAML Response from IDP. No matching logout request found.");
        }
        return message;
    }

    private void DecodeResponse() throws Exception {
        String relayState;
        String samlResponseStr = this.getRequest().getParameter("SAMLResponse");
        String decodedResponseStr = SamlUtils.extractResponse(samlResponseStr);
        Validate.notNull((Object)decodedResponseStr, (String)"decodedResponseStr");
        this.setSamlDom(SharedUtils.createDOM(decodedResponseStr));
        if (logger.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Element rootE = this.getSamlDom().getDocumentElement();
            rootE.normalize();
            SharedUtils.formattedPrint(rootE, baos);
            decodedResponseStr = baos.toString("UTF-8");
            logger.trace("Decoded SAML Response is " + decodedResponseStr);
        }
        if ((relayState = this.getRequest().getParameter("RelayState")) != null) {
            String decodedRelayState = new String(Base64.decode((String)relayState));
            this.setRelayState(relayState);
            logger.info("Decoded Relay State is " + decodedRelayState);
        }
    }
}

