/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.Attribute;
import com.vmware.identity.websso.client.AuthnData;
import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageData;
import com.vmware.identity.websso.client.SamlUtils;
import com.vmware.identity.websso.client.SharedUtils;
import com.vmware.identity.websso.client.SubjectData;
import com.vmware.identity.websso.client.TokenType;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.ValidationState;
import com.vmware.identity.websso.client.WebssoClientException;
import com.vmware.identity.websso.client.endpoint.SsoResponseListener;
import java.io.ByteArrayOutputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SsoValidationState
extends ValidationState {
    private static final Logger logger = LoggerFactory.getLogger(SsoValidationState.class);
    private final SsoResponseListener controller;
    private Response opensamlResponse;

    public SsoValidationState(HttpServletRequest request, SsoResponseListener controller) {
        super(controller.getMetadataSettings());
        this.setRequest(request);
        this.controller = controller;
    }

    @Override
    public void validate() throws Exception {
        logger.info("Validating SAMLResponse..");
        Validate.notNull((Object)this.getRequest(), (String)"HttpServletRequest");
        this.DecodeResponse();
        this.opensamlResponse = (Response)SamlUtils.unmarshallSAMLObj(this.getSamlDom());
        Validate.notNull((Object)this.opensamlResponse, (String)"Response object");
        Status status = this.opensamlResponse.getStatus();
        StatusCode statusCode = status.getStatusCode();
        this.setMessageID(this.opensamlResponse.getID());
        this.setStatus(statusCode.getValue());
        StatusCode substatus = statusCode.getStatusCode();
        if (null != substatus) {
            this.setSubStatus(substatus.getValue());
        }
        Validate.notNull((Object)this.opensamlResponse.getIssuer(), (String)"issuer");
        this.setIssuerVal(this.opensamlResponse.getIssuer().getValue());
        this.setIssueInstant(this.opensamlResponse.getIssueInstant());
        this.setDestination(this.opensamlResponse.getDestination());
        this.validateDestination();
        Message requestMessage = this.validateInResponseTo();
        if (null != requestMessage) {
            this.controller.getMessageStore().remove(requestMessage.getId());
        }
        if (statusCode.getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            this.validateAssertion();
            logger.info("Successfully validated received SAMLResponse");
        } else {
            logger.info("Received failure response from SSO server, status code: " + this.getStatus() + " substatus code: " + this.getSubStatus());
        }
    }

    private void DecodeResponse() throws Exception {
        String relayState;
        String samlResponseStr = this.getRequest().getParameter("SAMLResponse");
        Validate.notEmpty((String)samlResponseStr, (String)"Empty SSO response string");
        String decodedResponseStr = new String(Base64.decode((String)samlResponseStr), "UTF-8");
        this.setSamlDom(SharedUtils.createDOM(decodedResponseStr));
        logger.debug("Decoded SAML Response without pretty formatting is " + decodedResponseStr);
        if (logger.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Element rootE = this.getSamlDom().getDocumentElement();
            rootE.normalize();
            SharedUtils.formattedPrint(rootE, baos);
            decodedResponseStr = baos.toString("UTF-8");
        }
        if ((relayState = this.getRequest().getParameter("RelayState")) != null) {
            String decodedRelayState = new String(Base64.decode((String)relayState), "UTF-8");
            this.setRelayState(relayState);
            logger.debug("Decoded Relay State is " + decodedRelayState);
        }
    }

    private Message validateInResponseTo() throws ValidationException {
        String responseTo = this.opensamlResponse.getInResponseTo();
        logger.info("Validating optional request ID: " + responseTo);
        if (responseTo == null) {
            this.isIdpInitiated = true;
            return null;
        }
        Message message = this.controller.getMessageStore().get(responseTo);
        if (message == null) {
            this.setValidationResult(new ValidationResult(400, "BadResponse", "No authentication request found matching InResponseTo attribute of SAML Response from IDP."));
            throw new ValidationException("No authentication request found matching InResponseTo attribute of SAML Response from IDP. No matching logon request found for SAML response: " + responseTo);
        }
        return message;
    }

    private void validateAssertion() throws Exception {
        logger.info("Validating assertion..");
        List assertions = this.opensamlResponse.getAssertions();
        Validate.notEmpty((Collection)assertions, (String)"assertions");
        Assertion assertion = (Assertion)assertions.get(0);
        Validate.notNull((Object)assertion, (String)"assertion");
        String checkAlg = this.getRequest().getParameter("SigAlg");
        X509Certificate cert = null;
        try {
            cert = SamlUtils.getIDPCertByIssuer(this.controller.getMetadataSettings(), this.getIssuerVal());
        }
        catch (Exception e) {
            logger.error("Can't find IDP certificate with IDP: " + this.getIssuerVal());
            this.setValidationResult(new ValidationResult(403, "BadResponse", "Issuer not trusted: "));
            throw e;
        }
        SamlUtils samlUtils = new SamlUtils(cert, null, null, checkAlg, null);
        boolean isResponseSigned = false;
        try {
            isResponseSigned = samlUtils.validateRequestSignature(this.getRequest(), false);
        }
        catch (Exception error) {
            logger.info("Invalid Response signature");
            if (this.getValidationResult().isValid()) {
                this.setValidationResult(new ValidationResult(400, "BadRequest", "Invalid signature."));
            }
            throw error;
        }
        MessageData messageData = this.parseAssertion(assertion, isResponseSigned);
        this.setMessageData(messageData);
        this.setSessionIndex(((AuthnData)messageData).getSessionIndex());
        logger.info("Successfully validated SSO Assertion");
    }

    private MessageData parseAssertion(Assertion assertion, boolean isResponseSigned) throws MarshallingException, ValidationException, WebssoClientException {
        DateTime exp;
        logger.info("Parsing assertion..");
        Validate.notNull((Object)assertion);
        Subject subject = assertion.getSubject();
        Validate.notNull((Object)subject, (String)"Assertion subject");
        Document token = SamlUtils.createDomFromSignable((SignableSAMLObject)assertion);
        TokenType tokenType = TokenType.BEARER;
        List confirmations = subject.getSubjectConfirmations();
        if (confirmations != null && !confirmations.isEmpty()) {
            SubjectConfirmation confirmation = (SubjectConfirmation)confirmations.get(0);
            Validate.notNull((Object)confirmation, (String)"SubjectConfirmation");
            tokenType = confirmation.getMethod().equals("urn:oasis:names:tc:SAML:2.0:cm:bearer") ? TokenType.BEARER : TokenType.HOLDER_OF_KEY;
        }
        assertion.validate(true);
        Signature signature = assertion.getSignature();
        String issuer = assertion.getIssuer().getValue();
        IDPConfiguration idpConfig = this.controller.getMetadataSettings().getIDPConfigurationByEntityID(issuer);
        if (idpConfig == null) {
            throw new WebssoClientException("Uknown IDP configuration. IDP entity ID = : " + issuer);
        }
        if (signature != null) {
            X509Certificate cert = idpConfig.getSigningCertificate();
            try {
                SamlUtils.ValidateSignature(signature, cert);
            }
            catch (Exception e) {
                logger.error("SAML Assertion signature validation failed! ", (Throwable)e);
                if (this.getValidationResult().isValid()) {
                    this.setValidationResult(new ValidationResult(400, "BadRequest", "Invalid signature."));
                }
                throw new ValidationException(e);
            }
        } else if (!isResponseSigned || this.controller.isAssertionMustBeSigned()) {
            logger.error("Neither response or assertion is signed");
            if (this.getValidationResult().isValid()) {
                this.setValidationResult(new ValidationResult(400, "BadRequest", "Assertion not signed."));
            }
            throw new ValidationException("Assertion not signed.");
        }
        int clockTolerance = 0;
        try {
            clockTolerance = idpConfig == null ? 600 : idpConfig.getClockTolerance();
            SamlUtils.ValidateConditions(assertion.getConditions(), clockTolerance);
        }
        catch (ValidationException e) {
            if (this.getValidationResult().isValid()) {
                this.setValidationResult(new ValidationResult(400, "BadRequest", "Invalid condition value in token. If this is issued by legitimate IDP, it is possibly caused by clock skew or slow response due to network issues."));
            }
            throw e;
        }
        NameID nameID = subject.getNameID();
        Validate.notNull((Object)nameID, (String)"NameID");
        String nameIDFormat = nameID.getFormat();
        String nameIDStr = nameID.getValue();
        logger.info("NameID: " + nameIDStr);
        logger.info("NameIDFormat: " + nameIDFormat);
        SubjectData subjectData = new SubjectData(nameIDFormat, nameIDStr);
        String context = null;
        String sessionIndex = null;
        DateTime sessionNotOnOrAfter = null;
        List statements = assertion.getAuthnStatements();
        if (statements != null && !statements.isEmpty()) {
            AuthnStatement statement = (AuthnStatement)statements.get(0);
            sessionIndex = statement.getSessionIndex();
            AuthnContextClassRef authnContextRef = statement.getAuthnContext().getAuthnContextClassRef();
            if (authnContextRef != null) {
                context = authnContextRef.toString();
            }
            if ((sessionNotOnOrAfter = statement.getSessionNotOnOrAfter()) != null) {
                try {
                    SamlUtils.ValidateSessionExpiry(sessionNotOnOrAfter, clockTolerance);
                }
                catch (ValidationException e) {
                    if (this.getValidationResult().isValid()) {
                        this.setValidationResult(new ValidationResult(400, "BadRequest", "Failed to validate the session expiry date."));
                    }
                    throw e;
                }
            }
        }
        List<Attribute> attributes = null;
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements != null && !attributeStatements.isEmpty()) {
            attributes = this.parseAttributes(attributeStatements);
        }
        Date expDate = (exp = assertion.getConditions().getNotOnOrAfter()) == null ? null : exp.toDate();
        AuthnData authnData = new AuthnData(subjectData, expDate, sessionIndex, context, attributes, tokenType, token, sessionNotOnOrAfter);
        return authnData;
    }

    private List<Attribute> parseAttributes(List<AttributeStatement> statements) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Validate.notEmpty(statements, (String)"statements");
        for (AttributeStatement statement : statements) {
            List opensamlAttrs = statement.getAttributes();
            for (org.opensaml.saml2.core.Attribute samlAttr : opensamlAttrs) {
                String name = samlAttr.getName();
                String friendlyName = samlAttr.getFriendlyName();
                List<String> valueStrs = this.parseSamlAttributeValues(samlAttr.getAttributeValues());
                Attribute attr = new Attribute(name, friendlyName, valueStrs);
                attributes.add(attr);
            }
        }
        return attributes;
    }

    private List<String> parseSamlAttributeValues(List<XMLObject> list) {
        LinkedList<String> valStrings = new LinkedList<String>();
        Validate.notNull(list, (String)"Attributes");
        Iterator<XMLObject> iter = list.iterator();
        while (iter.hasNext()) {
            String valStr = iter.next().getDOM().getTextContent();
            if (valStr != null) {
                valStrings.add(valStr);
            }
            logger.trace("attribute value " + valStr);
        }
        return valStrings;
    }
}

