/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client.endpoint;

import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.LogoutProcessor;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageType;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SamlUtils;
import com.vmware.identity.websso.client.SloRequestValidationState;
import com.vmware.identity.websso.client.SloResponseValidationState;
import com.vmware.identity.websso.client.SubjectData;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.ValidationState;
import com.vmware.identity.websso.client.WebssoClientException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.xml.io.MarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SloListener {
    private static final Logger logger = LoggerFactory.getLogger(SloListener.class);
    private ValidationState validationState;
    private String tenant;
    @Autowired
    private MetadataSettings metadataSettings;
    @Autowired
    private MessageStore messageStore;
    @Autowired
    private LogoutProcessor logoutProcessor;

    public void setMetadataSettings(MetadataSettings metadataSettings) {
        this.metadataSettings = metadataSettings;
    }

    public MetadataSettings getMetadataSettings() {
        return this.metadataSettings;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setLogoutProcessor(LogoutProcessor logoutProcessor) {
        this.logoutProcessor = logoutProcessor;
    }

    public LogoutProcessor getLogoutProcessor() {
        return this.logoutProcessor;
    }

    @RequestMapping(value={"/SsoClient/SLO/{tenant:.*}"}, method={RequestMethod.GET})
    public void slo(@PathVariable(value="tenant") String tenant, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.info("You sent a GET message to Websso client library! ");
        LogoutProcessor processor = this.getLogoutProcessor();
        Validate.notNull((Object)processor, (String)"LogoutProcessor is not set");
        this.setTenant(tenant);
        if (request != null) {
            String samlResponseStr = request.getParameter("SAMLResponse");
            String samlRequestStr = request.getParameter("SAMLRequest");
            if (samlResponseStr != null) {
                this.sloResponse(request, httpResponse);
            } else if (samlRequestStr != null) {
                this.sloRequest(request, httpResponse);
            } else {
                logger.error("Null request or response.");
                SloRequestValidationState validator = new SloRequestValidationState(request, this);
                this.validationState = validator;
                validator.setValidationResult(new ValidationResult(400, "BadRequest", "No request string!"));
                Message errorMessage = this.createMessage(validator, true);
                processor.logoutError(errorMessage, request, httpResponse);
            }
        }
    }

    private void sloRequest(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.info("Logout request received: ");
        LogoutProcessor processor = this.getLogoutProcessor();
        SloRequestValidationState validator = new SloRequestValidationState(request, this);
        this.validationState = validator;
        try {
            ((ValidationState)validator).validate();
            Message message = this.createMessage(validator, false);
            this.getMessageStore().add(message);
            processor.logoutRequest(message, request, httpResponse, this.getTenant());
        }
        catch (Exception error) {
            logger.error("Logout request validation failed.", (Throwable)error);
            if (validator.getValidationResult().isValid()) {
                validator.setValidationResult(new ValidationResult(400, "BadRequest", error.getMessage()));
            }
            Message errorMessage = this.createMessage(validator, true);
            processor.logoutError(errorMessage, request, httpResponse);
            return;
        }
        try {
            String redirectUrl = this.createResponseUrl(validator.getMessageID(), validator.getIssuerVal(), (SubjectData)validator.getMessageData(), validator.getRelayState());
            logger.info("SP SAML Response URL is " + redirectUrl);
            if (validator.getValidationResult().isValid()) {
                if (redirectUrl != null) {
                    httpResponse.sendRedirect(redirectUrl);
                } else {
                    logger.warn(String.format("SLO end point does not exist for IDP: %s, SLO response is not sent.", validator.getIssuerVal()));
                }
            }
        }
        catch (Exception error) {
            processor.internalError(error, request, httpResponse);
        }
    }

    private String createResponseUrl(String inResponseTo, String idpUrl, SubjectData subject, String relayState) throws MarshallingException, IOException, WebssoClientException, NoSuchAlgorithmException {
        String retval = null;
        LogoutResponse samlResponse = this.createResponse(inResponseTo, idpUrl);
        if (samlResponse != null) {
            logger.info("SAML Response is created ");
            retval = this.createResponseUrlFromLogoutResponse(samlResponse, idpUrl, relayState);
        }
        return retval;
    }

    private String createResponseUrlFromLogoutResponse(LogoutResponse samlResponse, String idpUrl, String relayState) throws MarshallingException, IOException, WebssoClientException, NoSuchAlgorithmException {
        logger.info("generateResponseUrl to IDP," + idpUrl);
        String retval = null;
        Validate.notNull((Object)samlResponse, (String)"Null LogoutResponse object.");
        Validate.notNull((Object)idpUrl, (String)"idpUrl can not be null");
        String encodedResponse = SamlUtils.encodeSAMLObject((SignableSAMLObject)samlResponse, true);
        SPConfiguration spConfig = this.getMetadataSettings().getSPConfiguration(this.getTenant());
        String signingAlgo = spConfig.getSigningAlgorithm();
        PrivateKey key = spConfig.getSigningPrivateKey();
        if (null == key && null == signingAlgo) {
            throw new WebssoClientException("SP Configuration does not have signing key/algorithm set.");
        }
        String toBeSigned = SamlUtils.generateRedirectUrlQueryStringParameters(null, encodedResponse, relayState, spConfig.getSigningAlgorithm(), null);
        SamlUtils samlUtils = new SamlUtils(null, key, signingAlgo, null, SamlUtils.getSpSloLocation(spConfig, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"));
        String signature = samlUtils.signMessage(toBeSigned);
        retval = samlResponse.getDestination();
        String queryString = SamlUtils.generateRedirectUrlQueryStringParameters(null, encodedResponse, relayState, signingAlgo, signature);
        retval = retval + "?" + queryString;
        logger.info("Generated URL " + retval);
        return retval;
    }

    private LogoutResponse createResponse(String inResponseTo, String idpUrl) throws WebssoClientException {
        LogoutResponse retval = null;
        logger.info("generate SLO response for IDP: " + idpUrl);
        if (this.validationState.getValidationResult().getResponseCode() == 200) {
            Validate.notNull((Object)idpUrl, (String)"idpUrl");
            IDPConfiguration idpConfig = this.getMetadataSettings().getIDPConfigurationByEntityID(idpUrl);
            if (idpConfig == null) {
                throw new WebssoClientException("Uknown IDP configuration. IDP entity ID = : " + idpUrl);
            }
            try {
                String destination = SamlUtils.getIdpSloLocation(idpConfig, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                if (destination == null) {
                    logger.warn(String.format("SLO end point does not exist for IDP: %s.", idpConfig.getAlias()));
                    return null;
                }
                String issuerValue = this.getIssuerVal(this.tenant);
                ValidationResult valResult = this.validationState.getValidationResult();
                retval = SamlUtils.createSamlLogoutResponse(issuerValue, inResponseTo, destination, valResult.getStatus(), valResult.getSubstatus(), null);
            }
            catch (Exception e) {
                logger.error("Caught exception while generating response.", (Throwable)e);
                throw new WebssoClientException(e);
            }
        }
        return retval;
    }

    private String getIssuerVal(String tenant) throws WebssoClientException {
        if (tenant == null) {
            return null;
        }
        SPConfiguration sp = this.getMetadataSettings().getSPConfiguration(tenant);
        Validate.notNull((Object)sp, (String)("service provider setting unavailable for " + tenant));
        if (sp == null) {
            throw new IllegalArgumentException("service provider setting unavailable for " + tenant);
        }
        return sp.getEntityID();
    }

    private void sloResponse(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.info("Logout response received: ");
        LogoutProcessor processor = this.getLogoutProcessor();
        SloResponseValidationState validator = new SloResponseValidationState(request, this);
        this.validationState = validator;
        try {
            ((ValidationState)validator).validate();
            Message message = this.createMessage(validator, true);
            if (validator.getStatus().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
                this.getLogoutProcessor().logoutSuccess(message, request, httpResponse);
            } else {
                logger.error("Received Logout Response status is a 'Logout Failure'");
                this.getLogoutProcessor().logoutError(message, request, httpResponse);
            }
        }
        catch (Exception error) {
            logger.error("Logout Response validation failed. Exception:", (Throwable)error);
            if (validator.getValidationResult().isValid()) {
                validator.setValidationResult(new ValidationResult(400, "BadResponse", error.getMessage()));
            }
            Message errorMessage = this.createMessage(validator, true);
            processor.logoutError(errorMessage, request, httpResponse);
        }
    }

    private Message createMessage(ValidationState validator, Boolean isResponse) {
        String status = validator.getStatus();
        String substatus = validator.getSubStatus();
        String relayState = validator.getRelayState();
        String sessionId = validator.getSessionIndex();
        Message message = new Message(isResponse != false ? MessageType.LOGOUT_RESPONSE : MessageType.LOGOUT_REQUEST, validator.getMessageID(), relayState, validator.getIssueInstant(), validator.getIssuerVal(), validator.getDestination(), status, substatus, sessionId, validator.getMessageData(), null, validator.isIdpInitiated());
        message.setValidationResult(validator.getValidationResult());
        logger.info("Logout response/request validation result:");
        logger.info("Status: %s  Substatus: %s SessionIndex:%s RelayState:%s  ", new Object[]{status, substatus, sessionId, relayState});
        return message;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }
}

