/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client.endpoint;

import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.LogoutProcessor;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageType;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SamlUtils;
import com.vmware.identity.websso.client.SloRequestSettings;
import com.vmware.identity.websso.client.SubjectData;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.LogoutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SloRequestSender {
    private static final Logger logger = LoggerFactory.getLogger(SloRequestSender.class);
    @Autowired
    private MetadataSettings metadataSettings;
    @Autowired
    private MessageStore messageStore;
    @Autowired
    private LogoutProcessor logoutProcessor;

    public void setMetadataSettings(MetadataSettings metadataSettings) {
        this.metadataSettings = metadataSettings;
    }

    public MetadataSettings getMetadataSettings() {
        return this.metadataSettings;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setLogoutProcessor(LogoutProcessor logoutProcessor) {
        this.logoutProcessor = logoutProcessor;
    }

    public LogoutProcessor getLogoutProcessor() {
        return this.logoutProcessor;
    }

    public void sendRequest(SloRequestSettings requestSettings, HttpServletResponse response) throws IOException {
        Validate.notNull((Object)requestSettings, (String)"requestSettings");
        Validate.notNull((Object)response, (String)"response");
        Validate.notNull((Object)this.getMessageStore(), (String)"MessageStore");
        Validate.notNull((Object)this.getMetadataSettings(), (String)"MetadataSettings");
        String redirectUrl = this.getRequestUrl(requestSettings);
        if (redirectUrl != null) {
            response.sendRedirect(redirectUrl);
        } else if (SamlUtils.isIdpSupportSLO(this.getMetadataSettings(), requestSettings)) {
            logger.error("Failed to send out the SLO request!");
        } else {
            logger.warn(String.format("SLO end point does not exist for IDP: %s, SLO request is not sent.", requestSettings.getIDPAlias()));
        }
    }

    public String getRequestUrl(SloRequestSettings requestSettings) {
        Validate.notNull((Object)requestSettings);
        String redirectUrl = null;
        try {
            logger.info("Producing redirect url");
            LogoutRequest samlRequest = this.createRequest(requestSettings);
            if (samlRequest != null) {
                logger.info("SP LogoutRequest is created.");
                redirectUrl = this.createRequestUrlFromLogoutRequest(samlRequest, requestSettings);
            }
            return redirectUrl;
        }
        catch (Exception e) {
            logger.error("Failed to create logout request url! Exception = ", (Throwable)e);
            this.logoutProcessor.internalError(e, null, null);
            return redirectUrl;
        }
    }

    private String createRequestUrlFromLogoutRequest(LogoutRequest samlRequest, SloRequestSettings requestSettings) {
        String retval = null;
        logger.info("createRequestUrlFromLogoutRequest, IDP: " + requestSettings.getIDPAlias());
        Validate.notNull((Object)samlRequest, (String)"samlRequest can't be null");
        Validate.notNull((Object)requestSettings, (String)"SloRequestSettings can't be null");
        try {
            SPConfiguration spConfig = this.getMetadataSettings().getSPConfiguration(requestSettings.getSPAlias());
            if (spConfig == null) {
                throw new IllegalArgumentException("service provider setting unavailable for " + requestSettings.getSPAlias());
            }
            String issuer = SamlUtils.getSpSloLocation(spConfig, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            Validate.notEmpty((String)issuer, (String)"issuer");
            SamlUtils samlUtils = new SamlUtils(null, spConfig.getSigningPrivateKey(), spConfig.getSigningAlgorithm(), null, issuer);
            String encodedRequest = SamlUtils.encodeSAMLObject((SignableSAMLObject)samlRequest, true);
            Boolean isSigned = requestSettings.isSigned();
            if (isSigned.booleanValue()) {
                Validate.notNull((Object)spConfig.getSigningAlgorithm(), (String)"signing algorithm");
                Validate.notNull((Object)spConfig.getSigningPrivateKey(), (String)"signing key");
            }
            String toBeSigned = SamlUtils.generateRedirectUrlQueryStringParameters(encodedRequest, null, requestSettings.getRelayState(), isSigned != false ? spConfig.getSigningAlgorithm() : null, null);
            logger.info("Relay State: " + requestSettings.getRelayState());
            if (toBeSigned == null || toBeSigned.isEmpty()) {
                logger.warn("Message to be signed is null or empty");
            }
            retval = samlRequest.getDestination();
            if (isSigned.booleanValue()) {
                String signature = samlUtils.signMessage(toBeSigned);
                String queryString = SamlUtils.generateRedirectUrlQueryStringParameters(encodedRequest, null, requestSettings.getRelayState(), spConfig.getSigningAlgorithm(), signature);
                retval = retval + "?" + queryString;
            } else {
                retval = retval + "?" + toBeSigned;
            }
        }
        catch (Exception e) {
            retval = null;
        }
        return retval;
    }

    private LogoutRequest createRequest(SloRequestSettings requestSettings) {
        LogoutRequest request = null;
        logger.info("generateRequest for IDP: " + requestSettings.getIDPAlias());
        try {
            IDPConfiguration idpConfig = this.getMetadataSettings().getIDPConfiguration(requestSettings.getIDPAlias());
            Validate.notNull((Object)idpConfig, (String)("IDPConfiguration not found for " + requestSettings.getIDPAlias()));
            SPConfiguration spConfig = this.getMetadataSettings().getSPConfiguration(requestSettings.getSPAlias());
            if (spConfig == null) {
                throw new IllegalArgumentException("service provider setting unavailable for " + requestSettings.getSPAlias());
            }
            String issuer = spConfig.getEntityID();
            SamlUtils samlUtils = new SamlUtils(null, null, null, null, issuer);
            String destination = SamlUtils.getIdpSloLocation(idpConfig, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            if (destination == null) {
                logger.warn(String.format("SLO end point does not exist for IDP: %s.", idpConfig.getAlias()));
                return null;
            }
            request = samlUtils.createSamlLogoutRequest(null, destination, requestSettings.getNameIDFormat(), requestSettings.getSubject(), requestSettings.getSessionIndex());
            Message message = new Message(MessageType.LOGOUT_REQUEST, request.getID(), requestSettings.getRelayState(), request.getIssueInstant(), request.getIssuer().getValue(), destination, null, null, requestSettings.getSessionIndex(), new SubjectData(requestSettings.getNameIDFormat(), requestSettings.getSubject()), null, false);
            this.getMessageStore().add(message);
        }
        catch (Exception e) {
            logger.error("Caught exception while generating request " + e.toString() + ", will ignore the request.");
            return null;
        }
        return request;
    }
}

