/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.AlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.AlarmStateRetriever;
import com.vmware.opsmgmt.client.alarms.util.EntityNameRetriever;
import com.vmware.opsmgmt.client.alarms.util.IssueInfoBuilder;
import com.vmware.opsmgmt.client.alarms.util.LabelAndIconRetriever;
import com.vmware.opsmgmt.client.alarms.util.ServiceAlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

@type(value="Issue,AlarmIssue")
public class AlarmIssueAdapter
extends IssueAdapterBase {
    private static final IssueAdapterBase.IssueData[] _EMPTY_ISSUE_DATA = new IssueAdapterBase.IssueData[0];
    private DataService _dataService;
    private final AlarmStateRetriever _alarmStateRetriever;
    private final AlarmInfoRetriever _alarmInfoRetriever;
    private final IssueInfoBuilder _issueInfoBuilder;
    private final EntityNameRetriever _entityNameRetriever;
    private ServiceAlarmInfoRetriever _serviceAlarmInfoRetriever;

    public AlarmIssueAdapter(DataService dataService, QuerySpecBuilder querySpecBuilder, ThreadPoolExecutor threadPoolExecutor) {
        super("AlarmIssue", threadPoolExecutor);
        this._dataService = dataService;
        this._alarmStateRetriever = new AlarmStateRetriever(dataService, querySpecBuilder);
        this._alarmInfoRetriever = new AlarmInfoRetriever(dataService);
        this._entityNameRetriever = new EntityNameRetriever(dataService);
        this._issueInfoBuilder = new IssueInfoBuilder();
    }

    public void setServiceAlarmInfoRetriever(ServiceAlarmInfoRetriever serviceAlarmInfoRetriever) {
        this._serviceAlarmInfoRetriever = serviceAlarmInfoRetriever;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext requestContext) {
        PropertyConstraint propertyConstraint;
        if (querySpec.resourceSpec.constraint instanceof PropertyConstraint && AlarmIssueAdapter.isForEntity(propertyConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint)) {
            return this.getIssuesForEntity(querySpec, requestContext);
        }
        return this.getAllIssues(querySpec, requestContext);
    }

    protected ResultSet processResultSet(ResultSet resultSet, QuerySpec querySpec, IssueAdapterBase.RequestContext requestContext) {
        if (requestContext.context != null) {
            resultSet.totalMatchedObjectCount = (Integer)requestContext.context;
        }
        return resultSet;
    }

    private IssueAdapterBase.IssueData[] getIssuesForEntity(QuerySpec querySpec, IssueAdapterBase.RequestContext requestContext) {
        Object object = this.extractEntityFromQuerySpec(querySpec);
        if (!(object instanceof ManagedObjectReference)) {
            return _EMPTY_ISSUE_DATA;
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        return this.getAllIssuesInternal(requestContext, arrayList, AlarmIssueAdapter.getTargetType(querySpec), AlarmIssueAdapter.getMaxResultCount(querySpec), AlarmIssueAdapter.getPropertySpecs(querySpec), ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference), querySpec.name);
    }

    private IssueAdapterBase.IssueData[] getAllIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext requestContext) {
        Object[] objectArray = AlarmIssueAdapter.getStartupLinkedVcGroup();
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return _EMPTY_ISSUE_DATA;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            for (VcService vcService : object.getVcServices()) {
                arrayList.add(ManagedObjectUtil.getRootFolder((String)vcService.getServiceGuid()));
            }
        }
        if (arrayList.isEmpty()) {
            return _EMPTY_ISSUE_DATA;
        }
        return this.getAllIssuesInternal(requestContext, arrayList, AlarmIssueAdapter.getTargetType(querySpec), AlarmIssueAdapter.getMaxResultCount(querySpec), AlarmIssueAdapter.getPropertySpecs(querySpec), true, querySpec.name);
    }

    private IssueAdapterBase.IssueData[] getAllIssuesInternal(IssueAdapterBase.RequestContext requestContext, List<Object> list, String string, Integer n, PropertySpec[] propertySpecArray, boolean bl, String string2) {
        boolean bl2 = _performanceLogger.isInfoEnabled();
        long l = 0L;
        long l2 = 0L;
        if (bl2) {
            l = System.currentTimeMillis();
        }
        AlarmStateRetriever.Result result = this._alarmStateRetriever.retrieve(true, list, string, n);
        if (bl2) {
            l2 = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: AlarmsStates retrieved in %d milliseconds.", string2, l2 - l));
        }
        Object[] objectArray = result.alarms;
        int n2 = result.totalAlarms;
        Map<String, ServiceAlarmInfo> map = Collections.emptyMap();
        if (!ArrayUtil.isNullOrEmpty((Object[])objectArray) && bl) {
            int n3 = objectArray.length;
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
            if (bl2) {
                l = System.currentTimeMillis();
            }
            map = this._serviceAlarmInfoRetriever.retrieve(arrayList, string2);
            if (bl2) {
                l2 = System.currentTimeMillis();
                _performanceLogger.info((Object)String.format("%s: ServiceAlarmInfosMap retrieved in %d ms.", string2, l2 - l));
            }
            objectArray = arrayList.toArray(new AlarmState[arrayList.size()]);
            n2 -= n3 - objectArray.length;
        }
        requestContext.context = n2;
        return this.convertToAlarmIssues((AlarmState[])objectArray, map, propertySpecArray, string2);
    }

    private IssueAdapterBase.IssueData[] convertToAlarmIssues(AlarmState[] alarmStateArray, Map<String, ServiceAlarmInfo> map, PropertySpec[] propertySpecArray, String string) {
        boolean bl = _performanceLogger.isInfoEnabled();
        long l = 0L;
        long l2 = 0L;
        if (ArrayUtil.isNullOrEmpty((Object[])alarmStateArray)) {
            return new IssueAdapterBase.IssueData[0];
        }
        LabelAndIconRetriever labelAndIconRetriever = new LabelAndIconRetriever(this._dataService);
        labelAndIconRetriever.retrieve(alarmStateArray, propertySpecArray);
        if (bl) {
            l = System.currentTimeMillis();
        }
        Map<ManagedObjectReference, AlarmInfo> map2 = this._alarmInfoRetriever.retrieve(alarmStateArray);
        if (bl) {
            l2 = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: AlarmInfos retrieved in %d ms.", string, l2 - l));
            l = l2;
        }
        Map<ManagedObjectReference, String> map3 = this._entityNameRetriever.retrieve(alarmStateArray, map2);
        if (bl) {
            l2 = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: EntityNames retrieved in %d ms.", string, l2 - l));
        }
        ArrayList<IssueAdapterBase.IssueData> arrayList = new ArrayList<IssueAdapterBase.IssueData>();
        for (int i = 0; i < alarmStateArray.length; ++i) {
            IssueInfo issueInfo;
            AlarmState alarmState = alarmStateArray[i];
            if (alarmState == null || (issueInfo = this._issueInfoBuilder.build(alarmState, map2, map3, labelAndIconRetriever.getIconIds(), labelAndIconRetriever.getLabelIds(), map.get(Util.buildAlarmKey(alarmState)))) == null) continue;
            IssueAdapterBase.IssueData issueData = new IssueAdapterBase.IssueData();
            issueData.key = Util.buildAlarmKey(alarmState);
            issueData.issueInfo = issueInfo;
            arrayList.add(issueData);
        }
        return arrayList.toArray(new IssueAdapterBase.IssueData[arrayList.size()]);
    }

    private static boolean isForEntity(PropertyConstraint propertyConstraint) {
        return Comparator.EQUALS.equals((Object)propertyConstraint.comparator) && "info.entity".equals(propertyConstraint.propertyName);
    }

    private static String getTargetType(QuerySpec querySpec) {
        return querySpec.resourceSpec.constraint.targetType;
    }

    private static Integer getMaxResultCount(QuerySpec querySpec) {
        return querySpec.resultSpec.maxResultCount;
    }

    private static PropertySpec[] getPropertySpecs(QuerySpec querySpec) {
        return querySpec.resourceSpec.propertySpecs;
    }

    private static LinkedVcGroup[] getStartupLinkedVcGroup() {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroupArray = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        return linkedVcGroupArray;
    }
}

