/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.opsmgmt.client.alarms.util.ServiceAlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import com.vmware.vise.vim.commons.messaging.UpdatesProcessor;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggeredAlarmsUpdatesProcessor
implements UpdatesProcessor<AlarmState> {
    private static final Log _logger = LogFactory.getLog(TriggeredAlarmsUpdatesProcessor.class);
    private static final String TRIGGERED_ALARM_STATE = "triggeredAlarmState";
    private static final String ALARM_INFOS_QUERY_NAME = "TriggeredAlarmsUpdatesProcessor.alarmInfos";
    private static final String ENTITY_NAMES_QUERY_NAME = "TriggeredAlarmsUpdatesProcessor.entityNames";
    private static final String SERVICE_INFOS_LOGGING_PREFIX = "TriggeredAlarmsUpdatesProcessor.serviceInfos";
    private static final Pattern ALARM_STATE_KEY = Pattern.compile("triggeredAlarmState\\[\"(?<key>.*?)\"\\]");
    private static final String REGEX_ALARMSTATE_KEY = "key";
    private final ConfigurationService _configurationService;
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private ServiceAlarmInfoRetriever _serviceAlarmInfoRetriever;

    public TriggeredAlarmsUpdatesProcessor(ConfigurationService configurationService, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._configurationService = configurationService;
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    public void setServiceAlarmInfoRetriever(ServiceAlarmInfoRetriever serviceAlarmInfoRetriever) {
        this._serviceAlarmInfoRetriever = serviceAlarmInfoRetriever;
    }

    public PartialUpdate<AlarmState> process(String string, PropertyCollector.FilterUpdate filterUpdate) {
        if (!this.enableProcessing()) {
            return null;
        }
        if (!"/topic/alarms".equals(string)) {
            return null;
        }
        PartialUpdate partialUpdate = PartialUpdate.empty();
        PropertyCollector.ObjectUpdate[] objectUpdateArray = filterUpdate.getObjectSet();
        if (objectUpdateArray == null) {
            return partialUpdate;
        }
        block0: for (PropertyCollector.ObjectUpdate objectUpdate : objectUpdateArray) {
            PropertyCollector.Change[] changeArray;
            if (objectUpdate.missingSet != null) {
                _logger.warn((Object)"missing object set");
            }
            for (PropertyCollector.Change change : changeArray = objectUpdate.getChangeSet()) {
                if (change.getName().startsWith(TRIGGERED_ALARM_STATE)) {
                    AlarmState[] alarmStateArray;
                    if (this.isNewAbsoluteValueReceived(change)) {
                        if (!change.val.getClass().isArray()) {
                            _logger.error((Object)"'triggeredAlarmState' property value MUST be an array");
                            continue block0;
                        }
                        for (AlarmState alarmState : alarmStateArray = (AlarmState[])change.val) {
                            partialUpdate.getUpdates().add(PartialUpdateItem.of((Object)alarmState, (Object)alarmState.alarm));
                        }
                        partialUpdate.isDelta = false;
                        partialUpdate.deleted.add(objectUpdate.obj);
                        if (changeArray.length == 1) continue block0;
                        _logger.error((Object)"Unable to handle a delta together with an absolute value");
                        continue block0;
                    }
                    alarmStateArray = this.createAlarmUpdate(change);
                    if (alarmStateArray == null) continue;
                    AlarmUtil.assignMetadata(alarmStateArray, "objUpdateGuid", objectUpdate.obj.getServerGuid());
                    partialUpdate.updates.add(alarmStateArray);
                    continue;
                }
                _logger.warn((Object)("Unexpected change with name: " + change.getName()));
            }
        }
        boolean bl = this.addMetadataToNewAlarms((PartialUpdate<AlarmState>)partialUpdate, partialUpdate.updates);
        if (!bl) {
            this.filterNewAlarms((PartialUpdate<AlarmState>)partialUpdate);
        }
        return partialUpdate;
    }

    public PropertyCollector.FilterSpec createFilterSpec(String string, VcService vcService) {
        if (!this.enableProcessing()) {
            return null;
        }
        if (!"/topic/alarms".equals(string)) {
            return null;
        }
        if (VcServiceUtil.is65VcOrLaterByVersion((String)vcService.getServiceVersion())) {
            return null;
        }
        PropertyCollector.ObjectSpec objectSpec = new PropertyCollector.ObjectSpec();
        objectSpec.setObj(vcService.getServiceInstanceContent().rootFolder);
        objectSpec.setSkip(Boolean.valueOf(false));
        PropertyCollector.PropertySpec propertySpec = new PropertyCollector.PropertySpec();
        propertySpec.setType((TypeName)new TypeNameImpl("Folder"));
        propertySpec.setPathSet(new String[]{TRIGGERED_ALARM_STATE});
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec();
        filterSpec.objectSet = new PropertyCollector.ObjectSpec[]{objectSpec};
        filterSpec.propSet = new PropertyCollector.PropertySpec[]{propertySpec};
        return filterSpec;
    }

    private void filterNewAlarms(PartialUpdate<AlarmState> partialUpdate) {
        ArrayList<PartialUpdateItem> arrayList = new ArrayList<PartialUpdateItem>();
        for (PartialUpdateItem partialUpdateItem : partialUpdate.updates) {
            if (!partialUpdateItem.isDelta) continue;
            arrayList.add(partialUpdateItem);
        }
        partialUpdate.updates = arrayList;
    }

    private boolean isNewAbsoluteValueReceived(PropertyCollector.Change change) {
        return TRIGGERED_ALARM_STATE.equals(change.getName()) && change.getOp() == PropertyCollector.Change.Op.assign;
    }

    private PartialUpdateItem<AlarmState> createAlarmUpdate(PropertyCollector.Change change) {
        Object object;
        PartialUpdateItem partialUpdateItem = null;
        if (change.getOp() == PropertyCollector.Change.Op.remove) {
            String string = TriggeredAlarmsUpdatesProcessor.extractAlarmStateKey(change.getName());
            AlarmState alarmState = new AlarmState();
            alarmState.key = string;
            partialUpdateItem = PartialUpdateItem.deltaOf(null, (Object)string);
        } else if (change.getOp() == PropertyCollector.Change.Op.add) {
            AlarmState alarmState = (AlarmState)change.getVal();
            partialUpdateItem = PartialUpdateItem.of((Object)alarmState, (Object)alarmState.alarm);
        } else if (change.getOp() == PropertyCollector.Change.Op.assign && (object = change.getVal()) instanceof AlarmState) {
            AlarmState alarmState = (AlarmState)object;
            partialUpdateItem = PartialUpdateItem.deltaOf((Object)alarmState, (Object)alarmState.alarm);
        }
        return partialUpdateItem;
    }

    private boolean addMetadataToNewAlarms(PartialUpdate<AlarmState> partialUpdate, List<PartialUpdateItem<AlarmState>> list) {
        if (list.isEmpty()) {
            return true;
        }
        ArrayList<AlarmState> arrayList = new ArrayList<AlarmState>();
        HashMap<ManagedObjectReference, AlarmInfo> hashMap = new HashMap<ManagedObjectReference, AlarmInfo>();
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> hashSet2 = new HashSet<ManagedObjectReference>();
        HashMap<ManagedObjectReference, String> hashMap2 = new HashMap<ManagedObjectReference, String>();
        this.extractAlarmInfosAndEntities(list, arrayList, hashMap, hashSet, hashSet2);
        Set<ManagedObjectReference> set = hashMap.keySet();
        if (!this.populateAlarmInfos(hashMap, hashSet, hashSet2, set) || !this.populateEntityNames(hashSet, hashSet2, hashMap2)) {
            return false;
        }
        Map<String, ServiceAlarmInfo> map = this._serviceAlarmInfoRetriever.retrieve(arrayList, SERVICE_INFOS_LOGGING_PREFIX);
        this.populateMetadataForAlarms(partialUpdate, hashMap, hashMap2, map);
        return true;
    }

    private void populateMetadataForAlarms(PartialUpdate<AlarmState> partialUpdate, HashMap<ManagedObjectReference, AlarmInfo> hashMap, Map<ManagedObjectReference, String> map, Map<String, ServiceAlarmInfo> map2) {
        for (PartialUpdateItem partialUpdateItem : partialUpdate.updates) {
            if (partialUpdateItem.isDelta) continue;
            AlarmState alarmState = (AlarmState)partialUpdateItem.data;
            String string = alarmState.key;
            ManagedObjectReference managedObjectReference = alarmState.entity;
            AlarmInfo alarmInfo = hashMap.get(alarmState.alarm);
            if (alarmInfo != null) {
                AlarmUtil.assignMetadata(partialUpdateItem, string, alarmInfo);
                ManagedObjectReference managedObjectReference2 = alarmInfo.entity;
                this.assignAlarmInfoNameMetadata(map, (PartialUpdateItem<AlarmState>)partialUpdateItem, managedObjectReference2);
                boolean bl = AlarmUtil.isVamiLinkVisisble(alarmInfo, managedObjectReference);
                AlarmUtil.assignMetadata(partialUpdateItem, "showVAMILink", bl);
                AlarmUtil.assignMetadata(partialUpdateItem, "issueUri", DefaultUriSchemeUtil.createUri((String)"AlarmIssue", (String)string));
                this.assignIssueInfoMetadata(map, map2, (PartialUpdateItem<AlarmState>)partialUpdateItem, alarmState, managedObjectReference, alarmInfo);
                continue;
            }
            _logger.error((Object)"AlarmInfo is null!");
        }
    }

    private void assignIssueInfoMetadata(Map<ManagedObjectReference, String> map, Map<String, ServiceAlarmInfo> map2, PartialUpdateItem<AlarmState> partialUpdateItem, AlarmState alarmState, ManagedObjectReference managedObjectReference, AlarmInfo alarmInfo) {
        String string;
        IssueInfo issueInfo = new IssueInfo();
        if (managedObjectReference != null) {
            issueInfo.entity = managedObjectReference;
            string = map.get(managedObjectReference);
            if (string != null) {
                issueInfo.entityName = string;
            } else {
                _logger.error((Object)"AlarmState entity name is null");
            }
        } else {
            _logger.error((Object)"AlarmState entity is null");
        }
        issueInfo.description = alarmInfo.description;
        string = map2.get(Util.buildAlarmKey(alarmState));
        issueInfo.service = string;
        AlarmUtil.assignMetadata(partialUpdateItem, "issueInfo", issueInfo);
    }

    private void assignAlarmInfoNameMetadata(Map<ManagedObjectReference, String> map, PartialUpdateItem<AlarmState> partialUpdateItem, ManagedObjectReference managedObjectReference) {
        if (managedObjectReference != null) {
            String string = map.get(managedObjectReference);
            if (string != null) {
                AlarmUtil.assignMetadata(partialUpdateItem, "alarmInfoName", string);
            } else {
                _logger.error((Object)"AlarmInfo entity name is null.");
            }
        } else {
            _logger.error((Object)"AlarmInfo entity is null.");
        }
    }

    private boolean populateAlarmInfos(HashMap<ManagedObjectReference, AlarmInfo> hashMap, Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2, Set<ManagedObjectReference> set3) {
        PropertyValue[] propertyValueArray;
        if (set3.isEmpty()) {
            return true;
        }
        try {
            propertyValueArray = this.queryProperties(set3, "info", ALARM_INFOS_QUERY_NAME);
        }
        catch (Exception exception) {
            _logger.error((Object)("[LiveRefresh] Couldnt retrieve infos: " + exception.getMessage()), (Throwable)exception);
            return false;
        }
        for (PropertyValue propertyValue : propertyValueArray) {
            AlarmInfo alarmInfo = (AlarmInfo)propertyValue.value;
            if (alarmInfo == null || alarmInfo.alarm == null) continue;
            hashMap.put(alarmInfo.alarm, alarmInfo);
            if (alarmInfo.entity == null) continue;
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmInfo.entity)) {
                set2.add(alarmInfo.entity);
                continue;
            }
            set.add(alarmInfo.entity);
        }
        return true;
    }

    private boolean populateEntityNames(Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2, Map<ManagedObjectReference, String> map) {
        PropertyValue[] propertyValueArray;
        for (ManagedObjectReference propertyValueArray2 : set2) {
            String string = VcServiceUtil.getServiceName((String)propertyValueArray2.getServerGuid());
            if (string == null) continue;
            map.put(propertyValueArray2, string);
        }
        if (set.isEmpty()) {
            return true;
        }
        try {
            propertyValueArray = this.queryProperties(set, "name", ENTITY_NAMES_QUERY_NAME);
        }
        catch (Exception exception) {
            _logger.error((Object)"Cannot extract entity names", (Throwable)exception);
            return false;
        }
        for (PropertyValue propertyValue : propertyValueArray) {
            map.put((ManagedObjectReference)propertyValue.resourceObject, (String)propertyValue.value);
        }
        return true;
    }

    private PropertyValue[] queryProperties(Set<ManagedObjectReference> set, String string, String string2) throws Exception {
        ResultItem[] resultItemArray;
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(ArrayUtil.toArray(set, ManagedObjectReference.class), new String[]{string});
        querySpec.name = string2;
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0 && resultItemArray[0] != null) {
            for (ResultItem resultItem : resultItemArray) {
                for (PropertyValue propertyValue : resultItem.properties) {
                    propertyValue.resourceObject = resultItem.resourceObject;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet != null && resultSet.error != null) {
            throw resultSet.error;
        }
        return arrayList.toArray(new PropertyValue[0]);
    }

    private void extractAlarmInfosAndEntities(List<PartialUpdateItem<AlarmState>> list, List<AlarmState> list2, HashMap<ManagedObjectReference, AlarmInfo> hashMap, Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2) {
        for (PartialUpdateItem<AlarmState> partialUpdateItem : list) {
            if (partialUpdateItem.isDelta) continue;
            AlarmState alarmState = (AlarmState)partialUpdateItem.data;
            list2.add(alarmState);
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmState.entity)) {
                set2.add(alarmState.entity);
            } else {
                set.add(alarmState.entity);
            }
            hashMap.put(alarmState.alarm, null);
        }
    }

    private static String extractAlarmStateKey(String string) {
        Matcher matcher = ALARM_STATE_KEY.matcher(string);
        if (!matcher.matches()) {
            _logger.error((Object)("Couldnt find a regex match for: " + string));
            return "";
        }
        String string2 = matcher.group(REGEX_ALARMSTATE_KEY);
        return string2;
    }

    private boolean enableProcessing() {
        return LiveUpdatesUtil.alarmsEnabled((ConfigurationService)this._configurationService) && LiveUpdatesUtil.alarmsPcBasedUpdateEnabled((ConfigurationService)this._configurationService);
    }
}

