/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LabelAndIconRetriever {
    private static final String ENTITY_ICON_ID_PROP = "entityIconId";
    private static final String MO_ICON_ID_PROP = "primaryIconId";
    private static final String ENTITY_LABELS_IDS_PROPS = "entityLabelIds";
    private static final String MO_LABELS_IDS_PROPS = "labelIds";
    private static final Log _logger = LogFactory.getLog(LabelAndIconRetriever.class);
    private DataService _dataService;
    private Map<ManagedObjectReference, String> _labelIds;
    private Map<ManagedObjectReference, String> _iconIds;

    public LabelAndIconRetriever(DataService dataService) {
        this._dataService = dataService;
        this._iconIds = new HashMap<ManagedObjectReference, String>();
        this._labelIds = new HashMap<ManagedObjectReference, String>();
    }

    public Map<ManagedObjectReference, String> getLabelIds() {
        return this._labelIds;
    }

    public Map<ManagedObjectReference, String> getIconIds() {
        return this._iconIds;
    }

    public void retrieve(AlarmState[] alarmStateArray, PropertySpec[] propertySpecArray) {
        this._iconIds = new HashMap<ManagedObjectReference, String>();
        this._labelIds = new HashMap<ManagedObjectReference, String>();
        if (ArrayUtil.isNullOrEmpty((Object[])propertySpecArray)) {
            return;
        }
        PropertySpec propertySpec = propertySpecArray[0];
        if (propertySpec == null || ArrayUtil.isNullOrEmpty((Object[])propertySpec.propertyNames)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : propertySpec.propertyNames) {
            if (ENTITY_ICON_ID_PROP.equals(string)) {
                arrayList.add(MO_ICON_ID_PROP);
                continue;
            }
            if (!ENTITY_LABELS_IDS_PROPS.equals(string)) continue;
            arrayList.add(MO_LABELS_IDS_PROPS);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        try {
            PropertyValue[] propertyValueArray;
            Object[] objectArray = this.getEntities(alarmStateArray);
            for (PropertyValue propertyValue : propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object[])objectArray, (String[])arrayList.toArray(new String[arrayList.size()]))) {
                if (propertyValue.propertyName.equals(MO_ICON_ID_PROP)) {
                    if (propertyValue.resourceObject == null || propertyValue.value == null) continue;
                    this._iconIds.put((ManagedObjectReference)propertyValue.resourceObject, propertyValue.value.toString());
                    continue;
                }
                if (!propertyValue.propertyName.equals(MO_LABELS_IDS_PROPS) || propertyValue.resourceObject == null || propertyValue.value == null) continue;
                this._labelIds.put((ManagedObjectReference)propertyValue.resourceObject, propertyValue.value.toString());
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error retrieving properties: " + arrayList), (Throwable)exception);
        }
    }

    private ManagedObjectReference[] getEntities(AlarmState[] alarmStateArray) {
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        for (AlarmState alarmState : alarmStateArray) {
            hashSet.add(alarmState.entity);
        }
        return hashSet.toArray(new ManagedObjectReference[hashSet.size()]);
    }
}

