/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.HealthStatusChangedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.GlobalObjectUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceAlarmInfoRetriever {
    private static final String EVENT_MANAGER_KEY = "EventManager";
    private static final String SERVICES_PROPERTY_NAME = "vsphere:serviceList";
    private static final String ALARMS_UTIL_SYNC_OBJECT_KEY = "com.vmware.opsmgmt.client.alarms.util.ALARMS_UTIL_SYNC_OBJECT_KEY";
    private static final int MAX_EVENTS_QUERY_SIZE = 1000;
    private static final Log _logger = LogFactory.getLog(ServiceAlarmInfoRetriever.class);
    private static final Log _performanceLogger = LogFactory.getLog((String)"PerformanceAuditingLogger");
    private DataService _dataService;

    public ServiceAlarmInfoRetriever(DataService dataService) {
        this._dataService = dataService;
    }

    public Map<String, ServiceAlarmInfo> retrieve(List<AlarmState> list, String string) {
        Map<String, HealthStatusChangedEvent> map;
        Set<String> set;
        HashMap<String, ServiceAlarmInfo> hashMap = new HashMap<String, ServiceAlarmInfo>();
        ArrayList<AlarmState> arrayList = new ArrayList<AlarmState>();
        for (AlarmState alarmState : list) {
            if (alarmState.alarm == null || alarmState.alarm.getServerGuid() == null || alarmState.eventKey == null) continue;
            arrayList.add(alarmState);
        }
        if (arrayList.size() == 0) {
            return hashMap;
        }
        boolean bl = _performanceLogger.isInfoEnabled();
        long l = 0L;
        long l2 = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        Map<String, List<HealthStatusChangedEvent>> map2 = this.getEventMap(arrayList);
        if (bl) {
            l2 = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: EventMap (part of ServiceAlarmInfos retrieval) retrieved in %d ms.", string, l2 - l));
        }
        if ((set = (map = this.getServiceEventsMap(map2, arrayList)).keySet()).isEmpty()) {
            return hashMap;
        }
        Map<String, URI> map3 = this.getServiceReferencesMap(map2, map, string);
        if (map3.isEmpty()) {
            ListIterator<AlarmState> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                AlarmState alarmState = (AlarmState)listIterator.next();
                String string2 = Util.buildAlarmKey(alarmState);
                if (!set.contains(string2)) continue;
                listIterator.remove();
            }
            return hashMap;
        }
        Map<String, String> map4 = this.getServiceNamesMap(map3, string);
        for (String string3 : set) {
            URI uRI = map3.get(string3);
            String string4 = map4.get(string3);
            HealthStatusChangedEvent healthStatusChangedEvent = map.get(string3);
            ServiceAlarmInfo serviceAlarmInfo = this.createServiceAlarmInfo(healthStatusChangedEvent, string4, uRI);
            hashMap.put(string3, serviceAlarmInfo);
        }
        return hashMap;
    }

    private Map<String, List<HealthStatusChangedEvent>> getEventMap(List<AlarmState> list) {
        HashMap<String, List<HealthStatusChangedEvent>> hashMap = new HashMap<String, List<HealthStatusChangedEvent>>();
        Map<String, Set<Integer>> map = this.getEventKeyMap(list);
        for (String string : map.keySet()) {
            Set<Integer> set = map.get(string);
            if (set == null || set.isEmpty()) continue;
            EventManager eventManager = this.getEventManager(string);
            if (eventManager == null) {
                _logger.error((Object)String.format("Unable to get event manager. Server GUID: %s", string));
                continue;
            }
            ArrayList<HealthStatusChangedEvent> arrayList = new ArrayList<HealthStatusChangedEvent>();
            Integer[] integerArray = set.toArray(new Integer[0]);
            List<Integer[]> list2 = ServiceAlarmInfoRetriever.split(integerArray, 1000);
            for (Integer[] integerArray2 : list2) {
                int[] nArray = new int[integerArray2.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = integerArray2[i];
                }
                Event[] eventArray = eventManager.queryEventsById(nArray);
                if (eventArray == null) continue;
                for (Event event : eventArray) {
                    if (!(event instanceof HealthStatusChangedEvent)) continue;
                    arrayList.add((HealthStatusChangedEvent)event);
                }
            }
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    private Map<String, Set<Integer>> getEventKeyMap(List<AlarmState> list) {
        HashMap<String, Set<Integer>> hashMap = new HashMap<String, Set<Integer>>();
        for (AlarmState alarmState : list) {
            String string = alarmState.alarm.getServerGuid();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new HashSet());
            }
            ((Set)hashMap.get(string)).add(alarmState.eventKey);
        }
        return hashMap;
    }

    private Map<String, HealthStatusChangedEvent> getServiceEventsMap(Map<String, List<HealthStatusChangedEvent>> map, List<AlarmState> list) {
        HashMap<String, HealthStatusChangedEvent> hashMap = new HashMap<String, HealthStatusChangedEvent>();
        block0: for (AlarmState alarmState : list) {
            List<HealthStatusChangedEvent> list2 = map.get(alarmState.alarm.getServerGuid());
            if (list2 == null || list2.isEmpty()) continue;
            for (HealthStatusChangedEvent healthStatusChangedEvent : list2) {
                if (healthStatusChangedEvent.key != alarmState.eventKey) continue;
                hashMap.put(Util.buildAlarmKey(alarmState), healthStatusChangedEvent);
                continue block0;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventManager getEventManager(String string) {
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            return null;
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        if (httpSession == null) {
            return null;
        }
        Object object = SessionUtil.getSyncObject((String)ALARMS_UTIL_SYNC_OBJECT_KEY, (HttpSession)httpSession);
        HashMap<String, Object> hashMap = null;
        Object object2 = object;
        synchronized (object2) {
            hashMap = (HashMap<String, Object>)SessionUtil.getData((String)EVENT_MANAGER_KEY, (HttpSession)httpSession);
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
                SessionUtil.setData((String)EVENT_MANAGER_KEY, hashMap);
            }
            if (hashMap.containsKey(string)) {
                return (EventManager)hashMap.get(string);
            }
        }
        object2 = null;
        try {
            object2 = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vcService.getServiceInstanceContent().eventManager);
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to retrieve event manager for serverGUID: " + string), (Throwable)exception);
            return null;
        }
        Object object3 = object;
        synchronized (object3) {
            hashMap.put(string, object2);
        }
        return object2;
    }

    private ServiceAlarmInfo createServiceAlarmInfo(HealthStatusChangedEvent healthStatusChangedEvent, String string, URI uRI) {
        ServiceAlarmInfo serviceAlarmInfo = new ServiceAlarmInfo();
        serviceAlarmInfo.serviceName = string;
        serviceAlarmInfo.service = uRI;
        serviceAlarmInfo.message = healthStatusChangedEvent.fullFormattedMessage;
        return serviceAlarmInfo;
    }

    private Map<String, URI> getServiceReferencesMap(Map<String, List<HealthStatusChangedEvent>> map, Map<String, HealthStatusChangedEvent> map2, String string) {
        HashMap<String, URI> hashMap = new HashMap<String, URI>();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : map.keySet()) {
            List<HealthStatusChangedEvent> list = map.get(string2);
            block3: for (HealthStatusChangedEvent healthStatusChangedEvent : list) {
                arrayList.add(new Pair((Object)healthStatusChangedEvent.serviceId, (Object)string2));
                for (String object : map2.keySet()) {
                    if (healthStatusChangedEvent.key != map2.get((Object)object).key) continue;
                    arrayList2.add(object);
                    continue block3;
                }
            }
        }
        try {
            QuerySpec querySpec = this.buildServiceReferencesQuery(arrayList.toArray(new Object[0]));
            boolean bl = _performanceLogger.isInfoEnabled();
            long l = 0L;
            long l2 = 0L;
            if (bl) {
                l = System.currentTimeMillis();
            }
            ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
            if (bl) {
                l2 = System.currentTimeMillis();
                _performanceLogger.info((Object)String.format("%s: ServiceReferences (part of ServiceAlarmInfos retrieval) retrieved in: %d ms.", string, l2 - l));
            }
            if (resultSet == null) {
                _logger.error((Object)"Data service returned null result for service URI query");
                return hashMap;
            }
            if (resultSet.error != null || ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
                _logger.warn((Object)"URIs for requested services are not found!", (Throwable)resultSet.error);
                return hashMap;
            }
            URI[] uRIArray = (URI[])resultSet.items[0].properties[0].value;
            for (int i = 0; i < uRIArray.length; ++i) {
                hashMap.put((String)arrayList2.get(i), uRIArray[i]);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return hashMap;
    }

    private Map<String, String> getServiceNamesMap(Map<String, URI> map, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            boolean bl = _performanceLogger.isInfoEnabled();
            long l = 0L;
            long l2 = 0L;
            if (bl) {
                l = System.currentTimeMillis();
            }
            PropertyValue[] propertyValueArray = QueryUtil.getProperty((DataService)this._dataService, (Object[])map.values().toArray(new URI[0]), (String)"name");
            if (bl) {
                l2 = System.currentTimeMillis();
                _performanceLogger.info((Object)String.format("%s: ServiceNames (part of ServiceAlarmInfos retrieval) retrieved in %d ms.", string, l2 - l));
            }
            if (propertyValueArray != null) {
                block2: for (PropertyValue propertyValue : propertyValueArray) {
                    URI uRI = (URI)propertyValue.resourceObject;
                    String string2 = (String)propertyValue.value;
                    for (String string3 : map.keySet()) {
                        if (!uRI.equals(map.get(string3))) continue;
                        hashMap.put(string3, string2);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to retrieve service names", (Throwable)exception);
        }
        return hashMap;
    }

    private QuerySpec buildServiceReferencesQuery(Object[] objectArray) {
        QuerySpec querySpec = new QuerySpec();
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = GlobalObjectUtil.getVSphereClientInstance();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{SERVICES_PROPERTY_NAME};
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.propertyName = SERVICES_PROPERTY_NAME;
        parameterSpec.parameter = objectArray;
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        resourceSpec.constraint = objectIdentityConstraint;
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    private static <T> List<T[]> split(T[] TArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid argument: n");
        }
        if (TArray == null) {
            return Collections.emptyList();
        }
        LinkedList<T[]> linkedList = new LinkedList<T[]>();
        int n2 = 0;
        while (n2 < TArray.length) {
            int n3 = n2 + Math.min(n, TArray.length - n2);
            T[] TArray2 = Arrays.copyOfRange(TArray, n2, n3);
            linkedList.add(TArray2);
            n2 = n3;
        }
        return linkedList;
    }
}

